/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dose.CTScanType;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTScanType
extends TestCase {
    public TestCTScanType(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTScanType");
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Localizer_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Localizer_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Helical_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Helical_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Axial_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Axial_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Stationary_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Stationary_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Free_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Free_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Unknown_Description"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Unknown_Equality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_Localizer_Helical_Inequality"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_SelectFromDescription"));
        testSuite.addTest((Test)new TestCTScanType("TestCTScanType_SelectFromCode"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCTScanType_Localizer_Description() {
        TestCTScanType.assertEquals((String)"Checking LOCALIZER description", (String)CTScanType.LOCALIZER.toString(), (String)"Localizer");
    }

    public void TestCTScanType_Helical_Description() {
        TestCTScanType.assertEquals((String)"Checking HELICAL description", (String)CTScanType.HELICAL.toString(), (String)"Helical");
    }

    public void TestCTScanType_Axial_Description() {
        TestCTScanType.assertEquals((String)"Checking AXIAL description", (String)CTScanType.AXIAL.toString(), (String)"Axial");
    }

    public void TestCTScanType_Stationary_Description() {
        TestCTScanType.assertEquals((String)"Checking STATIONARY description", (String)CTScanType.STATIONARY.toString(), (String)"Stationary");
    }

    public void TestCTScanType_Free_Description() {
        TestCTScanType.assertEquals((String)"Checking FREE description", (String)CTScanType.FREE.toString(), (String)"Free");
    }

    public void TestCTScanType_Unknown_Description() {
        TestCTScanType.assertEquals((String)"Checking UNKNOWN description", (String)CTScanType.UNKNOWN.toString(), (String)"Unknown");
    }

    public void TestCTScanType_Localizer_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking LOCALIZER equality", (Object)CTScanType.LOCALIZER, (Object)CTScanType.LOCALIZER);
        TestCTScanType.assertEquals((String)"Checking LOCALIZER content item hashCode equality", (int)CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER).hashCode(), (int)CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER).hashCode());
        TestCTScanType.assertEquals((String)"Checking LOCALIZER content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER), (Object)CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER));
    }

    public void TestCTScanType_Helical_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking HELICAL equality", (Object)CTScanType.HELICAL, (Object)CTScanType.HELICAL);
        TestCTScanType.assertEquals((String)"Checking HELICAL content item hashCode equality", (int)CTScanType.getCodedSequenceItem(CTScanType.HELICAL).hashCode(), (int)CTScanType.getCodedSequenceItem(CTScanType.HELICAL).hashCode());
        TestCTScanType.assertEquals((String)"Checking HELICAL content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.HELICAL), (Object)CTScanType.getCodedSequenceItem(CTScanType.HELICAL));
    }

    public void TestCTScanType_Axial_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking AXIAL equality", (Object)CTScanType.AXIAL, (Object)CTScanType.AXIAL);
        TestCTScanType.assertEquals((String)"Checking AXIAL content item hashCode equality", (int)CTScanType.getCodedSequenceItem(CTScanType.AXIAL).hashCode(), (int)CTScanType.getCodedSequenceItem(CTScanType.AXIAL).hashCode());
        TestCTScanType.assertEquals((String)"Checking AXIAL content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.AXIAL), (Object)CTScanType.getCodedSequenceItem(CTScanType.AXIAL));
    }

    public void TestCTScanType_Stationary_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking STATIONARY equality", (Object)CTScanType.STATIONARY, (Object)CTScanType.STATIONARY);
        TestCTScanType.assertEquals((String)"Checking STATIONARY content item hashCode equality", (int)CTScanType.getCodedSequenceItem(CTScanType.STATIONARY).hashCode(), (int)CTScanType.getCodedSequenceItem(CTScanType.STATIONARY).hashCode());
        TestCTScanType.assertEquals((String)"Checking STATIONARY content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.STATIONARY), (Object)CTScanType.getCodedSequenceItem(CTScanType.STATIONARY));
    }

    public void TestCTScanType_Free_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking FREE equality", (Object)CTScanType.FREE, (Object)CTScanType.FREE);
        TestCTScanType.assertEquals((String)"Checking FREE content item hashCode equality", (int)CTScanType.getCodedSequenceItem(CTScanType.FREE).hashCode(), (int)CTScanType.getCodedSequenceItem(CTScanType.FREE).hashCode());
        TestCTScanType.assertEquals((String)"Checking FREE content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.FREE), (Object)CTScanType.getCodedSequenceItem(CTScanType.FREE));
    }

    public void TestCTScanType_Unknown_Equality() throws Exception {
        TestCTScanType.assertEquals((String)"Checking UNKNOWN equality", (Object)CTScanType.UNKNOWN, (Object)CTScanType.UNKNOWN);
        TestCTScanType.assertTrue((String)"Checking UNKNOWN content item returns null", (CTScanType.getCodedSequenceItem(CTScanType.UNKNOWN) == null ? 1 : 0) != 0);
        TestCTScanType.assertEquals((String)"Checking UNKNOWN content item equality", (Object)CTScanType.getCodedSequenceItem(CTScanType.UNKNOWN), (Object)CTScanType.getCodedSequenceItem(CTScanType.UNKNOWN));
    }

    public void TestCTScanType_Localizer_Helical_Inequality() throws Exception {
        TestCTScanType.assertTrue((String)"Checking LOCALIZER versus HELICAL inequality", (!CTScanType.LOCALIZER.equals(CTScanType.HELICAL) ? 1 : 0) != 0);
        TestCTScanType.assertFalse((String)"Checking LOCALIZER versus HELICAL content item hashCode inequality", (CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER).hashCode() == CTScanType.getCodedSequenceItem(CTScanType.HELICAL).hashCode() ? 1 : 0) != 0);
        TestCTScanType.assertFalse((String)"Checking LOCALIZER versus HELICAL content item inequality", (boolean)CTScanType.getCodedSequenceItem(CTScanType.LOCALIZER).equals(CTScanType.getCodedSequenceItem(CTScanType.HELICAL)));
    }

    public void TestCTScanType_SelectFromDescription() throws Exception {
        TestCTScanType.assertTrue((String)"Checking select LOCALIZER", (boolean)CTScanType.selectFromDescription("Localizer").equals(CTScanType.LOCALIZER));
        TestCTScanType.assertTrue((String)"Checking select LOCALIZER with Scout", (boolean)CTScanType.selectFromDescription("Scout").equals(CTScanType.LOCALIZER));
        TestCTScanType.assertTrue((String)"Checking select LOCALIZER with CONSTANT_ANGLE", (boolean)CTScanType.selectFromDescription("CONSTANT_ANGLE").equals(CTScanType.LOCALIZER));
        TestCTScanType.assertTrue((String)"Checking select AXIAL", (boolean)CTScanType.selectFromDescription("Axial").equals(CTScanType.AXIAL));
        TestCTScanType.assertTrue((String)"Checking select AXIAL with Sequenced", (boolean)CTScanType.selectFromDescription("Sequenced").equals(CTScanType.AXIAL));
        TestCTScanType.assertTrue((String)"Checking select STATIONARY", (boolean)CTScanType.selectFromDescription("Stationary").equals(CTScanType.STATIONARY));
        TestCTScanType.assertTrue((String)"Checking select STATIONARY", (boolean)CTScanType.selectFromDescription("Cine").equals(CTScanType.STATIONARY));
        TestCTScanType.assertTrue((String)"Checking select FREE", (boolean)CTScanType.selectFromDescription("Free").equals(CTScanType.FREE));
        TestCTScanType.assertTrue((String)"Checking select FREE", (boolean)CTScanType.selectFromDescription("SmartView").equals(CTScanType.FREE));
        TestCTScanType.assertTrue((String)"Checking select HELICAL", (boolean)CTScanType.selectFromDescription("Helical").equals(CTScanType.HELICAL));
        TestCTScanType.assertTrue((String)"Checking select HELICAL with Spiral", (boolean)CTScanType.selectFromDescription("Spiral").equals(CTScanType.HELICAL));
        TestCTScanType.assertTrue((String)"Checking select UNKNOWN", (boolean)CTScanType.selectFromDescription("").equals(CTScanType.UNKNOWN));
    }

    public void TestCTScanType_SelectFromCode() throws Exception {
        TestCTScanType.assertTrue((String)"Checking select LOCALIZER", (boolean)CTScanType.selectFromCode(new CodedSequenceItem("113805", "DCM", "Constant Angle Acquisition")).equals(CTScanType.LOCALIZER));
        TestCTScanType.assertTrue((String)"Checking select AXIAL", (boolean)CTScanType.selectFromCode(new CodedSequenceItem("113804", "DCM", "Sequenced Acquisition")).equals(CTScanType.AXIAL));
        TestCTScanType.assertTrue((String)"Checking select STATIONARY", (boolean)CTScanType.selectFromCode(new CodedSequenceItem("113806", "DCM", "Stationary Acquisition")).equals(CTScanType.STATIONARY));
        TestCTScanType.assertTrue((String)"Checking select FREE", (boolean)CTScanType.selectFromCode(new CodedSequenceItem("113807", "DCM", "Free Acquisition")).equals(CTScanType.FREE));
        TestCTScanType.assertTrue((String)"Checking select HELICAL", (boolean)CTScanType.selectFromCode(new CodedSequenceItem("P5-08001", "SRT", "Spiral Acquisition")).equals(CTScanType.HELICAL));
    }
}

