/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.DeviceParticipant;
import com.pixelmed.dose.PersonParticipant;
import com.pixelmed.dose.RecordingDeviceObserverContext;
import com.pixelmed.dose.RoleInOrganization;
import com.pixelmed.dose.RoleInProcedure;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCommonDoseObserverContext
extends TestCase {
    public TestCommonDoseObserverContext(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCommonDoseObserverContext");
        testSuite.addTest((Test)new TestCommonDoseObserverContext("testCommonDoseObserverContext_WithAllParameters"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testCommonDoseObserverContext_WithAllParameters() throws Exception {
        String string = "1.2.3.4";
        String string2 = "station1";
        String string3 = "Acme";
        String string4 = "Scanner";
        String string5 = "72349236741";
        String string6 = "Suite1";
        String string7 = "Smith^John";
        String string8 = "26354781234";
        String string9 = "Jones^Mary";
        String string10 = "23491234234";
        String string11 = "99BLA";
        String string12 = "St. Elsewhere's";
        CommonDoseObserverContext commonDoseObserverContext = new CommonDoseObserverContext(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12);
        RecordingDeviceObserverContext recordingDeviceObserverContext = commonDoseObserverContext.getRecordingDeviceObserverContext();
        TestCommonDoseObserverContext.assertEquals((String)"Checking uid", (String)string, (String)recordingDeviceObserverContext.getUID());
        TestCommonDoseObserverContext.assertEquals((String)"Checking name", (String)string2, (String)recordingDeviceObserverContext.getName());
        TestCommonDoseObserverContext.assertEquals((String)"Checking manufacturer", (String)string3, (String)recordingDeviceObserverContext.getManufacturer());
        TestCommonDoseObserverContext.assertEquals((String)"Checking modelName", (String)string4, (String)recordingDeviceObserverContext.getModelName());
        TestCommonDoseObserverContext.assertEquals((String)"Checking serialNumber", (String)string5, (String)recordingDeviceObserverContext.getSerialNumber());
        TestCommonDoseObserverContext.assertEquals((String)"Checking location", (String)string6, (String)recordingDeviceObserverContext.getLocation());
        Map<RecordingDeviceObserverContext.Key, ContentItem> map = recordingDeviceObserverContext.getStructuredReportFragment();
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"HAS OBS CONTEXT: CODE: Observer Type = Device", (String)map.get((Object)RecordingDeviceObserverContext.Key.DEVICE).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: UIDREF: Device Observer UID = " + string), (String)map.get((Object)RecordingDeviceObserverContext.Key.UID).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: TEXT: Device Observer Name = " + string2), (String)map.get((Object)RecordingDeviceObserverContext.Key.NAME).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: TEXT: Device Observer Manufacturer = " + string3), (String)map.get((Object)RecordingDeviceObserverContext.Key.MANUFACTURER).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: TEXT: Device Observer Model Name = " + string4), (String)map.get((Object)RecordingDeviceObserverContext.Key.MODEL_NAME).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: TEXT: Device Observer Serial Number = " + string5), (String)map.get((Object)RecordingDeviceObserverContext.Key.SERIAL_NUMBER).toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS OBS CONTEXT: TEXT: Device Observer Physical Location during observation = " + string6), (String)map.get((Object)RecordingDeviceObserverContext.Key.LOCATION).toString());
        DeviceParticipant deviceParticipant = commonDoseObserverContext.getDeviceParticipant();
        TestCommonDoseObserverContext.assertEquals((String)"Checking manufacturer", (String)string3, (String)deviceParticipant.getManufacturer());
        TestCommonDoseObserverContext.assertEquals((String)"Checking modelName", (String)string4, (String)deviceParticipant.getModelName());
        TestCommonDoseObserverContext.assertEquals((String)"Checking serialNumber", (String)string5, (String)deviceParticipant.getSerialNumber());
        ContentItem contentItem = deviceParticipant.getStructuredReportFragment();
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"CONTAINS: CODE: Device Role in Procedure = Irradiating Device", (String)contentItem.toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Manufacturer = " + string3), (String)contentItem.getNamedChild("DCM", "113878").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Model Name = " + string4), (String)contentItem.getNamedChild("DCM", "113879").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Serial Number = " + string5), (String)contentItem.getNamedChild("DCM", "113880").toString());
        PersonParticipant personParticipant = commonDoseObserverContext.getPersonParticipantAdministering();
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator name", (String)string7, (String)personParticipant.getName());
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator roleInProcedure", (Object)RoleInProcedure.IRRADIATION_ADMINISTERING, (Object)personParticipant.getRoleInProcedure());
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator id", (String)string8, (String)personParticipant.getId());
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator idIssuer", (String)string11, (String)personParticipant.getIdIssuer());
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator organization", (String)string12, (String)personParticipant.getOrganization());
        TestCommonDoseObserverContext.assertEquals((String)"Checking operator roleInOrganization", (Object)RoleInOrganization.TECHNOLOGIST, (Object)personParticipant.getRoleInOrganization());
        ContentItem contentItem2 = personParticipant.getStructuredReportFragment();
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("CONTAINS: PNAME: Person Name = " + string7), (String)contentItem2.toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Procedure = Irradiation Administering", (String)contentItem2.getNamedChild("DCM", "113875").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID = " + string8), (String)contentItem2.getNamedChild("DCM", "113871").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID Issuer = " + string11), (String)contentItem2.getNamedChild("DCM", "113872").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Organization Name = " + string12), (String)contentItem2.getNamedChild("DCM", "113873").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Organization = Technologist", (String)contentItem2.getNamedChild("DCM", "113874").toString());
        PersonParticipant personParticipant2 = commonDoseObserverContext.getPersonParticipantAuthorizing();
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician name", (String)string9, (String)personParticipant2.getName());
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician roleInProcedure", (Object)RoleInProcedure.IRRADIATION_AUTHORIZING, (Object)personParticipant2.getRoleInProcedure());
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician id", (String)string10, (String)personParticipant2.getId());
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician idIssuer", (String)string11, (String)personParticipant2.getIdIssuer());
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician organization", (String)string12, (String)personParticipant2.getOrganization());
        TestCommonDoseObserverContext.assertEquals((String)"Checking physician roleInOrganization", (Object)RoleInOrganization.PHYSICIAN, (Object)personParticipant2.getRoleInOrganization());
        ContentItem contentItem3 = personParticipant2.getStructuredReportFragment();
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("CONTAINS: PNAME: Person Name = " + string9), (String)contentItem3.toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Procedure = Irradiation Authorizing", (String)contentItem3.getNamedChild("DCM", "113875").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID = " + string10), (String)contentItem3.getNamedChild("DCM", "113871").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID Issuer = " + string11), (String)contentItem3.getNamedChild("DCM", "113872").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Organization Name = " + string12), (String)contentItem3.getNamedChild("DCM", "113873").toString());
        TestCommonDoseObserverContext.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Organization = Physician", (String)contentItem3.getNamedChild("DCM", "113874").toString());
    }
}

