/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dose.PersonParticipant;
import com.pixelmed.dose.RoleInOrganization;
import com.pixelmed.dose.RoleInProcedure;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPersonParticipant
extends TestCase {
    public TestPersonParticipant(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestPersonParticipant");
        testSuite.addTest((Test)new TestPersonParticipant("TestPersonParticipant_WithAllParameters"));
        testSuite.addTest((Test)new TestPersonParticipant("TestPersonParticipant_WithEmptyName"));
        testSuite.addTest((Test)new TestPersonParticipant("TestPersonParticipant_WithNullName"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestPersonParticipant_WithAllParameters() throws Exception {
        String string = "Smith^John";
        RoleInProcedure roleInProcedure = RoleInProcedure.IRRADIATION_ADMINISTERING;
        String string2 = "74682364821";
        String string3 = "99BLA";
        String string4 = "St. Elsewhere's";
        RoleInOrganization roleInOrganization = RoleInOrganization.TECHNOLOGIST;
        PersonParticipant personParticipant = new PersonParticipant(string, roleInProcedure, string2, string3, string4, roleInOrganization);
        TestPersonParticipant.assertEquals((String)"Checking name", (String)string, (String)personParticipant.getName());
        TestPersonParticipant.assertEquals((String)"Checking roleInProcedure", (Object)roleInProcedure, (Object)personParticipant.getRoleInProcedure());
        TestPersonParticipant.assertEquals((String)"Checking id", (String)string2, (String)personParticipant.getId());
        TestPersonParticipant.assertEquals((String)"Checking idIssuer", (String)string3, (String)personParticipant.getIdIssuer());
        TestPersonParticipant.assertEquals((String)"Checking organization", (String)string4, (String)personParticipant.getOrganization());
        TestPersonParticipant.assertEquals((String)"Checking roleInOrganization", (Object)roleInOrganization, (Object)personParticipant.getRoleInOrganization());
        ContentItem contentItem = personParticipant.getStructuredReportFragment();
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("CONTAINS: PNAME: Person Name = " + string), (String)contentItem.toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Procedure = Irradiation Administering", (String)contentItem.getNamedChild("DCM", "113875").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID = " + string2), (String)contentItem.getNamedChild("DCM", "113871").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID Issuer = " + string3), (String)contentItem.getNamedChild("DCM", "113872").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Organization Name = " + string4), (String)contentItem.getNamedChild("DCM", "113873").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Organization = Technologist", (String)contentItem.getNamedChild("DCM", "113874").toString());
    }

    public void TestPersonParticipant_WithEmptyName() throws Exception {
        String string = "";
        RoleInProcedure roleInProcedure = RoleInProcedure.IRRADIATION_ADMINISTERING;
        String string2 = "74682364821";
        String string3 = "99BLA";
        String string4 = "St. Elsewhere's";
        RoleInOrganization roleInOrganization = RoleInOrganization.TECHNOLOGIST;
        String string5 = "Nobody";
        PersonParticipant personParticipant = new PersonParticipant(string, roleInProcedure, string2, string3, string4, roleInOrganization);
        TestPersonParticipant.assertEquals((String)"Checking name", (String)string, (String)personParticipant.getName());
        TestPersonParticipant.assertEquals((String)"Checking roleInProcedure", (Object)roleInProcedure, (Object)personParticipant.getRoleInProcedure());
        TestPersonParticipant.assertEquals((String)"Checking id", (String)string2, (String)personParticipant.getId());
        TestPersonParticipant.assertEquals((String)"Checking idIssuer", (String)string3, (String)personParticipant.getIdIssuer());
        TestPersonParticipant.assertEquals((String)"Checking organization", (String)string4, (String)personParticipant.getOrganization());
        TestPersonParticipant.assertEquals((String)"Checking roleInOrganization", (Object)roleInOrganization, (Object)personParticipant.getRoleInOrganization());
        ContentItem contentItem = personParticipant.getStructuredReportFragment();
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("CONTAINS: PNAME: Person Name = " + string5), (String)contentItem.toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Procedure = Irradiation Administering", (String)contentItem.getNamedChild("DCM", "113875").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID = " + string2), (String)contentItem.getNamedChild("DCM", "113871").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID Issuer = " + string3), (String)contentItem.getNamedChild("DCM", "113872").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Organization Name = " + string4), (String)contentItem.getNamedChild("DCM", "113873").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Organization = Technologist", (String)contentItem.getNamedChild("DCM", "113874").toString());
    }

    public void TestPersonParticipant_WithNullName() throws Exception {
        String string = null;
        RoleInProcedure roleInProcedure = RoleInProcedure.IRRADIATION_ADMINISTERING;
        String string2 = "74682364821";
        String string3 = "99BLA";
        String string4 = "St. Elsewhere's";
        RoleInOrganization roleInOrganization = RoleInOrganization.TECHNOLOGIST;
        String string5 = "Nobody";
        PersonParticipant personParticipant = new PersonParticipant(string, roleInProcedure, string2, string3, string4, roleInOrganization);
        TestPersonParticipant.assertEquals((String)"Checking name", string, (String)personParticipant.getName());
        TestPersonParticipant.assertEquals((String)"Checking roleInProcedure", (Object)roleInProcedure, (Object)personParticipant.getRoleInProcedure());
        TestPersonParticipant.assertEquals((String)"Checking id", (String)string2, (String)personParticipant.getId());
        TestPersonParticipant.assertEquals((String)"Checking idIssuer", (String)string3, (String)personParticipant.getIdIssuer());
        TestPersonParticipant.assertEquals((String)"Checking organization", (String)string4, (String)personParticipant.getOrganization());
        TestPersonParticipant.assertEquals((String)"Checking roleInOrganization", (Object)roleInOrganization, (Object)personParticipant.getRoleInOrganization());
        ContentItem contentItem = personParticipant.getStructuredReportFragment();
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("CONTAINS: PNAME: Person Name = " + string5), (String)contentItem.toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Procedure = Irradiation Administering", (String)contentItem.getNamedChild("DCM", "113875").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID = " + string2), (String)contentItem.getNamedChild("DCM", "113871").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Person ID Issuer = " + string3), (String)contentItem.getNamedChild("DCM", "113872").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Organization Name = " + string4), (String)contentItem.getNamedChild("DCM", "113873").toString());
        TestPersonParticipant.assertEquals((String)"Checking SR fragment", (String)"HAS PROPERTIES: CODE: Person Role in Organization = Technologist", (String)contentItem.getNamedChild("DCM", "113874").toString());
    }
}

