/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivatePhilipsDoseRelated
extends TestCase {
    public TestSafePrivatePhilipsDoseRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivatePhilipsDoseRelated");
        testSuite.addTest((Test)new TestSafePrivatePhilipsDoseRelated("TestSafePrivatePhilipsDoseRelated_FromTag"));
        testSuite.addTest((Test)new TestSafePrivatePhilipsDoseRelated("TestSafePrivatePhilipsDoseRelated_FromList"));
        testSuite.addTest((Test)new TestSafePrivatePhilipsDoseRelated("TestSafePrivatePhilipsDoseRelated_FromFile"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivatePhilipsDoseRelated_FromTag() throws Exception {
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking DLP is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(225, 4129)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Phantom Type is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(481, 4134)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Acquisition Duration is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(481, 4176)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Acquisition Type is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(497, 4097)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Table Velocity is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(497, 4103)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Pitch is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(497, 4134)));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Rotation Time is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("ELSCINT1", new AttributeTag(497, 4135)));
    }

    public void TestSafePrivatePhilipsDoseRelated_FromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(225, 16));
        ((Attribute)longStringAttribute).addValue("ELSCINT1");
        attributeList.put(longStringAttribute);
        longStringAttribute = new LongStringAttribute(new AttributeTag(481, 16));
        ((Attribute)longStringAttribute).addValue("ELSCINT1");
        attributeList.put(longStringAttribute);
        longStringAttribute = new LongStringAttribute(new AttributeTag(497, 16));
        ((Attribute)longStringAttribute).addValue("ELSCINT1");
        attributeList.put(longStringAttribute);
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking DLP is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(225, 4129), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Phantom Type is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(481, 4134), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Acquisition Duration is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(481, 4176), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Acquisition Type is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(497, 4097), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Table Velocity is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(497, 4103), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Pitch is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(497, 4134), attributeList));
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Rotation Time is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(497, 4135), attributeList));
    }

    public void TestSafePrivatePhilipsDoseRelated_FromFile() throws Exception {
        AttributeList attributeList = new AttributeList();
        String string = System.getProperty("com.pixelmed.test.filepath");
        attributeList.read(new File(string, "philips_brilliance64_sc_blinded.dcm"));
        attributeList.removeUnsafePrivateAttributes();
        AttributeList attributeList2 = ((SequenceAttribute)attributeList.get(TagFromName.ExposureDoseSequence)).getItem(1).getAttributeList();
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList2.get(new AttributeTag(225, 16)) != null ? 1 : 0) != 0);
        TestSafePrivatePhilipsDoseRelated.assertTrue((String)"Checking DLP is not removed", (attributeList2.get(new AttributeTag(225, 4129)) != null ? 1 : 0) != 0);
    }
}

