/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.UUID;

public class UUIDBasedOID {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/UUIDBasedOID.java,v 1.2 2009/11/05 00:06:06 dclunie Exp $";
    protected static final String OID_PREFIX = "2.25";
    protected static final String OID_PREFIX_REMOVAL_REGEX = "^2.25.";
    protected UUID uuid;
    protected String oid;

    public UUIDBasedOID() {
        this.uuid = UUID.randomUUID();
        this.oid = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(this.uuid.toString());
    }

    public UUIDBasedOID(String string) throws IllegalArgumentException, NumberFormatException {
        this.oid = string;
        this.uuid = UUIDBasedOID.parseUUIDFromOID(string);
    }

    public String getOID() {
        return this.oid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static UUID parseUUIDFromOID(String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null || !string.startsWith(OID_PREFIX)) {
            throw new IllegalArgumentException("OID " + string + " does not start with " + OID_PREFIX);
        }
        String string2 = string.replaceFirst(OID_PREFIX_REMOVAL_REGEX, "");
        return UUIDBasedOID.parseUUIDFromDecimalString(string2);
    }

    public static UUID parseUUIDFromDecimalString(String string) throws NumberFormatException {
        BigInteger bigInteger = new BigInteger(string);
        long l = bigInteger.longValue();
        long l2 = bigInteger.shiftRight(64).longValue();
        return new UUID(l2, l);
    }

    public static BigInteger makeBigIntegerFromUnsignedLong(long l) {
        BigInteger bigInteger;
        if (l < 0L) {
            bigInteger = BigInteger.valueOf(l &= Long.MAX_VALUE);
            bigInteger = bigInteger.setBit(63);
        } else {
            bigInteger = BigInteger.valueOf(l);
        }
        return bigInteger;
    }

    public static String createOIDFromUUIDCanonicalHexString(String string) throws IllegalArgumentException {
        UUID uUID = UUID.fromString(string);
        long l = uUID.getLeastSignificantBits();
        long l2 = uUID.getMostSignificantBits();
        BigInteger bigInteger = UUIDBasedOID.makeBigIntegerFromUnsignedLong(l2);
        bigInteger = bigInteger.shiftLeft(64);
        BigInteger bigInteger2 = UUIDBasedOID.makeBigIntegerFromUnsignedLong(l);
        bigInteger = bigInteger.or(bigInteger2);
        return "2.25." + bigInteger.toString();
    }

    public static final void main(String[] stringArray) {
        try {
            int n = Integer.parseInt(stringArray[0]);
            String string = "2.25.329800735698586629295641978511506172918";
            UUID uUID = UUIDBasedOID.parseUUIDFromOID(string);
            System.err.println(uUID);
            UUID uUID2 = UUID.fromString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
            System.err.println("Roundtrip from string parseUUIDFromOID are equal " + uUID.equals(uUID2));
            UUIDBasedOID uUIDBasedOID = new UUIDBasedOID(string);
            uUID = uUIDBasedOID.getUUID();
            System.err.println(uUID);
            System.err.println("Roundtrip from string constructor of UUID are equal " + uUID.equals(uUID2));
            String string2 = uUIDBasedOID.getOID();
            System.err.println("Roundtrip from string constructor of OID are equal " + string2.equals(string));
            System.err.println("Want " + string);
            String string3 = UUIDBasedOID.createOIDFromUUIDCanonicalHexString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
            System.err.println(string3);
            System.err.println("Are equal " + string3.equals(string));
            String string4 = "0b7827e3-35f0-46c0-a2e9-eaf4dadc899b";
            string3 = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(string4);
            System.err.println(string3);
            String string5 = UUIDBasedOID.parseUUIDFromOID(string3).toString();
            System.err.println(string5);
            System.err.println("Are equal " + string5.equals(string4));
            boolean bl = true;
            boolean bl2 = true;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < n; ++i) {
                uUIDBasedOID = new UUIDBasedOID();
                string2 = uUIDBasedOID.getOID();
                int n2 = string2.length();
                if (hashSet.contains(string2)) {
                    System.err.println("Error - not unique - \"" + string2 + "\"");
                    bl = false;
                }
                if (n2 <= 64) continue;
                System.err.println("Error - too long - \"" + string2 + "\" (length = " + n2 + ")");
                bl2 = false;
            }
            System.err.println("Uniqueness check " + (bl ? "passes" : "fails"));
            System.err.println("Length check " + (bl2 ? "passes" : "fails"));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

