/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.validate;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class DicomSRValidator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/validate/DicomSRValidator.java,v 1.4 2010/11/20 17:35:27 dclunie Exp $";
    private Transformer transformerPass1;
    private Transformer transformerPass2;
    OurURIResolver ourURIResolver = new OurURIResolver();

    public void setOptionDescribeChecking(boolean bl) {
        this.transformerPass1.setParameter("optionDescribeChecking", bl ? "T" : "F");
    }

    public void setOptionMatchCaseOfCodeMeaning(boolean bl) {
        this.transformerPass1.setParameter("optionMatchCaseOfCodeMeaning", bl ? "T" : "F");
    }

    public DicomSRValidator() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(this.ourURIResolver);
        this.transformerPass1 = transformerFactory.newTransformer(new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/DicomSRDescriptionsCompiled.xsl")));
        this.setOptionDescribeChecking(false);
        this.setOptionMatchCaseOfCodeMeaning(true);
        this.transformerPass2 = transformerFactory.newTransformer(new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/CheckSRContentItemsUsed.xsl")));
    }

    protected String validateFirstPass(Document document) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException {
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        this.transformerPass1.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString("UTF-8");
    }

    protected String validateSecondPass(Document document, String string) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<founditems>\n");
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.trim().startsWith("<item")) {
                stringBuffer2.append(string2);
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer2.append("</founditems>\n");
        String string3 = stringBuffer2.toString();
        this.ourURIResolver.setFoundItems(string3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.transformerPass2.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        String string4 = byteArrayOutputStream.toString("UTF-8");
        stringBuffer.append(string4);
        stringBuffer.append("IOD validation complete\n");
        return stringBuffer.toString();
    }

    public String validate(AttributeList attributeList) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException {
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(attributeList);
        return this.validateSecondPass(document, this.validateFirstPass(document));
    }

    public String validate(String string) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException, IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        return this.validate(attributeList);
    }

    public static void main(String[] stringArray) {
        try {
            DicomSRValidator dicomSRValidator = new DicomSRValidator();
            System.out.print(dicomSRValidator.validate(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private class OurURIResolver
    implements URIResolver {
        String foundItems;

        private OurURIResolver() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            StreamSource streamSource = null;
            streamSource = string.equals("FoundItems.xml") ? new StreamSource(new StringReader(this.foundItems)) : new StreamSource(DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/" + string));
            return streamSource;
        }

        public void setFoundItems(String string) {
            this.foundItems = string;
        }
    }
}

