/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.RequestTypeServer;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class AppletDisplayRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/AppletDisplayRequestHandler.java,v 1.1 2006/01/06 16:45:10 dclunie Exp $";
    private String appletDisplayTemplateFileName;
    private Comparator compareDatabaseAttributesByInstanceNumber = new CompareDatabaseAttributesByInstanceNumber();

    protected AppletDisplayRequestHandler(String string, String string2, int n) {
        super(string, n);
        this.appletDisplayTemplateFileName = string2;
    }

    private static final double[] getDoubleArrayOrNullFromDatabaseStringValue(String string) {
        double[] dArray = null;
        try {
            if (string != null) {
                dArray = FloatFormatter.fromString(string, '\\');
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            dArray = null;
        }
        return dArray;
    }

    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            Object object;
            Map map = webRequest.getParameters();
            if (map == null) {
                throw new Exception("Missing parameters for requestType \"" + string3 + "\"");
            }
            String string4 = (String)map.get("primaryKey");
            if (string4 == null || string4.length() == 0) {
                throw new Exception("Missing primaryKey parameter for requestType \"" + string3 + "\"");
            }
            String string5 = (String)map.get("studyUID");
            if (string5 == null || string5.length() == 0) {
                throw new Exception("Missing studyUID parameter for requestType \"" + string3 + "\"");
            }
            String string6 = (String)map.get("seriesUID");
            if (string6 == null || string6.length() == 0) {
                throw new Exception("Missing seriesUID parameter for requestType \"" + string3 + "\"");
            }
            InputStream inputStream = RequestTypeServer.class.getResourceAsStream("/com/pixelmed/web/" + this.appletDisplayTemplateFileName);
            if (inputStream == null) {
                throw new Exception("No page template \"" + this.appletDisplayTemplateFileName + "\"");
            }
            String string7 = FileUtilities.readFile(inputStream);
            if (this.webServerDebugLevel > 2) {
                System.err.println("AppletDisplayRequestHandler.generateResponseToGetRequest(): Template is " + string7);
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string8 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.INSTANCE).toUpperCase();
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.INSTANCE, string4);
            Collections.sort(arrayList, this.compareDatabaseAttributesByInstanceNumber);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object = (Map)arrayList.get(i);
                String string9 = (String)object.get("SOPINSTANCEUID");
                String string10 = (String)object.get(string8);
                stringBuffer.append("<PARAM NAME = \"imgURL");
                stringBuffer.append(Integer.toString(i));
                stringBuffer.append("\" VALUE = \"");
                stringBuffer.append(string);
                stringBuffer.append("?requestType=WADO");
                stringBuffer.append("&contentType=application/dicom");
                stringBuffer.append("&studyUID=");
                stringBuffer.append(string5);
                stringBuffer.append("&seriesUID=");
                stringBuffer.append(string6);
                stringBuffer.append("&objectUID=");
                stringBuffer.append(string9);
                stringBuffer.append("\">\n");
            }
            stringBuffer.append("\n");
            String string11 = Integer.toString(n);
            if (this.webServerDebugLevel > 2) {
                System.err.println("AppletDisplayRequestHandler.generateResponseToGetRequest(): numberOfInstanceReplacement is " + string11);
            }
            string7 = string7.replaceFirst("####REPLACEMEWITHNUMBEROFIMAGEFILES####", string11);
            object = stringBuffer.toString();
            if (this.webServerDebugLevel > 2) {
                System.err.println("AppletDisplayRequestHandler.generateResponseToGetRequest(): imageURLsReplacement is " + (String)object);
            }
            string7 = string7.replaceFirst("####REPLACEMEWITHLISTOFIMAGEURLSASPARAMETERS####", (String)object);
            string7 = string7.replaceAll("####REPLACEMEWITHROOTURL####", string);
            if (this.webServerDebugLevel > 2) {
                System.err.println("AppletDisplayRequestHandler.generateResponseToGetRequest(): Response after replacement is " + string7);
            }
            this.sendHeaderAndBodyText(outputStream, string7, "imagedisplay.html", "text/html");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            if (this.webServerDebugLevel > 0) {
                System.err.println("AppletDisplayRequestHandler.generateResponseToGetRequest(): Sending 404 Not Found");
            }
            AppletDisplayRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesByInstanceNumber
    implements Comparator {
        private CompareDatabaseAttributesByInstanceNumber() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = (String)((Map)object).get("INSTANCENUMBER");
            String string2 = (String)((Map)object2).get("INSTANCENUMBER");
            try {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
            return n;
        }
    }
}

