/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SRBShadowFile
extends SRBRandomAccessFile {
    private String shadowPath;
    private int fileType = 0;

    public SRBShadowFile(SRBFile sRBFile, String string) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(sRBFile, "r");
        if (string == null) {
            string = "";
        }
        this.shadowPath = string;
        this.open(sRBFile);
    }

    public SRBShadowFile(SRBShadowFile sRBShadowFile, String string) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(sRBShadowFile.getSRBFile(), "r");
        if (string == null) {
            sRBShadowFile.getShadowPath();
        } else {
            this.shadowPath = sRBShadowFile.getShadowPath() + SRBFile.separator + string;
        }
        this.open(sRBShadowFile.getSRBFile());
    }

    protected void open(GeneralFile generalFile) throws IOException {
        if (this.shadowPath == null) {
            return;
        }
        this.file = generalFile;
        this.fd = this.fileSystem.srbObjOpen(generalFile.getName() + "&SHADOW=" + this.shadowPath, 0, generalFile.getParent());
        this.fileType = 1;
    }

    public SRBFile getSRBFile() {
        if (this.file != null) {
            return (SRBFile)this.file;
        }
        throw new NullPointerException();
    }

    public String getShadowPath() {
        return this.shadowPath;
    }

    public long length() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLength(long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        switch (this.rw) {
            case 0: {
                return this.file.getAbsolutePath() + "/" + this.shadowPath + " : r";
            }
            case 1: {
                return this.file.getAbsolutePath() + "/" + this.shadowPath + " : rw";
            }
            case 2: {
                return this.file.getAbsolutePath() + "/" + this.shadowPath + " : rws";
            }
            case 3: {
                return this.file.getAbsolutePath() + "/" + this.shadowPath + " : rwd";
            }
        }
        return this.file.getAbsolutePath() + "/" + this.shadowPath;
    }

    boolean exists() {
        Object var1_1 = null;
        boolean bl = false;
        if (this.fileType == 2) {
            return true;
        }
        return this.fileType == 1;
    }

    boolean isDirectory() {
        return this.fileType == 2;
    }

    boolean isFile() {
        return this.fileType == 1;
    }

    public String[] list() {
        Vector<String> vector;
        block9: {
            vector = new Vector<String>();
            String string = "";
            int n = 0;
            try {
                String string2 = ((SRBFile)this.file).getServerLocalPath();
                n = string2.indexOf("/?SHADOW");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                InputStream inputStream = this.fileSystem.executeProxyCommand("ls", string2 + SRBFile.separator + this.shadowPath);
                int n2 = inputStream.read();
                while (n2 != -1) {
                    if ((char)n2 == '\n') {
                        n = string.lastIndexOf(SRBFile.separator);
                        if (n >= 0) {
                            string = string.substring(n);
                        }
                        vector.add(string);
                        string = "";
                    } else {
                        string = string + (char)n2;
                    }
                    n2 = inputStream.read();
                }
            }
            catch (SRBException sRBException) {
                if (SRBCommands.DEBUG > 0) {
                    sRBException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block9;
                iOException.printStackTrace();
            }
        }
        return vector.toArray(new String[0]);
    }

    public SRBShadowFile[] listFiles() {
        String[] stringArray = this.list();
        int n = stringArray.length;
        SRBShadowFile[] sRBShadowFileArray = new SRBShadowFile[n];
        try {
            for (int i = 0; i < n; ++i) {
                sRBShadowFileArray[i] = new SRBShadowFile(this, stringArray[i]);
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        return sRBShadowFileArray;
    }
}

