/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class ServletContextResource
extends AbstractResource {
    private final ServletContext servletContext;
    private final String path;

    public ServletContextResource(ServletContext servletContext, String path) {
        Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
        this.servletContext = servletContext;
        Assert.notNull((Object)path, (String)"path is required");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = StringUtils.cleanPath((String)path);
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final String getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.servletContext.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.servletContext.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    public File getFile() throws IOException {
        String realPath = WebUtils.getRealPath(this.servletContext, this.path);
        return new File(realPath);
    }

    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = StringUtils.applyRelativePath((String)this.path, (String)relativePath);
        return new ServletContextResource(this.servletContext, pathToUse);
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return "ServletContext resource [" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServletContextResource) {
            ServletContextResource otherRes = (ServletContextResource)((Object)obj);
            return this.servletContext.equals(otherRes.servletContext) && this.path.equals(otherRes.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

