/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Properties;
import org.dcm4che2.data.ConfigurationError;
import org.dcm4che2.util.CloseUtils;

public class UIDUtils {
    private static final String UIDUTILS_PROPS = "org/dcm4che2/util/UIDUtils.properties";
    private static final int EXPECT_DOT = 0;
    private static final int EXPECT_FIRST_DIGIT = 1;
    private static final int EXPECT_DOT_OR_DIGIT = 2;
    private static final int ILLEGAL_UID = -1;
    private static final String hostAddress;
    private static final String hostUnique;
    private static String lastTime;
    private static short lastCount;
    private static String root;
    private static boolean useHostAddress;
    private static boolean useHostUnique;
    private static Object lock;
    private static boolean acceptLeadingZero;

    private static boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    public static final boolean isAcceptLeadingZero() {
        return acceptLeadingZero;
    }

    public static final void setAcceptLeadingZero(boolean acceptLeadingZero) {
        UIDUtils.acceptLeadingZero = acceptLeadingZero;
    }

    private static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    private static void appendInt(int i, int width, StringBuffer sb) {
        String s = Integer.toString(i);
        for (i = s.length(); i < width; ++i) {
            sb.append('0');
        }
        sb.append(s);
    }

    private static String getTime() {
        Calendar cal = Calendar.getInstance();
        StringBuffer sb = new StringBuffer(17);
        sb.append(cal.get(1));
        UIDUtils.appendInt(cal.get(2) + 1, 2, sb);
        UIDUtils.appendInt(cal.get(5), 2, sb);
        UIDUtils.appendInt(cal.get(11), 2, sb);
        UIDUtils.appendInt(cal.get(12), 2, sb);
        UIDUtils.appendInt(cal.get(13), 2, sb);
        UIDUtils.appendInt(cal.get(14), 3, sb);
        return sb.toString();
    }

    private static String getHostUnique() {
        return Long.toString((long)new Object().hashCode() & 0xFFFFFFFFL);
    }

    public static void setRoot(String root) {
        UIDUtils.verifyUID(root);
        UIDUtils.verifyMaxCreatedUIDLength(root, useHostAddress, useHostUnique);
        UIDUtils.root = root;
    }

    private static void verifyMaxCreatedUIDLength(String root, boolean useHostAddress, boolean useHostUnique) {
        int len = root.length();
        if (useHostAddress) {
            len += 16;
        }
        if (useHostUnique) {
            len += 11;
        }
        if (len > 40) {
            throw new IllegalArgumentException("With root=" + root + ", useHostAddress=" + useHostAddress + ", useHostUnique=" + useHostUnique + " created UIDs exceeds length limit of 64.");
        }
    }

    public static String getRoot() {
        return root;
    }

    public static final boolean isUseHostAddress() {
        return useHostAddress;
    }

    public static final void setUseHostAddress(boolean useHostAddress) {
        if (useHostAddress) {
            UIDUtils.verifyMaxCreatedUIDLength(root, useHostAddress, useHostUnique);
        }
        UIDUtils.useHostAddress = useHostAddress;
    }

    public static boolean isUseHostUnique() {
        return useHostUnique;
    }

    public static void setUseHostUnique(boolean useHostUnique) {
        if (useHostUnique) {
            UIDUtils.verifyMaxCreatedUIDLength(root, useHostAddress, useHostUnique);
        }
        UIDUtils.useHostUnique = useHostUnique;
    }

    public static void verifyUID(String uid) {
        UIDUtils.verifyUID(uid, acceptLeadingZero);
    }

    public static void verifyUID(String uid, boolean acceptLeadingZero) {
        if (!UIDUtils.isValidUID(uid, acceptLeadingZero)) {
            throw new IllegalArgumentException(uid);
        }
    }

    public static boolean isValidUID(String uid) {
        return UIDUtils.isValidUID(uid, acceptLeadingZero);
    }

    public static boolean isValidUID(String uid, boolean acceptLeadingZero) {
        int len = uid.length();
        if (len > 64) {
            return false;
        }
        int state = 1;
        for (int i = 0; i < len; ++i) {
            if ((state = UIDUtils.nextState(state, uid.charAt(i), acceptLeadingZero)) != -1) continue;
            return false;
        }
        return state != 1;
    }

    private static int nextState(int state, int ch, boolean acceptLeadingZero) {
        return ch == 46 ? (state == 1 ? -1 : 1) : (state == 0 || ch < 48 || ch > 57 ? -1 : (!acceptLeadingZero && state == 1 && ch == 48 ? 0 : 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUID() {
        StringBuffer sb = new StringBuffer(64).append(root).append('.');
        if (useHostAddress) {
            sb.append(hostAddress).append('.');
        }
        if (useHostUnique) {
            sb.append(hostUnique).append('.');
        }
        Object object = lock;
        synchronized (object) {
            if (lastCount == 0) {
                lastTime = UIDUtils.getTime();
                lastCount = 1;
            }
            short s = lastCount;
            lastCount = (short)(s + 1);
            sb.append(lastTime).append('.').append(s & 0xFFFF);
        }
        return sb.toString();
    }

    static {
        InputStream is;
        hostAddress = UIDUtils.getHostAddress();
        hostUnique = UIDUtils.getHostUnique();
        lastTime = UIDUtils.getTime();
        lastCount = 1;
        lock = new Object();
        acceptLeadingZero = false;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if ((cl == null || (is = cl.getResourceAsStream(UIDUTILS_PROPS)) == null) && (is = UIDUtils.class.getClassLoader().getResourceAsStream(UIDUTILS_PROPS)) == null) {
            throw new ConfigurationError("Missing Resource: org/dcm4che2/util/UIDUtils.properties");
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException e) {
            throw new ConfigurationError("Failed to load resource org/dcm4che2/util/UIDUtils.properties", e);
        }
        finally {
            CloseUtils.safeClose(is);
        }
        useHostAddress = UIDUtils.toBoolean(p.getProperty("useHostAddress"));
        useHostUnique = UIDUtils.toBoolean(p.getProperty("useHostUnique"));
        UIDUtils.setRoot(p.getProperty("root"));
    }
}

