/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.LongTTCItem;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class NonPlsqlTTCColumn
extends TTCColumn {
    private int row;
    private TTCItem[] items;
    private boolean marshaling;

    protected NonPlsqlTTCColumn(TTIoac tTIoac, int n, boolean bl, TTCItem[] tTCItemArray) {
        super(tTIoac, n);
        this.items = tTCItemArray;
        this.marshaling = bl;
    }

    protected boolean sizeExceeded() throws SQLException, IOException {
        int n = 4000;
        short s = this.items[this.row].meg.types.getVersion();
        n = s < 8030 ? 2000 : 4000;
        boolean bl = false;
        if (this.type.type != 999 && this.type.type != 96 && this.type.type != 1 && this.type.type != 8 && this.type.type != 24) {
            return false;
        }
        if (this.type.max_length > n) {
            bl = true;
        }
        return bl;
    }

    protected void marshal() throws IOException, SQLException {
        this.items[this.row].marshal();
        ++this.row;
    }

    public void clearNull() throws SQLException {
        if (this.type.isStream()) {
            this.items[this.row].is_null = false;
        }
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.marshaling) {
            DBError.check_error(424);
        }
        if (this.type.isStream()) {
            return true;
        }
        this.items[this.row].unmarshal();
        this.items[this.row++].unmarshalIndicator();
        return false;
    }

    protected void pushStream() throws IOException {
        ((LongTTCItem)this.items[this.row]).putStream();
        ++this.row;
    }

    protected void setItemOriginalSize(int n) throws SQLException, IOException {
        int n2 = this.items[n].meg.processIndicator(this.items[n].isNull(), this.items[n].getDataSize());
        this.items[n].setOriginalSize(n2);
    }

    protected boolean moreRows() {
        return this.row < this.rowsDepth;
    }

    protected void print(int n, int n2, int n3) {
    }
}

