/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfSlice;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class GeometryOfSliceFromAttributeList
extends GeometryOfSlice {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/GeometryOfSliceFromAttributeList.java,v 1.9 2005/10/25 17:57:15 dclunie Exp $";

    public GeometryOfSliceFromAttributeList(AttributeList attributeList) throws DicomException {
        this.tlhcArray = Attribute.getDoubleValues(attributeList, TagFromName.ImagePositionPatient);
        double[] dArray = Attribute.getDoubleValues(attributeList, TagFromName.PixelSpacing);
        this.voxelSpacingArray = new double[3];
        this.voxelSpacingArray[0] = dArray[0];
        this.voxelSpacingArray[1] = dArray[1];
        this.voxelSpacingArray[2] = 0.0;
        this.sliceThickness = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.SliceThickness, 0.0);
        double[] dArray2 = Attribute.getDoubleValues(attributeList, TagFromName.ImageOrientationPatient);
        this.rowArray = new double[3];
        this.rowArray[0] = dArray2[0];
        this.rowArray[1] = dArray2[1];
        this.rowArray[2] = dArray2[2];
        this.columnArray = new double[3];
        this.columnArray[0] = dArray2[3];
        this.columnArray[1] = dArray2[4];
        this.columnArray[2] = dArray2[5];
        double[] dArray3 = new double[]{Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0), Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0), 1.0};
        this.row = new Vector3d(this.rowArray);
        this.column = new Vector3d(this.columnArray);
        this.tlhc = new Point3d(this.tlhcArray);
        this.voxelSpacing = new Vector3d(this.voxelSpacingArray);
        this.dimensions = new Vector3d(dArray3);
        this.makeNormal();
    }
}

