/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.FloatFormatter;
import java.util.ArrayList;
import java.util.Iterator;

public class RealWorldValueTransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/RealWorldValueTransform.java,v 1.11 2006/03/24 17:22:07 dclunie Exp $";
    private SingleRealWorldValueTransforms[] arrayOfTransforms = null;
    private SingleRealWorldValueTransforms commonTransforms = null;
    private final int precisionToDisplayDouble = 4;
    private final int maximumIntegerDigits = 8;
    private final int maximumMaximumFractionDigits = 6;

    public RealWorldValueTransform(AttributeList attributeList) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute != null) {
            int n = sequenceAttribute.getNumberOfItems();
            int n2 = 0;
            object8 = sequenceAttribute.iterator();
            while (object8.hasNext()) {
                object7 = (SequenceItem)object8.next();
                object6 = ((SequenceItem)object7).getAttributeList();
                if (object6 != null) {
                    object5 = (SequenceAttribute)((AttributeList)object6).get(TagFromName.RealWorldValueMappingSequence);
                    if (object5 != null && ((SequenceAttribute)object5).getNumberOfItems() >= 1) {
                        if (this.arrayOfTransforms == null) {
                            this.arrayOfTransforms = new SingleRealWorldValueTransforms[n];
                        }
                        if (this.arrayOfTransforms[n2] == null) {
                            this.arrayOfTransforms[n2] = new SingleRealWorldValueTransforms();
                        }
                        object4 = ((SequenceAttribute)object5).iterator();
                        while (object4.hasNext()) {
                            object3 = (SequenceItem)object4.next();
                            object2 = ((SequenceItem)object3).getAttributeList();
                            this.arrayOfTransforms[n2].add(new SingleRealWorldValueTransform((AttributeList)object2));
                        }
                    }
                    if ((object4 = (SequenceAttribute)((AttributeList)object6).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)object4).getNumberOfItems() >= 1) {
                        if (this.arrayOfTransforms == null) {
                            this.arrayOfTransforms = new SingleRealWorldValueTransforms[n];
                        }
                        if (this.arrayOfTransforms[n2] == null) {
                            this.arrayOfTransforms[n2] = new SingleRealWorldValueTransforms();
                        }
                        object3 = ((SequenceAttribute)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (SequenceItem)object3.next();
                            object = ((SequenceItem)object2).getAttributeList();
                            this.arrayOfTransforms[n2].add(new SingleRealWorldValueTransform((AttributeList)object, string));
                        }
                    }
                }
                ++n2;
            }
        }
        if (this.arrayOfTransforms == null) {
            Iterator iterator;
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            if (sequenceAttribute2 != null && (iterator = sequenceAttribute2.iterator()).hasNext() && (object7 = ((SequenceItem)(object8 = (SequenceItem)iterator.next())).getAttributeList()) != null) {
                object6 = (SequenceAttribute)((AttributeList)object7).get(TagFromName.RealWorldValueMappingSequence);
                if (object6 != null && ((SequenceAttribute)object6).getNumberOfItems() >= 1) {
                    if (this.commonTransforms == null) {
                        this.commonTransforms = new SingleRealWorldValueTransforms();
                    }
                    object5 = ((SequenceAttribute)object6).iterator();
                    while (object5.hasNext()) {
                        object4 = (SequenceItem)object5.next();
                        object3 = ((SequenceItem)object4).getAttributeList();
                        this.commonTransforms.add(new SingleRealWorldValueTransform((AttributeList)object3));
                    }
                }
                if ((object5 = (SequenceAttribute)((AttributeList)object7).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)object5).getNumberOfItems() >= 1) {
                    if (this.commonTransforms == null) {
                        this.commonTransforms = new SingleRealWorldValueTransforms();
                    }
                    object4 = ((SequenceAttribute)object5).iterator();
                    while (object4.hasNext()) {
                        object3 = (SequenceItem)object4.next();
                        object2 = ((SequenceItem)object3).getAttributeList();
                        object = new SingleRealWorldValueTransform((AttributeList)object2, string);
                        if (((SingleRealWorldValueTransform)object).isIdentityAndUnitsUnspecified()) continue;
                        this.commonTransforms.add(object);
                    }
                }
            }
            Attribute attribute = attributeList.get(TagFromName.RescaleSlope);
            object8 = attributeList.get(TagFromName.RescaleIntercept);
            if (attribute != null && object8 != null) {
                if (this.commonTransforms == null) {
                    this.commonTransforms = new SingleRealWorldValueTransforms();
                }
                if (!((SingleRealWorldValueTransform)(object7 = new SingleRealWorldValueTransform(attributeList, string))).isIdentityAndUnitsUnspecified()) {
                    this.commonTransforms.add(object7);
                }
            }
        }
    }

    public String toString(int n, int n2) {
        SingleRealWorldValueTransforms singleRealWorldValueTransforms;
        StringBuffer stringBuffer = new StringBuffer();
        SingleRealWorldValueTransforms singleRealWorldValueTransforms2 = singleRealWorldValueTransforms = this.arrayOfTransforms == null ? this.commonTransforms : this.arrayOfTransforms[n];
        if (singleRealWorldValueTransforms != null) {
            for (SingleRealWorldValueTransform singleRealWorldValueTransform : singleRealWorldValueTransforms) {
                if (singleRealWorldValueTransform.rangeOfValues != null && (singleRealWorldValueTransform.rangeOfValues[0] > n2 || n2 > singleRealWorldValueTransform.rangeOfValues[1])) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                double d = (double)n2 * singleRealWorldValueTransform.slope + singleRealWorldValueTransform.intercept;
                stringBuffer.append(FloatFormatter.toString(d));
                stringBuffer.append(" ");
                stringBuffer.append(singleRealWorldValueTransform.units);
            }
        }
        return stringBuffer.toString();
    }

    private class SingleRealWorldValueTransforms
    extends ArrayList {
        private SingleRealWorldValueTransforms() {
        }
    }

    private class SingleRealWorldValueTransform {
        int[] rangeOfValues;
        double slope;
        double intercept;
        String units;

        SingleRealWorldValueTransform(AttributeList attributeList) {
            if (attributeList != null) {
                this.rangeOfValues = new int[2];
                this.rangeOfValues[0] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.RealWorldValueFirstValueMapped, 0);
                this.rangeOfValues[1] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.RealWorldValueLastValueMapped, 0);
                this.slope = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RealWorldValueSlope, 0.0);
                this.intercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RealWorldValueIntercept, 0.0);
                this.units = SequenceAttribute.getMeaningOfCodedSequenceAttributeOrDefault(attributeList, TagFromName.MeasurementUnitsCodeSequence, "");
            }
        }

        SingleRealWorldValueTransform(AttributeList attributeList, String string) {
            if (attributeList != null) {
                this.rangeOfValues = null;
                this.slope = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 1.0);
                this.intercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                String string2 = "??";
                String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.RescaleType);
                String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Units);
                if (string.equals("1.2.840.10008.5.1.4.1.1.128") && string4 != null && string4.length() > 0) {
                    string2 = string4;
                } else if (string3 != null && string3.length() > 0) {
                    string2 = string3;
                } else if (string.equals("1.2.840.10008.5.1.4.1.1.2")) {
                    string2 = "HU";
                }
                this.units = string2;
            }
        }

        boolean isIdentityAndUnitsUnspecified() {
            return this.slope == 1.0 && this.intercept == 0.0 && (this.units == null || this.units.equals("US") || this.units.equals("??"));
        }
    }
}

