/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.XMLRepresentationOfDicomObjectFactory;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLRepresentationOfStructuredReportObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/XMLRepresentationOfStructuredReportObjectFactory.java,v 1.9 2008/04/16 10:43:12 dclunie Exp $";
    protected static String contentItemIdentiferPrefix = "ci_";
    private DocumentBuilder db;

    private void addCodedConceptAttributesToDocumentNode(Node node, Document document, CodedSequenceItem codedSequenceItem) {
        if (codedSequenceItem != null) {
            Object object;
            Object object2;
            String string = codedSequenceItem.getCodeMeaning();
            if (string != null) {
                object2 = document.createAttribute("cm");
                object2.setValue(string);
                node.getAttributes().setNamedItem((Node)object2);
            }
            if ((object2 = codedSequenceItem.getCodeValue()) != null) {
                object = document.createAttribute("cv");
                object.setValue((String)object2);
                node.getAttributes().setNamedItem((Node)object);
            }
            if ((object = codedSequenceItem.getCodingSchemeDesignator()) != null) {
                Attr attr = document.createAttribute("csd");
                attr.setValue((String)object);
                node.getAttributes().setNamedItem(attr);
            }
        }
    }

    private void addContentItemsFromTreeToNode(ContentItem contentItem, Document document, Node node, String string) {
        if (contentItem != null) {
            Object object;
            Element element = null;
            String string2 = contentItem.getValueType();
            if (string2 != null && string2.length() > 0) {
                object = string2.toLowerCase();
                element = document.createElement((String)object);
            } else {
                element = document.createElement("reference");
            }
            if (element != null) {
                Node node2;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                node.appendChild(element);
                if (string != null && string.length() > 0) {
                    object = document.createAttribute("ID");
                    object.setValue(contentItemIdentiferPrefix + string);
                    element.getAttributes().setNamedItem((Node)object);
                }
                if ((object = contentItem.getRelationshipType()) != null && ((String)object).length() > 0) {
                    object5 = document.createAttribute("relationship");
                    object5.setValue((String)object);
                    element.getAttributes().setNamedItem((Node)object5);
                }
                if ((object5 = contentItem.getReferencedContentItemIdentifier()) != null && ((String)object5).length() > 0) {
                    object4 = document.createAttribute("IDREF");
                    object4.setValue(contentItemIdentiferPrefix + (String)object5);
                    element.getAttributes().setNamedItem((Node)object4);
                }
                if ((object4 = contentItem.getConceptName()) != null) {
                    object3 = document.createElement("concept");
                    element.appendChild((Node)object3);
                    this.addCodedConceptAttributesToDocumentNode((Node)object3, document, (CodedSequenceItem)object4);
                }
                if (contentItem instanceof ContentItemFactory.ContainerContentItem) {
                    Object object6;
                    Object object7;
                    object3 = ((ContentItemFactory.ContainerContentItem)contentItem).getContinuityOfContent();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createAttribute("continuity");
                        object2.setValue((String)object3);
                        element.getAttributes().setNamedItem((Node)object2);
                    }
                    if ((object2 = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateMappingResource()) != null && ((String)object2).length() > 0) {
                        object7 = document.createAttribute("templatemappingresource");
                        object7.setValue((String)object2);
                        element.getAttributes().setNamedItem((Node)object7);
                    }
                    if ((object7 = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateIdentifier()) != null && ((String)object7).length() > 0) {
                        object6 = document.createAttribute("template");
                        object6.setValue((String)object7);
                        element.getAttributes().setNamedItem((Node)object6);
                    }
                    if ((object6 = ((ContentItemFactory.ContainerContentItem)contentItem).getSOPClassUID()) != null && ((String)object6).length() > 0) {
                        node2 = document.createAttribute("sopclass");
                        node2.setValue((String)object6);
                        element.getAttributes().setNamedItem(node2);
                    }
                } else if (contentItem instanceof ContentItemFactory.CodeContentItem) {
                    object3 = ((ContentItemFactory.CodeContentItem)contentItem).getConceptCode();
                    if (object3 != null) {
                        object2 = document.createElement("value");
                        element.appendChild((Node)object2);
                        this.addCodedConceptAttributesToDocumentNode((Node)object2, document, (CodedSequenceItem)object3);
                    }
                } else if (contentItem instanceof ContentItemFactory.NumericContentItem) {
                    Object object8;
                    object3 = ((ContentItemFactory.NumericContentItem)contentItem).getNumericValue();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("value");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                    if ((object2 = ((ContentItemFactory.NumericContentItem)contentItem).getUnits()) != null) {
                        object8 = document.createElement("units");
                        element.appendChild((Node)object8);
                        this.addCodedConceptAttributesToDocumentNode((Node)object8, document, (CodedSequenceItem)object2);
                    }
                    if ((object8 = ((ContentItemFactory.NumericContentItem)contentItem).getQualifier()) != null) {
                        Element element2 = document.createElement("qualifier");
                        element.appendChild(element2);
                        this.addCodedConceptAttributesToDocumentNode(element2, document, (CodedSequenceItem)object8);
                    }
                } else if (contentItem instanceof ContentItemFactory.StringContentItem) {
                    object3 = ((ContentItemFactory.StringContentItem)contentItem).getConceptValue();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("value");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                } else if (contentItem instanceof ContentItemFactory.SpatialCoordinatesContentItem) {
                    object3 = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicType();
                    if (object3 != null) {
                        object2 = document.createElement(((String)object3).toLowerCase());
                        element.appendChild((Node)object2);
                        float[] fArray = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicData();
                        if (fArray != null) {
                            for (int i = 0; i < fArray.length; ++i) {
                                node2 = document.createElement(i % 2 == 0 ? "x" : "y");
                                object2.appendChild(node2);
                                node2.appendChild(document.createTextNode(FloatFormatter.toString(fArray[i])));
                            }
                        }
                    }
                } else if (contentItem instanceof ContentItemFactory.TemporalCoordinatesContentItem) {
                    object3 = (ContentItemFactory.TemporalCoordinatesContentItem)contentItem;
                    object2 = ((ContentItemFactory.TemporalCoordinatesContentItem)object3).getTemporalRangeType();
                    if (object2 != null) {
                        Element element3;
                        int n;
                        Element element4 = document.createElement(((String)object2).toLowerCase());
                        element.appendChild(element4);
                        Object[] objectArray = ((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedSamplePositions();
                        if (objectArray != null) {
                            node2 = document.createElement("samplepositions");
                            element4.appendChild(node2);
                            for (n = 0; n < objectArray.length; ++n) {
                                element3 = document.createElement("position");
                                node2.appendChild(element3);
                                element3.appendChild(document.createTextNode(Integer.toString(objectArray[n])));
                            }
                        }
                        if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedTimeOffsets()) != null) {
                            node2 = document.createElement("timeoffsets");
                            element4.appendChild(node2);
                            for (n = 0; n < objectArray.length; ++n) {
                                element3 = document.createElement("offset");
                                node2.appendChild(element3);
                                element3.appendChild(document.createTextNode(FloatFormatter.toString(objectArray[n])));
                            }
                        }
                        if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object3).getReferencedDateTimes()) != null) {
                            node2 = document.createElement("datetimes");
                            element4.appendChild(node2);
                            for (n = 0; n < objectArray.length; ++n) {
                                element3 = document.createElement("datetime");
                                node2.appendChild(element3);
                                element3.appendChild(document.createTextNode((String)objectArray[n]));
                            }
                        }
                    }
                } else if (contentItem instanceof ContentItemFactory.CompositeContentItem) {
                    object3 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPClassUID();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("class");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                    if ((object3 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPInstanceUID()) != null && ((String)object3).length() > 0) {
                        object2 = document.createElement("instance");
                        element.appendChild((Node)object2);
                        object2.appendChild(document.createTextNode((String)object3));
                    }
                    if (contentItem instanceof ContentItemFactory.ImageContentItem) {
                        Element element5;
                        Element element6;
                        Object object9;
                        object3 = (ContentItemFactory.ImageContentItem)contentItem;
                        int n = ((ContentItemFactory.ImageContentItem)object3).getReferencedFrameNumber();
                        if (n != 0) {
                            object9 = document.createElement("frame");
                            element.appendChild((Node)object9);
                            object9.appendChild(document.createTextNode(Integer.toString(n)));
                        }
                        if ((n = ((ContentItemFactory.ImageContentItem)object3).getReferencedSegmentNumber()) != 0) {
                            object9 = document.createElement("segment");
                            element.appendChild((Node)object9);
                            object9.appendChild(document.createTextNode(Integer.toString(n)));
                        }
                        object2 = ((ContentItemFactory.ImageContentItem)object3).getPresentationStateSOPClassUID();
                        object9 = ((ContentItemFactory.ImageContentItem)object3).getPresentationStateSOPInstanceUID();
                        if (object2 != null && ((String)object2).length() > 0 || object9 != null && ((String)object9).length() > 0) {
                            element6 = document.createElement("presentationstate");
                            element.appendChild(element6);
                            node2 = document.createElement("class");
                            element6.appendChild(node2);
                            node2.appendChild(document.createTextNode((String)object2));
                            element5 = document.createElement("instance");
                            element6.appendChild(element5);
                            element5.appendChild(document.createTextNode((String)object9));
                        }
                        object2 = ((ContentItemFactory.ImageContentItem)object3).getRealWorldValueMappingSOPClassUID();
                        object9 = ((ContentItemFactory.ImageContentItem)object3).getRealWorldValueMappingSOPInstanceUID();
                        if (object2 != null && ((String)object2).length() > 0 || object9 != null && ((String)object9).length() > 0) {
                            element6 = document.createElement("realworldvaluemapping");
                            element.appendChild(element6);
                            node2 = document.createElement("class");
                            element6.appendChild(node2);
                            node2.appendChild(document.createTextNode((String)object2));
                            element5 = document.createElement("instance");
                            element6.appendChild(element5);
                            element5.appendChild(document.createTextNode((String)object9));
                        }
                    } else if (contentItem instanceof ContentItemFactory.WaveformContentItem && (object3 = (Object)((ContentItemFactory.WaveformContentItem)contentItem).getReferencedWaveformChannels()) != null && ((Object)object3).length > 0) {
                        object2 = document.createElement("channels");
                        element.appendChild((Node)object2);
                        for (int i = 0; i < ((Object)object3).length; ++i) {
                            Element element7 = document.createElement("channel");
                            object2.appendChild(element7);
                            element7.appendChild(document.createTextNode(Integer.toString((int)object3[i])));
                        }
                    }
                }
                int n = contentItem.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.addContentItemsFromTreeToNode((ContentItem)contentItem.getChildAt(i), document, element, string + "." + Integer.toString(i + 1));
                }
            }
        }
    }

    public XMLRepresentationOfStructuredReportObjectFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
    }

    public Document getDocument(AttributeList attributeList) {
        return this.getDocument(null, attributeList);
    }

    public Document getDocument(StructuredReport structuredReport) {
        return this.getDocument(structuredReport, null);
    }

    public Document getDocument(StructuredReport structuredReport, AttributeList attributeList) {
        Object object;
        if (structuredReport == null) {
            try {
                structuredReport = new StructuredReport(attributeList);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        Document document = this.db.newDocument();
        Element element = document.createElement("DicomStructuredReport");
        document.appendChild(element);
        if (attributeList != null) {
            object = (AttributeList)attributeList.clone();
            ((AttributeList)object).removePrivateAttributes();
            ((AttributeList)object).removeGroupLengthAttributes();
            ((AttributeList)object).removeMetaInformationHeaderAttributes();
            ((AttributeList)object).remove(TagFromName.ContentSequence);
            ((AttributeList)object).remove(TagFromName.ValueType);
            ((AttributeList)object).remove(TagFromName.ContentTemplateSequence);
            ((AttributeList)object).remove(TagFromName.ContinuityOfContent);
            ((AttributeList)object).remove(TagFromName.ConceptNameCodeSequence);
            Element element2 = document.createElement("DicomStructuredReportHeader");
            element.appendChild(element2);
            try {
                new XMLRepresentationOfDicomObjectFactory().addAttributesFromListToNode((AttributeList)object, document, element2);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace(System.err);
            }
        }
        if (structuredReport != null) {
            object = document.createElement("DicomStructuredReportContent");
            element.appendChild((Node)object);
            this.addContentItemsFromTreeToNode((ContentItem)structuredReport.getRoot(), document, (Node)object, "1");
        }
        return document;
    }

    public static String toString(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(node);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(" ");
                stringBuffer.append(node2);
            }
        }
        stringBuffer.append("\n");
        ++n;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(XMLRepresentationOfStructuredReportObjectFactory.toString(node3, n));
        }
        return stringBuffer.toString();
    }

    public static String toString(Node node) {
        return XMLRepresentationOfStructuredReportObjectFactory.toString(node, 0);
    }

    public static void write(OutputStream outputStream, Document document) throws IOException, TransformerConfigurationException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("encoding", "UTF-8");
        transformer.setOutputProperties(properties);
        transformer.transform(dOMSource, streamResult);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(null, attributeList, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, null, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        try {
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            XMLRepresentationOfStructuredReportObjectFactory.write(outputStream, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DicomException("Could not create XML document - problem creating object model from DICOM" + parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new DicomException("Could not create XML document - could not instantiate transformer" + transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new DicomException("Could not create XML document - could not transform to XML" + transformerException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0], null, true, true);
            StructuredReport structuredReport = new StructuredReport(attributeList);
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            XMLRepresentationOfStructuredReportObjectFactory.write(System.out, document);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

