/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SpatialCoordinateAndImageReference;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DisplayDicomDirectoryBrowser;
import com.pixelmed.display.DisplayStructuredReportBrowser;
import com.pixelmed.display.DrawingUtilities;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DicomBrowser
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomBrowser.java,v 1.22 2007/12/19 22:44:14 dclunie Exp $";

    public DicomBrowser() {
    }

    public DicomBrowser(String string) {
        super(string, (String)null);
    }

    public static void loadAndDisplayImagesFromDicomFiles(Vector vector, Map map, int n, int n2) {
        DicomBrowser.loadAndDisplayImagesFromSOPInstances(vector, null, map, n, n2);
    }

    public static void loadAndDisplayImagesFromSOPInstances(Vector vector, Map map, int n, int n2) {
        Vector<String> vector2 = new Vector<String>();
        for (SpatialCoordinateAndImageReference spatialCoordinateAndImageReference : vector) {
            String string = spatialCoordinateAndImageReference.getSOPInstanceUID();
            String string2 = (String)map.get(string);
            if (string2 == null) continue;
            vector2.add(string2);
        }
        DicomBrowser.loadAndDisplayImagesFromSOPInstances(vector2, vector, map, n, n2);
    }

    public static void loadAndDisplayImagesFromSOPInstances(Vector vector, Vector vector2, Map map, int n, int n2) {
        SingleImagePanel[] singleImagePanelArray;
        Object object;
        Serializable serializable;
        Iterator iterator;
        SourceImage[] sourceImageArray = new SourceImage[vector.size()];
        SpatialCoordinateAndImageReference[] spatialCoordinateAndImageReferenceArray = vector2 == null ? null : new SpatialCoordinateAndImageReference[vector.size()];
        int n3 = 0;
        int n4 = 0;
        String string = null;
        int n5 = 0;
        Iterator iterator2 = vector.iterator();
        Iterator iterator3 = iterator = vector2 == null ? null : vector2.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            System.err.println(string2);
            try {
                DicomInputStream dicomInputStream = null;
                try {
                    dicomInputStream = new DicomInputStream(new FileInputStream(string2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    dicomInputStream = new DicomInputStream(new FileInputStream(string2.toLowerCase()));
                }
                serializable = new AttributeList();
                ((AttributeList)serializable).read(dicomInputStream);
                dicomInputStream.close();
                if (((AttributeList)serializable).isImage()) {
                    if (vector2 != null) {
                        spatialCoordinateAndImageReferenceArray[n5] = (SpatialCoordinateAndImageReference)iterator.next();
                    }
                    object = new SourceImage((AttributeList)serializable);
                    singleImagePanelArray = ((SourceImage)object).getBufferedImage();
                    if (((SourceImage)object).getWidth() > n3) {
                        n3 = ((SourceImage)object).getWidth();
                    }
                    if (((SourceImage)object).getHeight() > n4) {
                        n4 = ((SourceImage)object).getHeight();
                    }
                    if (string == null) {
                        string = ((SourceImage)object).getTitle();
                    }
                    sourceImageArray[n5++] = object;
                    continue;
                }
                if (((AttributeList)serializable).isSRDocument()) {
                    object = new DisplayStructuredReportBrowser((AttributeList)serializable, map, n, n2);
                    ((Window)object).setVisible(true);
                    continue;
                }
                throw new DicomException("Unsupported SOP instance type");
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace(System.err);
            }
        }
        if (n5 > 0) {
            int n6;
            Object object2;
            int n7;
            int n8 = n7 = n3 > n ? 1 : n / n3;
            if (n7 > n5) {
                n7 = n5;
            }
            int n9 = (n5 - 1) / n7 + 1;
            serializable = new DicomBrowser(string == null ? "Untitled" : string);
            object = new JPanel();
            ((Container)object).setLayout(new GridLayout(n9, n7));
            ((JComponent)object).setBackground(Color.black);
            singleImagePanelArray = new SingleImagePanel[n7 * n9];
            for (int i = 0; i < n5; ++i) {
                Object object3;
                object2 = sourceImageArray[i];
                Vector<Line2D.Float> vector3 = null;
                Vector<TextAnnotation> vector4 = null;
                if (spatialCoordinateAndImageReferenceArray != null && (object3 = spatialCoordinateAndImageReferenceArray[i]) != null) {
                    String string3 = ((SpatialCoordinateAndImageReference)object3).getGraphicType();
                    float[] fArray = ((SpatialCoordinateAndImageReference)object3).getGraphicData();
                    if (string3 != null && fArray != null) {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        vector3 = new Vector<Line2D.Float>();
                        vector4 = new Vector<TextAnnotation>();
                        if (string3.equals("POINT") && fArray.length == 2) {
                            n14 = (int)fArray[0];
                            n13 = (int)fArray[1];
                            DrawingUtilities.addDiagonalCross(vector3, n14, n13, 20, 5);
                            vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n14 + 50, n13 + -50));
                        } else if (string3.equals("POLYLINE") && fArray.length == 4) {
                            int n15;
                            n14 = (int)fArray[0];
                            n13 = (int)fArray[1];
                            n12 = (int)fArray[2];
                            n11 = (int)fArray[3];
                            vector3.add(new Line2D.Float(new Point(n14, n13), new Point(n12, n11)));
                            DrawingUtilities.addDiagonalCross(vector3, n14, n13, 20, 5);
                            DrawingUtilities.addDiagonalCross(vector3, n12, n11, 20, 5);
                            n10 = 1;
                            boolean bl = true;
                            int n16 = n10 != 0 ? (n14 < n12 ? n14 : n12) : (n15 = n14 > n12 ? n14 : n12);
                            int n17 = bl ? (n13 < n11 ? n13 : n11) : (n13 > n11 ? n13 : n11);
                            vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n15 + 50, n17 + -50));
                        } else if (string3.equals("POLYLINE") && fArray.length > 4) {
                            n14 = (int)fArray[0];
                            n13 = (int)fArray[1];
                            n12 = 2;
                            while (n12 + 1 < fArray.length) {
                                n11 = (int)fArray[n12];
                                n10 = (int)fArray[n12 + 1];
                                vector3.add(new Line2D.Float(new Point(n14, n13), new Point(n11, n10)));
                                n14 = n11;
                                n13 = n10;
                                n12 += 2;
                            }
                            vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n14 + 50, n13 + -50));
                        }
                    }
                }
                object3 = new SingleImagePanel((SourceImage)object2, null, null, vector3, vector4, null);
                ((JComponent)object3).setPreferredSize(new Dimension(((SourceImage)object2).getWidth(), ((SourceImage)object2).getHeight()));
                ((Container)object).add((Component)object3);
                singleImagePanelArray[i] = object3;
            }
            JScrollPane jScrollPane = new JScrollPane((Component)object);
            object2 = ((JFrame)serializable).getContentPane();
            ((Container)object2).setLayout(new GridLayout(1, 1));
            ((Container)object2).add(jScrollPane);
            ((Window)serializable).pack();
            int n18 = jScrollPane.getHeight() + 30;
            if (n18 > n2) {
                n18 = n2;
            }
            if ((n6 = jScrollPane.getWidth() + 24) > n) {
                n6 = n;
            }
            ((Window)serializable).setSize(n6, n18);
            ((Window)serializable).setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        int n;
        int n2;
        if (stringArray.length == 2) {
            n2 = Integer.valueOf(stringArray[0]);
            n = Integer.valueOf(stringArray[1]);
        }
        if (stringArray.length == 3) {
            n2 = Integer.valueOf(stringArray[1]);
            n = Integer.valueOf(stringArray[2]);
        } else {
            n2 = 1024;
            n = 768;
        }
        String string = null;
        if (stringArray.length == 1 || stringArray.length == 3) {
            string = stringArray[0];
        } else if (stringArray.length == 0 || stringArray.length == 2) {
            serializable = new JFileChooser();
            int n3 = ((JFileChooser)serializable).showOpenDialog(null);
            if (n3 == 0) {
                string = ((JFileChooser)serializable).getSelectedFile().getAbsolutePath();
            }
        } else {
            System.err.println("Usage: DicomBrowser [dicomdir] [frameWidthWanted frameHeightWanted]");
            System.exit(-1);
        }
        try {
            serializable = new AttributeList();
            String string2 = new File(string).getParent();
            ((AttributeList)serializable).read(string);
            ApplicationFrame applicationFrame = new ApplicationFrame("DICOMDIR", null, 400, 800);
            DisplayDicomDirectoryBrowser displayDicomDirectoryBrowser = new DisplayDicomDirectoryBrowser((AttributeList)serializable, string2, applicationFrame, n2, n);
            applicationFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

