/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import com.pixelmed.geometry.IntersectSlice;
import com.pixelmed.geometry.IntersectVolume;
import com.pixelmed.geometry.LocalizerPoster;
import com.pixelmed.geometry.ProjectSlice;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class LocalizerPosterFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/LocalizerPosterFactory.java,v 1.8 2005/07/08 18:55:17 dclunie Exp $";

    private static final String dumpPathSegmentType(int n) {
        String string = null;
        string = n == 4 ? "SEG_CLOSE" : (n == 3 ? "SEG_CUBICTO" : (n == 1 ? "SEG_LINETO" : (n == 0 ? "SEG_MOVETO" : (n == 2 ? "SEG_QUADTO" : Integer.toString(n)))));
        return string;
    }

    private static final String dumpArray(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (dArray != null && dArray.length > 0) {
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer.append(string);
                string = ",";
                stringBuffer.append(dArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static final void dumpShape(Shape shape) {
        double[] dArray = new double[6];
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            System.err.println("Segment type = " + LocalizerPosterFactory.dumpPathSegmentType(n) + " coords = " + LocalizerPosterFactory.dumpArray(dArray));
            pathIterator.next();
        }
    }

    public static final void dumpShapes(Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            System.err.println("Shape:");
            LocalizerPosterFactory.dumpShape((Shape)iterator.next());
        }
    }

    private LocalizerPosterFactory() {
    }

    public static LocalizerPoster getLocalizerPoster(boolean bl, boolean bl2) {
        LocalizerPoster localizerPoster = null;
        try {
            localizerPoster = bl ? new ProjectSlice() : (bl2 ? new IntersectSlice() : new IntersectVolume());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace(System.err);
        }
        return localizerPoster;
    }

    public static void main(String[] stringArray) {
        LocalizerPoster localizerPoster = LocalizerPosterFactory.getLocalizerPoster(true, true);
        localizerPoster.setLocalizerGeometry(new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Point3d(0.0, -127.5, 127.5), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), (Tuple3d)new Vector3d(512.0, 512.0, 1.0));
        Vector vector = localizerPoster.getOutlineOnLocalizerForThisGeometry(new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Point3d(-63.5, -63.5, 0.0), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), 0.0, (Tuple3d)new Vector3d(256.0, 256.0, 1.0));
        LocalizerPosterFactory.dumpShapes(vector);
        vector = localizerPoster.getOutlineOnLocalizerForThisGeometry(new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Point3d(-127.5, -127.5, 0.0), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), 0.0, (Tuple3d)new Vector3d(512.0, 512.0, 1.0));
        LocalizerPosterFactory.dumpShapes(vector);
    }
}

