/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.transfermonitor;

import com.pixelmed.transfermonitor.TransferMonitor;
import com.pixelmed.transfermonitor.TransferMonitoringContext;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends InputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/transfermonitor/MonitoredInputStream.java,v 1.1 2005/10/01 19:34:01 dclunie Exp $";
    private InputStream in;
    private TransferMonitor monitor;

    public MonitoredInputStream(InputStream inputStream, TransferMonitoringContext transferMonitoringContext) {
        this.in = inputStream;
        this.monitor = TransferMonitor.newTransferMonitor(transferMonitoringContext);
    }

    public final int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.monitor.countUp(1);
        }
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.monitor.countUp(n);
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.monitor.countUp(n3);
        }
        return n3;
    }

    public final long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        if (l2 > 0L) {
            this.monitor.countUp(l2);
        }
        return l2;
    }

    public final int available() throws IOException {
        return this.in.available();
    }

    public final void close() throws IOException {
        this.in.close();
    }

    public final void mark(int n) {
        this.in.mark(n);
    }

    public final boolean markSupported() {
        return this.in.markSupported();
    }

    public final void reset() throws IOException {
        this.in.reset();
    }
}

