/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteRandomAccessFile;
import edu.sdsc.grid.io.irods.IRODSFile;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;

public class IRODSRandomAccessFile
extends RemoteRandomAccessFile {
    long filePointer = 0L;
    IRODSFileSystem fileSystem;

    public IRODSRandomAccessFile(IRODSFileSystem iRODSFileSystem, String string, String string2) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        this(new IRODSFile(iRODSFileSystem, string), string2);
    }

    public IRODSRandomAccessFile(IRODSFile iRODSFile, String string) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(iRODSFile, string);
        this.setFileSystem(iRODSFile.getFileSystem());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void open(GeneralFile generalFile) throws FileNotFoundException, SecurityException, IOException {
        generalFile.createNewFile();
        this.rwCheck(generalFile, this.mode);
        if (this.rw == 0) {
            this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
        } else if (this.rw == 1) {
            this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
        } else if (this.rw == 2) {
            this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
        } else if (this.rw == 3) {
            this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
        }
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (IRODSFileSystem)generalFileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    public int read() throws IOException {
        return -1;
    }

    protected int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.fileSystem.commands.fileRead(this.fd, byArray, n, n2);
        this.filePointer += (long)n3;
        return n3;
    }

    protected void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.filePointer += (long)this.fileSystem.commands.fileWrite(this.fd, byArray, n, n2);
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l, int n) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileSystem.commands.fileSeek(this.fd, l, n);
        this.filePointer = l;
    }

    public long length() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file size")};
        try {
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return Long.parseLong(metaDataRecordListArray[0].getValue("file size").toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    public void setLength(long l) throws IOException {
        long l2 = this.length();
        if (l > l2) {
            this.seek(l - 1L);
            this.write(0);
        } else if (l < l2) {
            throw new UnsupportedOperationException();
        }
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.commands.fileClose(this.fd);
            this.fileSystem = null;
        }
        if (this.fileFormat != null) {
            this.fileFormat = null;
        }
    }
}

