/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.XDecimal;
import org.apache.xerces.impl.validation.ValidationContext;

public class DecimalDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 8176;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        int n = string.length();
        if (n == 0) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (string.charAt(0) == '+') {
            n3 = 1;
            n2 = 1;
        } else if (string.charAt(0) == '-') {
            n3 = 1;
        }
        while (n3 < n && TypeValidator.isDigit(string.charAt(n3))) {
            ++n3;
        }
        if (n3 < n) {
            if (string.charAt(n3) != '.') {
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
            }
            n4 = n3 + 1;
            n5 = n;
        }
        if (n2 == n3 && n4 == n5) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
        }
        int n6 = string.charAt(n2) == '-' ? n2 + 1 : n2;
        while (n6 < n3 && string.charAt(n6) == '0') {
            ++n6;
        }
        while (n5 > n4 && string.charAt(n5 - 1) == '0') {
            --n5;
        }
        int n7 = n4;
        while (n7 < n5) {
            if (!TypeValidator.isDigit(string.charAt(n7))) {
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
            }
            ++n7;
        }
        int n8 = n5 - n4;
        String string2 = null;
        if (n3 > n2) {
            string2 = string.substring(n2, n3);
            if (n8 > 0) {
                string2 = string2 + string.substring(n4, n5);
            }
        } else {
            string2 = n8 > 0 ? string.substring(n4, n5) : "0";
        }
        try {
            BigInteger bigInteger = new BigInteger(string2);
            return new XDecimal(bigInteger, n3 - n6, n8);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
        }
    }

    public boolean isEqual(Object object, Object object2) {
        if (!(object instanceof BigDecimal) || !(object2 instanceof BigDecimal)) {
            return false;
        }
        return ((BigDecimal)object).compareTo((BigDecimal)object2) == 0;
    }

    public int compare(Object object, Object object2) {
        return ((BigDecimal)object).compareTo((BigDecimal)object2);
    }

    public int getTotalDigits(Object object) {
        return ((XDecimal)object).totalDigits;
    }

    public int getFractionDigits(Object object) {
        return ((BigDecimal)object).scale();
    }
}

