/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSet
implements IDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$AbstractDataSet == null ? (class$org$dbunit$dataset$AbstractDataSet = AbstractDataSet.class$("org.dbunit.dataset.AbstractDataSet")) : class$org$dbunit$dataset$AbstractDataSet));
    static /* synthetic */ Class class$org$dbunit$dataset$AbstractDataSet;

    protected ITable[] cloneTables(ITable[] tables) {
        logger.debug("cloneTables(tables=" + tables + ") - start");
        ITable[] clones = new ITable[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            clones[i] = tables[i];
        }
        return clones;
    }

    protected abstract ITableIterator createIterator(boolean var1) throws DataSetException;

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        ArrayList<String> tableNameList = new ArrayList<String>();
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            tableNameList.add(iterator.getTableMetaData().getTableName());
        }
        return tableNameList.toArray(new String[0]);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName=" + tableName + ") - start");
        return this.getTable(tableName).getTableMetaData();
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName=" + tableName + ") - start");
        ITable found = null;
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            ITable table = iterator.getTable();
            if (!tableName.equalsIgnoreCase(table.getTableMetaData().getTableName())) continue;
            if (found != null) {
                throw new AmbiguousTableNameException(tableName);
            }
            found = table;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchTableException(tableName);
    }

    public ITable[] getTables() throws DataSetException {
        logger.debug("getTables() - start");
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            tableList.add(iterator.getTable());
        }
        return tableList.toArray(new ITable[0]);
    }

    public ITableIterator iterator() throws DataSetException {
        logger.debug("iterator() - start");
        return this.createIterator(false);
    }

    public ITableIterator reverseIterator() throws DataSetException {
        logger.debug("reverseIterator() - start");
        return this.createIterator(true);
    }

    public String toString() {
        logger.debug("toString() - start");
        try {
            return Arrays.asList(this.getTableNames()).toString();
        }
        catch (DataSetException e) {
            logger.error("toString()", (Throwable)e);
            return super.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

