/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReader;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.LookupTable;

public class OverlayUtils {
    private static final int BITS_PER_BYTE = 8;
    private static LookupTable reorderBytes;
    private static byte[] rgbArr;
    private static byte[] aArr;

    public static boolean isOverlay(int imageIndex) {
        return (imageIndex & 0x60000000) == 0x60000000 && (imageIndex & 0x9F010000) == 0;
    }

    public static int extractFrameNumber(int imageIndex) {
        if (OverlayUtils.isOverlay(imageIndex)) {
            return imageIndex & 0xFFFF;
        }
        throw new IllegalArgumentException("Only frame numbers of overlays can be extracted.");
    }

    public static BufferedImage extractOverlay(DicomObject ds, int overlayNumber, ImageReader reader, String rgbs) throws IOException {
        byte[] data;
        if (!OverlayUtils.isOverlay(overlayNumber)) {
            throw new IllegalArgumentException("Overlays must start with 0x60xx xxxx but it starts with " + Integer.toString(overlayNumber, 16));
        }
        int frameNumber = OverlayUtils.extractFrameNumber(overlayNumber);
        int rows = OverlayUtils.getOverlayHeight(ds, overlayNumber &= 0x60FE0000);
        int cols = OverlayUtils.getOverlayWidth(ds, overlayNumber);
        if (cols == 0 || rows == 0) {
            throw new IllegalArgumentException("No overlay found for " + Integer.toString(overlayNumber));
        }
        int position = ds.getInt(overlayNumber | 0x60000102);
        if (position == 0) {
            data = ds.getBytes(overlayNumber | 0x60003000);
            if (frameNumber > 0 && data.length >= rows * cols * 2 / 8) {
                byte[] frameData = new byte[rows * cols / 8];
                System.arraycopy(data, (frameNumber - 1) * frameData.length, frameData, 0, frameData.length);
                data = frameData;
            }
        } else {
            Raster raw = reader.readRaster(frameNumber, null);
            int rowLen = (cols + 7) / 8;
            data = new byte[rows * rowLen];
            int[] pixels = new int[cols];
            int bit = 1 << position;
            for (int y = 0; y < rows; ++y) {
                pixels = raw.getPixels(0, y, cols, 1, pixels);
                for (int x = 0; x < cols; ++x) {
                    if ((pixels[x] & bit) == 0) continue;
                    int n = rowLen * y + x / 8;
                    data[n] = (byte)(data[n] | 1 << x % 8);
                }
            }
        }
        DataBufferByte db = new DataBufferByte(data, data.length);
        WritableRaster wr = Raster.createPackedRaster(db, cols, rows, 1, new Point());
        byte[] rArr = rgbArr;
        byte[] gArr = rgbArr;
        byte[] bArr = rgbArr;
        if (rgbs != null && rgbs.length() > 0) {
            if (rgbs.startsWith("#")) {
                rgbs = rgbs.substring(1);
            }
            int rgb = Integer.parseInt(rgbs, 16);
            rArr = new byte[]{0, (byte)(rgb >> 16 & 0xFF)};
            gArr = new byte[]{0, (byte)(rgb >> 8 & 0xFF)};
            bArr = new byte[]{0, (byte)(rgb & 0xFF)};
        }
        IndexColorModel cm = new IndexColorModel(1, 2, rArr, gArr, bArr, aArr);
        BufferedImage bi = new BufferedImage(cm, wr, false, null);
        reorderBytes.lookup(bi.getRaster().getDataBuffer(), bi.getRaster().getDataBuffer());
        return bi;
    }

    public static int getOverlayWidth(DicomObject ds, int overlayNumber) {
        return ds.getInt(0x60000011 | (overlayNumber &= 0x60FF0000));
    }

    public static int getOverlayHeight(DicomObject ds, int overlayNumber) {
        return ds.getInt(0x60000010 | (overlayNumber &= 0x60FF0000));
    }

    static {
        byte[] reorder = new byte[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                int bitTest = 1 << j;
                if ((i & bitTest) == 0) continue;
                int n = i;
                reorder[n] = (byte)(reorder[n] | 128 >> j);
            }
        }
        reorderBytes = new ByteLookupTable(8, false, 0, 8, reorder);
        rgbArr = new byte[]{-1, 0};
        aArr = new byte[]{0, -1};
    }
}

