/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    private short[] data;

    public ShortLookupTable(int inBits, boolean signed, int off, int outBits, short[] data) {
        this(inBits, signed, off, outBits, data, false);
    }

    public ShortLookupTable(int inBits, boolean signed, int off, int outBits, short[] data, boolean preserve) {
        super(inBits, signed, off, outBits, preserve);
        this.data = data;
    }

    public final int length() {
        return this.data.length;
    }

    public final byte lookupByte(int in) {
        return (byte)this.lookupShort(in);
    }

    public final short lookupShort(int in) {
        int tmp = ((in & this.signbit) != 0 ? in | this.ormask : in & this.andmask) - this.off;
        return tmp <= 0 ? this.data[0] : (tmp >= this.data.length ? this.data[this.data.length - 1] : this.data[tmp]);
    }

    public final int lookup(int in) {
        return this.lookupShort(in) & 0xFFFF;
    }

    public final byte[] lookup(byte[] src, byte[] dst) {
        if (dst == null) {
            dst = new byte[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dst[i] = this.lookupByte(src[i]);
        }
        return dst;
    }

    public final short[] lookup(byte[] src, short[] dst) {
        if (dst == null) {
            dst = new short[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dst[i] = this.lookupShort(src[i]);
        }
        return dst;
    }

    public final int[] lookup(byte[] src, int[] dst, int alpha) {
        if (dst == null) {
            dst = new int[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            int tmp = this.lookupShort(src[i]) & 0xFF;
            dst[i] = tmp | tmp << 8 | tmp << 16 | alpha << 24;
        }
        return dst;
    }

    public final byte[] lookup(short[] src, byte[] dst) {
        if (dst == null) {
            dst = new byte[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dst[i] = this.lookupByte(src[i]);
        }
        return dst;
    }

    public final short[] lookup(short[] src, short[] dst) {
        if (dst == null) {
            dst = new short[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dst[i] = this.lookupShort(src[i]);
        }
        return dst;
    }

    public final int[] lookup(short[] src, int[] dst, int alpha) {
        if (dst == null) {
            dst = new int[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            int tmp = this.lookupShort(src[i]) & 0xFF;
            dst[i] = tmp | tmp << 8 | tmp << 16 | alpha << 24;
        }
        return dst;
    }

    protected LookupTable inverse() {
        int outMax = (1 << this.outBits) - 1;
        short[] newData = this.preserve ? new short[this.data.length] : this.data;
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = (short)(outMax - this.data[i]);
        }
        return this.preserve ? new ShortLookupTable(this.inBits, this.signbit != 0, this.off, this.outBits, newData) : this;
    }

    protected LookupTable scale(int outBits, boolean inverse, short[] pval2out) {
        if (outBits == this.outBits && !inverse && pval2out == null) {
            return this;
        }
        int outBits1 = pval2out == null ? outBits : ShortLookupTable.inBits(pval2out);
        int shift = outBits1 - this.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (this.preserve && outBits <= 8) {
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < newData.length; ++i) {
                int tmp = this.data[i] & 0xFFFF;
                tmp = shift < 0 ? (tmp >>>= -shift) : (tmp <<= shift);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        short[] newData = this.preserve ? new short[this.data.length] : this.data;
        for (int i = 0; i < newData.length; ++i) {
            int tmp = this.data[i] & 0xFFFF;
            tmp = shift < 0 ? (tmp >>>= -shift) : (tmp <<= shift);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        if (this.preserve) {
            return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        this.outBits = outBits;
        return this;
    }

    protected LookupTable combine(LookupTable other, int outBits, boolean inverse, short[] pval2out) {
        int shift1 = other.inBits - this.outBits;
        int outBits1 = pval2out == null ? outBits : ShortLookupTable.inBits(pval2out);
        int shift2 = outBits1 - other.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (outBits <= 8) {
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < newData.length; ++i) {
                int tmp = this.data[i] & 0xFFFF;
                tmp = other.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
                tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        short[] newData = new short[this.data.length];
        for (int i = 0; i < newData.length; ++i) {
            int tmp = this.data[i] & 0xFFFF;
            tmp = other.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
            tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
    }

    protected LookupTable combine(LookupTable vlut, LookupTable plut, int outBits, boolean inverse, short[] pval2out) {
        int shift1 = plut.inBits - vlut.outBits;
        int outBits1 = pval2out == null ? outBits : ShortLookupTable.inBits(pval2out);
        int shift2 = outBits - plut.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (outBits <= 8) {
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < newData.length; ++i) {
                int tmp = vlut.lookup(this.data[i] & 0xFFFF);
                tmp = plut.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
                tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        short[] newData = new short[this.data.length];
        for (int i = 0; i < newData.length; ++i) {
            int tmp = vlut.lookup(this.data[i] & 0xFFFF);
            tmp = plut.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
            tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
    }
}

