/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io.dicom;

import imagelib.io.ImageData;
import imagelib.io.ImageReader;
import imagelib.io.dicom.DICOMDataElement;
import imagelib.io.dicom.DICOMDecoder;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DICOMReader
extends ImageReader {
    @Override
    public boolean canRead(String filename) {
        return filename.endsWith(".dcm");
    }

    @Override
    public ImageData load(String inFile) throws IOException {
        int skipCount;
        DataInputStream in = null;
        DICOMDecoder dd = null;
        HashMap<String, DICOMDataElement> ddeMap = new HashMap<String, DICOMDataElement>();
        dd = new DICOMDecoder(inFile);
        dd.getImageDataStartPos(inFile, ddeMap);
        in = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4096));
        int rows = this.getIntDDEValue(ddeMap, "Rows");
        int cols = this.getIntDDEValue(ddeMap, "Columns");
        int loc = skipCount = (int)(new File(inFile).length() - (long)(2 * rows * cols));
        while (skipCount > 0) {
            skipCount -= in.skipBytes(skipCount);
        }
        System.out.println("*** location=" + loc);
        int[] rawData = new int[rows * cols];
        ImageData imgData = new ImageData(rawData, rows, cols);
        imgData.setPixelSize(this.pixelSize);
        imgData.setMaxPixelValue(Integer.MIN_VALUE);
        imgData.setMinPixelValue(Integer.MAX_VALUE);
        int noPixels = rows * cols;
        int i = 0;
        while (i < noPixels) {
            rawData[i] = in.readUnsignedShort();
            if (rawData[i] < imgData.getMinPixelValue()) {
                imgData.setMinPixelValue(rawData[i]);
            }
            if (rawData[i] > imgData.getMaxPixelValue()) {
                imgData.setMaxPixelValue(rawData[i]);
            }
            ++i;
        }
        System.out.println("min pixel value=" + imgData.getMinPixelValue() + ", max pixel value=" + imgData.getMaxPixelValue());
        return imgData;
    }

    private int getIntDDEValue(Map<String, DICOMDataElement> ddeMap, String name) {
        DICOMDataElement dde = ddeMap.get(name);
        return Integer.parseInt(dde.getValue());
    }

    public static void main(String[] args) {
        try {
            DICOMReader dr = new DICOMReader();
            dr.canRead("/home/bozyurt/dev/java/imaging/data/UCSD12657688.dcm/UCSD12657688_050.dcm");
            dr.load("/home/bozyurt/dev/java/imaging/data/UCSD12657688.dcm/UCSD12657688_050.dcm");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

