/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallback;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.database.search.ImportedKeysSearchCallback;
import org.dbunit.database.search.ImportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.util.CollectionsHelper;
import org.dbunit.util.search.DepthFirstSearch;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesDependencyHelper {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$search$TablesDependencyHelper == null ? (class$org$dbunit$database$search$TablesDependencyHelper = TablesDependencyHelper.class$("org.dbunit.database.search.TablesDependencyHelper")) : class$org$dbunit$database$search$TablesDependencyHelper));
    static /* synthetic */ Class class$org$dbunit$database$search$TablesDependencyHelper;

    private TablesDependencyHelper() {
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getDependentTables(connection=" + connection + ", rootTable=" + rootTable + ") - start");
        return TablesDependencyHelper.getDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getDependentTables(connection=" + connection + ", rootTables=" + rootTables + ") - start");
        ImportedKeysSearchCallback callback = new ImportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        Set tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings(tables);
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getAllDependentTables(connection=" + connection + ", rootTable=" + rootTable + ") - start");
        return TablesDependencyHelper.getAllDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getAllDependentTables(connection=" + connection + ", rootTables=" + rootTables + ") - start");
        ImportedAndExportedKeysSearchCallback callback = new ImportedAndExportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        Set tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings(tables);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, String rootTable, Set allowedIds) throws SearchException, SQLException {
        logger.debug("getDataset(connection=" + connection + ", rootTable=" + rootTable + ", allowedIds=" + allowedIds + ") - start");
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        map.put(rootTable, allowedIds);
        return TablesDependencyHelper.getDataset(connection, map);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, Map rootTables) throws SearchException, SQLException {
        logger.debug("getDataset(connection=" + connection + ", rootTables=" + rootTables + ") - start");
        ImportedKeysSearchCallbackFilteredByPKs callback = new ImportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = CollectionsHelper.setToStrings(rootTables.keySet());
        Set tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings(tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, String rootTable, Set allowedPKs) throws SearchException, SQLException {
        logger.debug("getAllDataset(connection=" + connection + ", rootTable=" + rootTable + ", allowedPKs=" + allowedPKs + ") - start");
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        map.put(rootTable, allowedPKs);
        return TablesDependencyHelper.getAllDataset(connection, map);
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, Map rootTables) throws SearchException, SQLException {
        logger.debug("getAllDataset(connection=" + connection + ", rootTables=" + rootTables + ") - start");
        ImportedAndExportedKeysSearchCallbackFilteredByPKs callback = new ImportedAndExportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = CollectionsHelper.setToStrings(rootTables.keySet());
        Set tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings(tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

