/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.Channel;
import org.dbunit.util.concurrent.LinkedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedQueue
implements Channel {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$concurrent$LinkedQueue == null ? (class$org$dbunit$util$concurrent$LinkedQueue = LinkedQueue.class$("org.dbunit.util.concurrent.LinkedQueue")) : class$org$dbunit$util$concurrent$LinkedQueue));
    protected LinkedNode head_;
    protected final Object putLock_ = new Object();
    protected LinkedNode last_ = this.head_ = new LinkedNode(null);
    protected int waitingForTake_ = 0;
    static /* synthetic */ Class class$org$dbunit$util$concurrent$LinkedQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        logger.debug("insert(x=" + x + ") - start");
        Object object = this.putLock_;
        synchronized (object) {
            LinkedNode p = new LinkedNode(x);
            LinkedNode linkedNode = this.last_;
            synchronized (linkedNode) {
                this.last_.next = p;
                this.last_ = p;
            }
            if (this.waitingForTake_ > 0) {
                this.putLock_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        logger.debug("extract() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.head_.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.head_ = first;
            }
            return x;
        }
    }

    public void put(Object x) throws InterruptedException {
        logger.debug("put(x=" + x + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        logger.debug("offer(x=" + x + ", msecs=" + msecs + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.insert(x);
        return true;
    }

    public Object take() throws InterruptedException {
        logger.debug("take() - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null) {
                        --this.waitingForTake_;
                        return x;
                    }
                    this.putLock_.wait();
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLock_.notify();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        logger.debug("peek() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            LinkedNode first = this.head_.next;
            if (first != null) {
                return first.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        logger.debug("isEmpty() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            return this.head_.next == null;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        logger.debug("poll(msecs=" + msecs + ") - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                long waitTime = msecs;
                long start = msecs <= 0L ? 0L : System.currentTimeMillis();
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        --this.waitingForTake_;
                        return x;
                    }
                    this.putLock_.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLock_.notify();
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

