/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.apache.struts2.views.xslt.SimpleNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdapterNode
implements AdapterNode {
    private static final NamedNodeMap EMPTY_NAMEDNODEMAP = new NamedNodeMap(){

        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }

        public Node getNamedItem(String name) {
            return null;
        }

        public Node removeNamedItem(String name) throws DOMException {
            return null;
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return null;
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            return null;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return null;
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return null;
        }
    };
    private List<Node> childAdapters;
    private Log log = LogFactory.getLog(this.getClass());
    private Object propertyValue;
    private String propertyName;
    private AdapterNode parent;
    private AdapterFactory adapterFactory;

    public AbstractAdapterNode() {
        if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
            LogFactory.getLog(this.getClass()).debug((Object)("Creating " + this));
        }
    }

    protected void setContext(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, Object value) {
        this.setAdapterFactory(adapterFactory);
        this.setParent(parent);
        this.setPropertyName(propertyName);
        this.setPropertyValue(value);
    }

    protected List<Node> buildChildAdapters() {
        return new ArrayList<Node>();
    }

    protected List<Node> getChildAdapters() {
        if (this.childAdapters == null) {
            this.childAdapters = this.buildChildAdapters();
        }
        return this.childAdapters;
    }

    public Node getChildBeforeOrAfter(Node child, boolean before) {
        int index;
        this.log.debug((Object)"getChildBeforeOrAfter: ");
        List<Node> adapters = this.getChildAdapters();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("childAdapters = " + adapters));
            this.log.debug((Object)("child = " + child));
        }
        if ((index = adapters.indexOf(child)) < 0) {
            throw new StrutsException(child + " is no child of " + this);
        }
        int siblingIndex = before ? index - 1 : index + 1;
        return 0 < siblingIndex && siblingIndex < adapters.size() ? adapters.get(siblingIndex) : null;
    }

    @Override
    public Node getChildAfter(Node child) {
        this.log.trace((Object)"getChildafter");
        return this.getChildBeforeOrAfter(child, false);
    }

    @Override
    public Node getChildBefore(Node child) {
        this.log.trace((Object)"getchildbefore");
        return this.getChildBeforeOrAfter(child, true);
    }

    public NodeList getElementsByTagName(String tagName) {
        if (tagName.equals("*")) {
            return this.getChildNodes();
        }
        LinkedList<Node> filteredChildren = new LinkedList<Node>();
        for (Node adapterNode : this.getChildAdapters()) {
            if (!adapterNode.getNodeName().equals(tagName)) continue;
            filteredChildren.add(adapterNode);
        }
        return new SimpleNodeList(filteredChildren);
    }

    public NodeList getElementsByTagNameNS(String string, String string1) {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return EMPTY_NAMEDNODEMAP;
    }

    @Override
    public NodeList getChildNodes() {
        SimpleNodeList nl = new SimpleNodeList(this.getChildAdapters());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getChildNodes for tag: " + this.getNodeName() + " num children: " + nl.getLength()));
        }
        return nl;
    }

    @Override
    public Node getFirstChild() {
        return this.getChildNodes().getLength() > 0 ? this.getChildNodes().item(0) : null;
    }

    @Override
    public Node getLastChild() {
        return this.getChildNodes().getLength() > 0 ? this.getChildNodes().item(this.getChildNodes().getLength() - 1) : null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public String getNodeValue() throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node getParentNode() {
        this.log.trace((Object)"getParentNode");
        return this.getParent();
    }

    @Override
    public AdapterNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(AdapterNode parent) {
        this.parent = parent;
    }

    @Override
    public Object getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public void setPropertyValue(Object prop) {
        this.propertyValue = prop;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        Node next = this.getParent().getChildAfter(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNextSibling on " + this.getNodeName() + ": " + (next == null ? "null" : next.getNodeName())));
        }
        return next;
    }

    @Override
    public Node getPreviousSibling() {
        return this.getParent().getChildBefore(this);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    @Override
    public boolean isSupported(String string, String string1) {
        throw this.operationNotSupported();
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public Node cloneNode(boolean b) {
        this.log.trace((Object)"cloneNode");
        throw this.operationNotSupported();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node insertBefore(Node node, Node node1) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public void normalize() {
        this.log.trace((Object)"normalize");
        throw this.operationNotSupported();
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public Node replaceChild(Node node, Node node1) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        throw this.operationNotSupported();
    }

    @Override
    public String lookupNamespaceURI(String string) {
        throw this.operationNotSupported();
    }

    @Override
    public String getNodeName() {
        throw this.operationNotSupported();
    }

    @Override
    public short getNodeType() {
        throw this.operationNotSupported();
    }

    @Override
    public String getBaseURI() {
        throw this.operationNotSupported();
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public String getTextContent() throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    @Override
    public boolean isSameNode(Node node) {
        throw this.operationNotSupported();
    }

    @Override
    public String lookupPrefix(String string) {
        throw this.operationNotSupported();
    }

    @Override
    public boolean isEqualNode(Node node) {
        throw this.operationNotSupported();
    }

    @Override
    public Object getFeature(String string, String string1) {
        throw this.operationNotSupported();
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw this.operationNotSupported();
    }

    @Override
    public Object getUserData(String string) {
        throw this.operationNotSupported();
    }

    protected StrutsException operationNotSupported() {
        return new StrutsException("Operation not supported.");
    }

    public String toString() {
        return this.getClass() + ": " + this.getNodeName() + " parent=" + this.getParentNode();
    }
}

