/*
 * Decompiled with CFR 0.152.
 */
package clinical.xml.export;

import clinical.xml.XMLUtils;
import clinical.xml.export.XCEDEServiceLocator;
import clinical.xml.export.XCEDEServiceSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.Options;
import org.w3c.dom.Element;

public class ExportClient {
    public void getSeriesData(String[] args, String endPoint) throws Exception {
        Options options = new Options(args);
        options.setDefaultURL(endPoint);
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(options.getURL()));
        call.setOperationName(new QName("http://localhost:8080/clinical/services/XcedeExportService", "exportSeries"));
        Object[] input = new SOAPBodyElement[]{};
        Vector outElems = (Vector)call.invoke(input);
        SOAPBodyElement elem = (SOAPBodyElement)outElems.get(0);
        Element e = elem.getAsDOM();
        String out = org.apache.axis.utils.XMLUtils.ElementToString((Element)e);
        System.out.println("result =" + out);
    }

    public void getSeriesData2(String endPoint, String webUser, String pwd, String subjectID, int expID, int visitID, int studyID, int segmentID) throws Exception {
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(endPoint));
        call.addParameter("webUser", Constants.XSD_STRING, ParameterMode.IN);
        call.addParameter("pwd", Constants.XSD_STRING, ParameterMode.IN);
        call.addParameter("subjectID", Constants.XSD_STRING, ParameterMode.IN);
        call.addParameter("expID", Constants.XSD_INT, ParameterMode.IN);
        call.addParameter("visitID", Constants.XSD_INT, ParameterMode.IN);
        call.addParameter("studyID", Constants.XSD_INT, ParameterMode.IN);
        call.addParameter("segmentID", Constants.XSD_INT, ParameterMode.IN);
        call.setReturnType(Constants.XSD_STRING);
        call.setOperationName(new QName("http://localhost:8080/clinical/services/XcedeExportService2", "exportSeries2"));
        String retXML = (String)call.invoke(new Object[]{webUser, pwd, subjectID, new Integer(expID), new Integer(visitID), new Integer(studyID), new Integer(segmentID)});
        System.out.println("returned XML doc =" + retXML);
    }

    public void getSeriesData(String webUser, String pwd, String subjectID, int expID, int visitID, int studyID, int segmentID) throws Exception {
        XCEDEServiceSoapBindingStub binding = null;
        binding = (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService();
        binding.setTimeout(60000);
        String retXML = binding.exportSeriesData(webUser, pwd, subjectID, expID, visitID, studyID, segmentID);
        XMLUtils.prettyPrint(retXML);
    }

    public void getSubjectData(String webUser, String pwd, String subjectID, int expID) throws Exception {
        this.getSubjectData(null, webUser, pwd, subjectID, expID);
    }

    public String getSubjectData(String endPoint, String webUser, String pwd, String subjectID, int expID) throws Exception {
        XCEDEServiceSoapBindingStub binding = null;
        binding = endPoint == null ? (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService() : (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService(new URL(endPoint));
        binding.setTimeout(60000);
        String retXML = binding.exportSubjectData(webUser, pwd, subjectID, expID);
        return retXML;
    }

    public String getExperimentData(String endPoint, String webUser, String pwd, int expID) throws Exception {
        XCEDEServiceSoapBindingStub binding = null;
        binding = endPoint == null ? (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService() : (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService(new URL(endPoint));
        binding.setTimeout(60000);
        String retXML = binding.exportExperimentData(webUser, pwd, expID);
        return retXML;
    }

    public void getVisitData(String endPoint, String webUser, String pwd, String subjectID, int expID, int visitID) throws Exception {
        XCEDEServiceSoapBindingStub binding = null;
        binding = endPoint == null ? (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService() : (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService(new URL(endPoint));
        binding.setTimeout(60000);
        String retXML = binding.exportVisitData(webUser, pwd, subjectID, expID, visitID);
        XMLUtils.prettyPrint(retXML);
    }

    protected XCEDEServiceSoapBindingStub getXCEDEService(String endPoint) throws ServiceException, MalformedURLException {
        XCEDEServiceSoapBindingStub binding = null;
        binding = endPoint == null ? (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService() : (XCEDEServiceSoapBindingStub)new XCEDEServiceLocator().getXCEDEService(new URL(endPoint));
        binding.setTimeout(60000);
        return binding;
    }

    public Object[] getAllExperiments(String endPoint, String webUser, String pwd) throws Exception {
        XCEDEServiceSoapBindingStub binding = this.getXCEDEService(endPoint);
        int[] expIDs = binding.getAllExperimentIDs(webUser, pwd);
        int i = 0;
        while (i < expIDs.length) {
            System.out.println("expID[" + i + "]=" + expIDs[i]);
            ++i;
        }
        String[] expNames = binding.getExperimentNames(webUser, pwd, expIDs);
        int i2 = 0;
        while (i2 < expNames.length) {
            System.out.println("expNames[" + i2 + "]=" + expNames[i2]);
            ++i2;
        }
        Object[] results = new Object[]{expIDs, expNames};
        return results;
    }

    public String[] getAllSubjects(String endPoint, String webUser, String pwd, int expID) throws Exception {
        XCEDEServiceSoapBindingStub binding = this.getXCEDEService(endPoint);
        String[] subjectIDs = binding.getAllSubjects(webUser, pwd, expID);
        int i = 0;
        while (i < subjectIDs.length) {
            System.out.println("for Subject " + subjectIDs[i]);
            ++i;
        }
        return subjectIDs;
    }

    public static void main(String[] args) {
        boolean useTcpMon = false;
        String pwd = "";
        try {
            ExportClient ec = new ExportClient();
            String endPoint = "http://localhost:8080/clinical/services/XCEDEService";
            if (useTcpMon) {
                endPoint = "http://localhost:22222/clinical/services/XCEDEService";
            }
            ec.getVisitData(endPoint, "b", pwd, "001100000103", 1013, 1);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

