/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private PdfDecoder decode_pdf;
    private PdfStreamDecoder imageDecoder = null;
    private boolean stopDecoding = false;

    public ThumbnailDecoder(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public void terminateDecoding() {
        this.stopDecoding = true;
        if (this.imageDecoder != null) {
            this.imageDecoder.terminateDecoding();
            while (this.imageDecoder != null && !this.imageDecoder.exitedDecoding()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public final synchronized BufferedImage getPageAsThumbnail(int n, int n2) {
        this.stopDecoding = false;
        BufferedImage bufferedImage = null;
        DynamicVectorRenderer dynamicVectorRenderer = ObjectStore.getCachedPage(new Integer(n));
        if (dynamicVectorRenderer != null) {
            dynamicVectorRenderer.setObjectStoreRef(this.decode_pdf.objectStoreRef);
        } else {
            dynamicVectorRenderer = new DynamicVectorRenderer(n, true, 1000, this.decode_pdf.objectStoreRef);
            dynamicVectorRenderer.setHiResImageForDisplayMode(this.decode_pdf.useHiResImageForDisplay);
            try {
                if (n > this.decode_pdf.getPageCount()) {
                    LogWriter.writeLog("Page " + n + " out of bounds");
                } else {
                    Map map;
                    String string;
                    int n3 = this.decode_pdf.pageData.getMediaBoxX(n);
                    int n4 = this.decode_pdf.pageData.getMediaBoxY(n);
                    int n5 = this.decode_pdf.pageData.getMediaBoxWidth(n);
                    int n6 = this.decode_pdf.pageData.getMediaBoxHeight(n);
                    String string2 = (String)this.decode_pdf.pagesReferences.get(new Integer(n));
                    if (string2 != null && (string = (String)(map = this.decode_pdf.currentPdfFile.readObject(string2, false, null)).get("Contents")) != null) {
                        this.imageDecoder = new PdfStreamDecoder(this.decode_pdf.useHiResImageForDisplay);
                        this.imageDecoder.setExternalImageRender(this.decode_pdf.customImageHandler);
                        if (this.stopDecoding) {
                            this.imageDecoder = null;
                            return null;
                        }
                        this.imageDecoder.setName(this.decode_pdf.filename);
                        this.imageDecoder.setStore(this.decode_pdf.objectStoreRef);
                        Map map2 = this.decode_pdf.currentPdfFile.getSubDictionary(map.get("Resources"));
                        if (this.stopDecoding) {
                            this.imageDecoder = null;
                            return null;
                        }
                        this.imageDecoder.init(true, true, PdfDecoder.renderMode, 0, this.decode_pdf.pageData, n, dynamicVectorRenderer, this.decode_pdf.currentPdfFile, this.decode_pdf.globalRes, map2);
                        if (this.stopDecoding) {
                            this.imageDecoder = null;
                            return null;
                        }
                        dynamicVectorRenderer.init(n5, n6, this.decode_pdf.pageData.getRotation(n));
                        this.imageDecoder.decodePageContent(string, n3, n4, null);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.imageDecoder = null;
            ObjectStore.cachePage(new Integer(n), dynamicVectorRenderer);
        }
        if (!this.stopDecoding) {
            bufferedImage = this.decode_pdf.getImageFromRenderer(n2, dynamicVectorRenderer, n);
        }
        return bufferedImage;
    }
}

