/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtractImages {
    private String user_dir = System.getProperty("user.dir");
    public static boolean outputMessages = true;
    PdfDecoder decode_pdf = null;
    String separator = System.getProperty("file.separator");
    private String output_dir = "";
    public static String testOutputDir = "current_images/";
    public static boolean isTest;
    private static String prefix;
    private static String test_file;

    public ExtractImages() {
    }

    public ExtractImages(String string) {
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decode(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                System.out.println(n + "/ " + l + ' ' + stringArray[n]);
                if (stringArray[n].endsWith(".pdf")) {
                    System.out.println(string + stringArray[n]);
                    this.decode(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decode(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        try {
            this.decode_pdf = new PdfDecoder(false);
            String string3 = System.getProperty("opi");
            if (string3 == null) {
                this.decode_pdf.setExtractionMode(6);
            } else {
                this.decode_pdf.setExtractionMode(262);
            }
            if (outputMessages) {
                System.out.println("Opening file :" + string);
            }
            this.decode_pdf.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            int n2 = 1;
            int n3 = this.decode_pdf.getPageCount();
            this.output_dir = this.user_dir + "images" + this.separator + string2 + this.separator;
            File file = new File(this.output_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (outputMessages) {
                System.out.println("Images will be in directory " + this.output_dir);
            }
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    Object object;
                    this.decode_pdf.decodePage(i);
                    PdfImageData pdfImageData = this.decode_pdf.getPdfImageData();
                    int n4 = pdfImageData.getImageCount();
                    if (n4 > 0) {
                        String string4;
                        if (outputMessages) {
                            System.out.println("Page " + i + " contains " + n4 + " images");
                        }
                        if (!((File)(object = new File(string4 = this.output_dir + this.separator + i))).exists()) {
                            ((File)object).mkdirs();
                        }
                    }
                    for (int j = 0; j < n4; ++j) {
                        object = pdfImageData.getImageName(j);
                        try {
                            BufferedImage bufferedImage = this.decode_pdf.getObjectStore().loadStoredImage('R' + (String)object);
                            String string5 = this.output_dir + i + this.separator;
                            this.saveImage(bufferedImage, string5 + 'R' + (String)object + '.' + prefix, prefix);
                            bufferedImage = this.decode_pdf.getObjectStore().loadStoredImage((String)object);
                            this.saveImage(bufferedImage, string5 + (String)object + '.' + prefix, prefix);
                            this.outputMetaDataToXML(string, i, pdfImageData, j, (String)object);
                            continue;
                        }
                        catch (Exception exception) {
                            System.err.println("Exception " + exception + " in extracting images");
                        }
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception exception) {
                this.decode_pdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
            }
            if (outputMessages) {
                System.out.println("Images read");
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void saveImage(BufferedImage bufferedImage, String string, String string2) {
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        if (string2.indexOf("tif") != -1 && JAIHelper.isJAIused()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                String string3 = System.getProperty("compress_tiff");
                boolean bl = string3 != null;
                TIFFEncodeParam tIFFEncodeParam = null;
                if (bl) {
                    tIFFEncodeParam = new TIFFEncodeParam();
                    tIFFEncodeParam.setCompression(32946);
                }
                JAI.create((String)"encode", (RenderedImage)bufferedImage, (Object)fileOutputStream, (Object)"TIFF", (Object)tIFFEncodeParam);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else {
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void outputMetaDataToXML(String string, int n, PdfImageData pdfImageData, int n2, String string2) {
        float f = pdfImageData.getImageXCoord(n2);
        float f2 = pdfImageData.getImageYCoord(n2);
        float f3 = pdfImageData.getImageWidth(n2);
        float f4 = pdfImageData.getImageHeight(n2);
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("meta");
            document.appendChild(element);
            Comment comment = document.createComment("Created " + TimeNow.getShortTimeNow());
            document.appendChild(comment);
            Comment comment2 = document.createComment("Pixel Location of image x1,y1,x2,y2");
            document.appendChild(comment2);
            Comment comment3 = document.createComment("x1,y1 is top left corner origin is bottom left corner");
            document.appendChild(comment3);
            Element element2 = document.createElement("PAGELOCATION");
            element2.setAttribute("x1", String.valueOf(f));
            element2.setAttribute("y1", String.valueOf(f2 + f4));
            element2.setAttribute("x2", String.valueOf(f + f3));
            element2.setAttribute("y2", String.valueOf(f2));
            element.appendChild(element2);
            Element element3 = document.createElement("FILE");
            element3.setAttribute("value", string);
            element.appendChild(element3);
            String string3 = pdfImageData.getParentXForm(string2);
            if (string3 != null) {
                object2 = document.createElement("OPI");
                element.appendChild((Node)object2);
                object = pdfImageData.getXFormData(string3);
                this.addOPIDataToXML((Element)object2, (Map)object, document);
            }
            if (!isTest) {
                object2 = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
                object = TransformerFactory.newInstance();
                Transformer transformer = ((TransformerFactory)object).newTransformer(new StreamSource((InputStream)object2));
                transformer.transform(new DOMSource(document), new StreamResult(this.output_dir + n + this.separator + string2 + ".xml"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addOPIDataToXML(Element element, Map map, Document document) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Element element2;
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof String) {
                element2 = document.createElement(string);
                element.appendChild(element2);
                element2.setAttribute("value", (String)v);
                continue;
            }
            if (!(v instanceof Map)) continue;
            element2 = null;
            if (string.equals("1.3") || string.equals("2.0")) {
                element2 = element;
                element2.setAttribute("version", string);
            } else {
                element2 = document.createElement(string);
                element.appendChild(element2);
            }
            this.addOPIDataToXML(element2, (Map)v, document);
        }
    }

    public static void main(String[] stringArray) {
        File file;
        if (outputMessages) {
            System.out.println("Simple demo to extract images from a page");
        }
        String string = test_file;
        boolean bl = false;
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example can take 1 or 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is optional values of image type (jpeg,tiff,png). Default is png");
            System.exit(1);
        } else if (n == 1) {
            string = stringArray[0];
            System.out.println("file name=" + string);
        } else if (n < 3) {
            string = stringArray[0];
            if (outputMessages) {
                System.out.println("File :" + string);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.toLowerCase();
                if (string3.equals("tif") | string3.equals("tiff")) {
                    prefix = "tif";
                    continue;
                }
                if (string3.equals("png")) {
                    prefix = "png";
                    continue;
                }
                bl = true;
                System.out.println("value args not recognised as valid parameter.");
                System.out.println("please enter \"tif\", \"tiff\" or \"png\".");
            }
        } else {
            bl = true;
            System.out.println("too many arguments entered - run with no values to see defaults");
        }
        if (bl) {
            String string4 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = string4 + stringArray[i] + '\n';
            }
            System.out.println("you entered:\n" + string4 + "as the arguments");
        }
        if (!(file = new File(string)).exists()) {
            System.out.println("File " + string + " not found");
        }
        ExtractImages extractImages = new ExtractImages(string);
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    private byte[] toByteArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        int n = 0;
        while (n != -1) {
            n = inputStream.read(byArray);
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        prefix = "png";
        test_file = "/mnt/shared/Poloznicel_nalozbene_test_1.pdf";
    }
}

