/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;

public class ComponentData {
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected Javascript javascript;
    protected int pageHeight;
    protected int cropOtherY;
    protected int indent;
    protected float displayScaling;
    protected float scaling = 0.0f;
    protected int rotation;
    protected float lastScaling = -1.0f;
    protected float oldRotation = 0.0f;
    protected float oldIndent = 0.0f;
    protected int startPage;
    protected int endPage;
    protected int currentPage;
    protected String lastNameAdded = "";
    protected Map duplicates = new HashMap();
    protected Map lastValidValue = new HashMap();
    protected Map lastUnformattedValue = new HashMap();
    protected Map additionFieldsMap = new HashMap();
    protected Map nameToCompIndex;
    protected Map typeValues;
    protected int nextFreeField = 0;
    protected float[][] boundingBoxs;
    protected int[] fontSize;
    protected int[] xReached;
    protected int[] yReached;
    protected int[] trackPagesRendered;
    protected boolean[] firstTimeDisplayed;
    protected int[] fontSizes;
    protected String[] defaultValues;
    public int[] pageMap;

    public Object getLastValidValue(String string) {
        return this.lastValidValue.get(string);
    }

    public Object getLastUnformattedValue(String string) {
        return this.lastUnformattedValue.get(string);
    }

    public void reset() {
        this.lastValidValue.clear();
        this.lastUnformattedValue.clear();
    }

    public Integer getTypeValueByName(String string) {
        Object v = this.typeValues.get(string);
        if (v == null) {
            return FormFactory.UNKNOWN;
        }
        return (Integer)this.typeValues.get(string);
    }

    private int setStartForPage(int n) {
        this.trackPagesRendered[n] = this.nextFreeField;
        return this.nextFreeField;
    }

    public int getNextFreeField() {
        return this.nextFreeField;
    }

    public int getStartComponentCountForPage(int n) {
        if (this.trackPagesRendered == null) {
            return -999;
        }
        if (this.trackPagesRendered.length > n) {
            return this.trackPagesRendered[n];
        }
        return -1;
    }

    public void initParametersForPage(PdfPageData pdfPageData, int n) {
        int n2 = pdfPageData.getMediaBoxHeight(n);
        int n3 = pdfPageData.getCropBoxHeight(n) + pdfPageData.getCropBoxY(n);
        this.cropOtherY = 0;
        if (n2 != n3) {
            this.cropOtherY = n2 - n3;
        }
        this.pageHeight = n2;
        this.currentPage = n;
        this.setStartForPage(n);
    }

    public void resetComponents(int n, int n2, boolean bl) {
        this.nextFreeField = 0;
        this.additionFieldsMap.clear();
        if (!bl) {
            this.nameToCompIndex = new HashMap(n + 1);
            this.typeValues = new HashMap(n + 1);
            this.pageMap = new int[n + 1];
            this.fontSize = new int[n + 1];
            this.boundingBoxs = new float[n + 1][4];
            this.fontSizes = new int[n + 1];
            this.defaultValues = new String[n + 1];
            this.firstTimeDisplayed = new boolean[n + 1];
            this.trackPagesRendered = new int[n2 + 1];
            for (int i = 0; i < n2 + 1; ++i) {
                this.trackPagesRendered[i] = -1;
            }
        } else {
            boolean[] blArray = this.firstTimeDisplayed;
            int[] nArray = this.pageMap;
            int[] nArray2 = this.fontSize;
            String[] stringArray = this.defaultValues;
            float[][] fArray = this.boundingBoxs;
            int[] nArray3 = this.fontSizes;
            this.firstTimeDisplayed = new boolean[n + 1];
            this.pageMap = new int[n + 1];
            this.fontSize = new int[n + 1];
            this.defaultValues = new String[n + 1];
            this.boundingBoxs = new float[n + 1][4];
            this.fontSizes = new int[n + 1];
            int n3 = nArray.length;
            for (int i = 0; i < n + 1 && i != n3; ++i) {
                this.firstTimeDisplayed[i] = blArray[i];
                this.pageMap[i] = nArray[i];
                this.fontSize[i] = nArray2[i];
                this.defaultValues[i] = stringArray[i];
                System.arraycopy(fArray[i], 0, this.boundingBoxs[i], 0, 4);
                this.fontSizes[i] = nArray3[i];
                ++this.nextFreeField;
            }
        }
    }

    public void setPageValues(float f, int n) {
        this.scaling = f;
        this.rotation = n;
        this.displayScaling = f;
    }

    public void setPageData(PdfPageData pdfPageData, int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
        this.pageData = pdfPageData;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public void setPageDisplacements(int[] nArray, int[] nArray2) {
        this.xReached = nArray;
        this.yReached = nArray2;
    }

    public void setJavascript(Javascript javascript) {
        this.javascript = javascript;
    }

    public void resetDuplicates() {
        this.duplicates.clear();
    }
}

