/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.query;

import clinical.server.utils.OracleUtils;
import clinical.utils.Assertion;
import clinical.web.ISQLDialect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class OracleSQLDialect
implements ISQLDialect {
    @Override
    public String prepareBooleanPredicate(String prefix, boolean value) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(' ').append(value ? "1" : "0");
        return buf.toString();
    }

    @Override
    public String prepareBooleanValue(Boolean value) {
        return value != false ? "1" : "0";
    }

    @Override
    public String prepareSchemaObjectName(String schemaObjName) {
        return schemaObjName;
    }

    @Override
    public String prepareString(String value) {
        StringBuffer buf = new StringBuffer();
        value = OracleUtils.escapeQuotes(value);
        buf.append('\'').append(value).append('\'');
        return buf.toString();
    }

    @Override
    public String getDialectName() {
        return "OracleDialect";
    }

    @Override
    public void invokeSetter(Method m, Object vo, Object value, int colType) throws SQLException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        if (value != null && value instanceof TIMESTAMP) {
            m.invoke(vo, ((TIMESTAMP)value).timestampValue());
        } else if (value != null && colType == 2005) {
            String s = OracleUtils.readCLOB((CLOB)value);
            m.invoke(vo, s);
        } else {
            Class<?> paramClazz = m.getParameterTypes()[0];
            if (paramClazz == Boolean.class) {
                Boolean boolValue = null;
                if (value != null) {
                    boolValue = new Boolean(((BigDecimal)value).intValue() >= 1);
                }
                m.invoke(vo, boolValue);
            } else if (value != null && value instanceof DATE) {
                if (m.getParameterTypes()[0] == Timestamp.class) {
                    Timestamp ts = ((DATE)value).timestampValue();
                    m.invoke(vo, ts);
                } else {
                    m.invoke(vo, new Date(((DATE)value).longValue()));
                }
            } else {
                m.invoke(vo, value);
            }
        }
    }

    @Override
    public String endsWithFunction(String schemaColName, String suffix) {
        Assertion.assertNotNull(suffix);
        String colName = this.prepareSchemaObjectName(schemaColName);
        StringBuilder sb = new StringBuilder(50);
        sb.append("substr(").append(colName).append(",length(");
        sb.append(colName).append(") - ").append(suffix.length() - 1);
        sb.append(",").append(suffix.length()).append(") = ");
        sb.append(this.prepareString(suffix));
        return sb.toString();
    }
}

