/*
 * Decompiled with CFR 0.152.
 */
package guilib.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class BaseDialog
extends JDialog
implements ActionListener {
    protected JPanel buttonPanel = new JPanel();
    protected Map buttonList = new LinkedHashMap(3);
    protected int returnCode;
    public static int NONE = 0;
    public static int OK_PRESSED = 1;
    public static int CANCEL_PRESSED = 2;
    public static int BUTTON1_PRESSED = 3;
    public static int BUTTON2_PRESSED = 3;
    public static int BUTTON3_PRESSED = 3;
    public static int BUTTON4_PRESSED = 3;

    public BaseDialog(Frame owner, String title, String[] buttonNames) {
        super(owner, title, true);
        int i = 0;
        while (i < buttonNames.length) {
            JButton button = new JButton(buttonNames[i]);
            this.buttonList.put(buttonNames[i], button);
            button.addActionListener(this);
            ++i;
        }
        this.returnCode = NONE;
        this.createButtonPanel();
        this.setLocationRelativeTo(owner);
        this.pack();
    }

    protected void createButtonPanel() {
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(Box.createHorizontalGlue());
        Iterator iter = this.buttonList.values().iterator();
        while (iter.hasNext()) {
            JButton button = (JButton)iter.next();
            this.buttonPanel.add(button);
            if (!iter.hasNext()) continue;
            this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnCode;
    }

    public JButton getButton(String name) {
        return (JButton)this.buttonList.get(name);
    }

    public void setDefaultButton(String name) {
        JButton button = (JButton)this.buttonList.get(name);
        if (button != null) {
            super.getRootPane().setDefaultButton(button);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

