/*
 * Decompiled with CFR 0.152.
 */
package guilib.dtree;

import guilib.common.SwingWorker;
import guilib.dtree.TreeNodeFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DynamicTree
extends JTree {
    protected Worker worker;
    protected boolean needsUpdating = true;
    protected TreeNodeFactory factory;
    protected int expireTime;
    protected Hashtable updateAgeMap = new Hashtable();

    public DynamicTree(TreeNode root, TreeNodeFactory factory, int expirationTime) {
        super(root);
        this.expireTime = expirationTime;
        this.factory = factory;
    }

    public DynamicTree(TreeNode root, TreeNodeFactory factory) {
        this(root, factory, 30000);
    }

    public void setNeedsUpdating(boolean value) {
        this.needsUpdating = value;
    }

    public void treeBranchCollapsed(TreeExpansionEvent evt) {
    }

    public void treeBranchExpanded(TreeExpansionEvent evt) {
        AgeInfo ai = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        ai = (AgeInfo)this.updateAgeMap.get(node);
        if (ai == null) {
            ai = new AgeInfo();
            this.updateAgeMap.put(node, ai);
        } else {
            if (!ai.isExpired(this.expireTime)) {
                return;
            }
            this.updateAgeMap.remove(node);
            this.updateAgeMap.put(node, new AgeInfo());
        }
        this.stopWorker();
        if (this.factory != null) {
            this.startWorker(this.factory, node);
        }
    }

    protected void startWorker(TreeNodeFactory factory, DefaultMutableTreeNode node) {
        this.worker = new Worker(node, factory, this);
        this.worker.start();
    }

    protected void stopWorker() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    public static class AgeInfo {
        long start = System.currentTimeMillis();

        public long getAge() {
            return System.currentTimeMillis() - this.start;
        }

        public boolean isExpired(int exprTime) {
            return System.currentTimeMillis() - this.start > (long)exprTime;
        }
    }

    static class Worker
    extends SwingWorker {
        DefaultMutableTreeNode node;
        TreeNodeFactory fac;
        DynamicTree dt;

        public Worker(DefaultMutableTreeNode node, TreeNodeFactory fac, DynamicTree dt) {
            this.node = node;
            this.fac = fac;
            this.dt = dt;
        }

        public Object construct() throws Exception {
            return this.fac.createChildren(this.node.getUserObject());
        }

        public void finished() {
            if (this.dt.worker == this) {
                this.dt.worker = null;
            }
            try {
                this.node.removeAllChildren();
                DefaultMutableTreeNode[] children = (DefaultMutableTreeNode[])this.get();
                int i = 0;
                while (i < children.length) {
                    this.node.insert(children[i], i);
                    ++i;
                }
                DefaultTreeModel model = (DefaultTreeModel)this.dt.getModel();
                model.nodeStructureChanged(this.node);
                System.out.println("node structure changed " + this.node);
            }
            catch (InvocationTargetException ix) {
                ix.printStackTrace();
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

