/*
 * Decompiled with CFR 0.152.
 */
package guilib.dtree.filebrowser;

import guilib.AppFrame;
import guilib.dtree.DynamicTree;
import guilib.dtree.filebrowser.FileBrowserNodeFactory;
import guilib.dtree.filebrowser.FileNode;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FileBrowser
extends AppFrame {
    DynamicTree dt;
    String rootDir;

    public FileBrowser(String rootDir) {
        this.rootDir = rootDir;
        this.init();
    }

    protected void init() {
        JScrollPane pane = new JScrollPane();
        pane.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new FileNode(this.rootDir, null));
        this.populate(root);
        this.dt = new DynamicTree((TreeNode)root, new FileBrowserNodeFactory());
        ((DefaultTreeModel)this.dt.getModel()).setAsksAllowsChildren(true);
        this.dt.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                FileBrowser.this.dt.treeBranchCollapsed(e);
            }

            public void treeExpanded(TreeExpansionEvent e) {
                FileBrowser.this.dt.treeBranchExpanded(e);
            }
        });
        pane.add(this.dt);
        pane.setViewportView(this.dt);
        this.getContentPane().add(pane);
    }

    void populate(DefaultMutableTreeNode root) {
        if (((FileNode)root.getUserObject()).isDirectory()) {
            FileNode parent = (FileNode)root.getUserObject();
            File[] flist = parent.getFile().listFiles();
            int i = 0;
            while (i < flist.length) {
                FileNode fn = new FileNode(flist[i].getName(), parent);
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(fn, flist[i].isDirectory());
                root.add(child);
                if (flist[i].isDirectory()) {
                    this.populate(child);
                }
                ++i;
            }
        } else {
            return;
        }
    }

    public boolean postEvent(Event evt) {
        return true;
    }

    public Font getFont() {
        return null;
    }

    public static void main(String[] args) {
        FileBrowser fb = new FileBrowser("/home/bozyurt/dev/java/guilib/src");
        fb.startup();
    }
}

