/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtils() {
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null) {
            return defaultTempDir;
        }
        String s = System.getProperty(FileUtils.class.getName() + ".TempDirectory");
        if (s == null) {
            int x = (int)(Math.random() * 1000000.0);
            s = System.getProperty("java.io.tmpdir");
            File f = new File(s, "cxf-tmp-" + x);
            while (!f.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f = new File(s, "cxf-tmp-" + x);
            }
            defaultTempDir = f;
            Thread hook = new Thread(){

                public void run() {
                    FileUtils.removeDir(defaultTempDir);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            File f = new File(s);
            f.mkdirs();
            defaultTempDir = f;
        }
        return defaultTempDir;
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtils.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtils.removeDir(f);
                continue;
            }
            FileUtils.delete(f);
        }
        FileUtils.delete(d);
    }

    public static void delete(File f) {
        if (!f.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix, suffix, null, false);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) throws IOException {
        File parent;
        File result = null;
        File file = parent = parentDir == null ? FileUtils.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "cxf";
        } else if (prefix.length() < 3) {
            prefix = prefix + "cxf";
        }
        result = File.createTempFile(prefix, suffix, parent);
        if (deleteOnExit && parentDir != null) {
            result.deleteOnExit();
        }
        return result;
    }
}

