/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.impl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.chain.Context;

public class ContextBase
extends HashMap
implements Context {
    private transient Map descriptors = null;
    private transient PropertyDescriptor[] pd = null;
    private static Object singleton = new Serializable(){

        public boolean equals(Object object) {
            return false;
        }
    };
    private static Object[] zeroParams = new Object[0];

    public ContextBase() {
        this.initialize();
    }

    public ContextBase(Map map) {
        super(map);
        this.initialize();
        this.putAll(map);
    }

    public void clear() {
        if (this.descriptors == null) {
            super.clear();
        } else {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                if (this.descriptors.containsKey(key)) continue;
                keys.remove();
            }
        }
    }

    public boolean containsValue(Object value) {
        if (this.descriptors == null) {
            return super.containsValue(value);
        }
        if (super.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.pd.length; ++i) {
            if (this.pd[i].getReadMethod() == null) continue;
            Object prop = this.readProperty(this.pd[i]);
            if (!(value == null ? prop == null : value.equals(prop))) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySetImpl();
    }

    public Object get(Object key) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.get(key);
        }
        if (key != null && (descriptor = (PropertyDescriptor)this.descriptors.get(key)) != null) {
            if (descriptor.getReadMethod() != null) {
                return this.readProperty(descriptor);
            }
            return null;
        }
        return super.get(key);
    }

    public boolean isEmpty() {
        if (this.descriptors == null) {
            return super.isEmpty();
        }
        return super.size() <= this.descriptors.size();
    }

    public Set keySet() {
        return super.keySet();
    }

    public Object put(Object key, Object value) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.put(key, value);
        }
        if (key != null && (descriptor = (PropertyDescriptor)this.descriptors.get(key)) != null) {
            Object previous = null;
            if (descriptor.getReadMethod() != null) {
                previous = this.readProperty(descriptor);
            }
            this.writeProperty(descriptor, value);
            return previous;
        }
        return super.put(key, value);
    }

    public void putAll(Map map) {
        Iterator pairs = map.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            this.put(pair.getKey(), pair.getValue());
        }
    }

    public Object remove(Object key) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.remove(key);
        }
        if (key != null && (descriptor = (PropertyDescriptor)this.descriptors.get(key)) != null) {
            throw new UnsupportedOperationException("Local property '" + key + "' cannot be removed");
        }
        return super.remove(key);
    }

    public Collection values() {
        return new ValuesImpl();
    }

    private Iterator entriesIterator() {
        return new EntrySetIterator();
    }

    private Map.Entry entry(Object key) {
        if (this.containsKey(key)) {
            return new MapEntryImpl(key, this.get(key));
        }
        return null;
    }

    private void initialize() {
        try {
            this.pd = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            this.pd = new PropertyDescriptor[0];
        }
        for (int i = 0; i < this.pd.length; ++i) {
            String name = this.pd[i].getName();
            if ("class".equals(name) || "empty".equals(name)) continue;
            if (this.descriptors == null) {
                this.descriptors = new HashMap(this.pd.length - 2);
            }
            this.descriptors.put(name, this.pd[i]);
            super.put(name, singleton);
        }
    }

    private Object readProperty(PropertyDescriptor descriptor) {
        try {
            Method method = descriptor.getReadMethod();
            if (method == null) {
                throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' is not readable");
            }
            return method.invoke((Object)this, zeroParams);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Exception reading property '" + descriptor.getName() + "': " + e.getMessage());
        }
    }

    private boolean remove(Map.Entry entry) {
        Map.Entry actual = this.entry(entry.getKey());
        if (actual == null) {
            return false;
        }
        if (!((Object)entry).equals(actual)) {
            return false;
        }
        this.remove(entry.getKey());
        return true;
    }

    private Iterator valuesIterator() {
        return new ValuesIterator();
    }

    private void writeProperty(PropertyDescriptor descriptor, Object value) {
        try {
            Method method = descriptor.getWriteMethod();
            if (method == null) {
                throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' is not writeable");
            }
            method.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Exception writing property '" + descriptor.getName() + "': " + e.getMessage());
        }
    }

    private class ValuesIterator
    implements Iterator {
        private Map.Entry entry = null;
        private Iterator keys = ContextBase.this.keySet().iterator();

        private ValuesIterator() {
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            this.entry = ContextBase.this.entry(this.keys.next());
            return this.entry.getValue();
        }

        public void remove() {
            ContextBase.this.remove(this.entry);
        }
    }

    private class ValuesImpl
    extends AbstractCollection {
        private ValuesImpl() {
        }

        public void clear() {
            ContextBase.this.clear();
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return ContextBase.this.containsValue(entry.getValue());
        }

        public boolean isEmpty() {
            return ContextBase.this.isEmpty();
        }

        public Iterator iterator() {
            return ContextBase.this.valuesIterator();
        }

        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                return ContextBase.this.remove((Map.Entry)obj);
            }
            return false;
        }

        public int size() {
            return ContextBase.this.size();
        }
    }

    private class MapEntryImpl
    implements Map.Entry {
        private Object key;
        private Object value;

        MapEntryImpl(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            if (this.key == null) {
                return entry.getKey() == null;
            }
            if (this.key.equals(entry.getKey())) {
                if (this.value == null) {
                    return entry.getValue() == null;
                }
                return this.value.equals(entry.getValue());
            }
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object value) {
            Object previous = this.value;
            ContextBase.this.put(this.key, value);
            this.value = value;
            return previous;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySetIterator
    implements Iterator {
        private Map.Entry entry = null;
        private Iterator keys = ContextBase.this.keySet().iterator();

        private EntrySetIterator() {
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            this.entry = ContextBase.this.entry(this.keys.next());
            return this.entry;
        }

        public void remove() {
            ContextBase.this.remove(this.entry);
        }
    }

    private class EntrySetImpl
    extends AbstractSet {
        private EntrySetImpl() {
        }

        public void clear() {
            ContextBase.this.clear();
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Map.Entry actual = ContextBase.this.entry(entry.getKey());
            if (actual != null) {
                return ((Object)actual).equals(entry);
            }
            return false;
        }

        public boolean isEmpty() {
            return ContextBase.this.isEmpty();
        }

        public Iterator iterator() {
            return ContextBase.this.entriesIterator();
        }

        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                return ContextBase.this.remove((Map.Entry)obj);
            }
            return false;
        }

        public int size() {
            return ContextBase.this.size();
        }
    }
}

