/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Iterator;
import org.apache.struts2.components.Component;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.jsp.IteratorStatus;

@StrutsTag(name="iterator", tldTagClass="org.apache.struts2.views.jsp.IteratorTag", description="Iterate over a iterable value")
public class IteratorComponent
extends Component {
    protected Iterator iterator;
    protected IteratorStatus status;
    protected Object oldStatus;
    protected IteratorStatus.StatusState statusState;
    protected String statusAttr;
    protected String value;

    public IteratorComponent(ValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        if (this.statusAttr != null) {
            this.statusState = new IteratorStatus.StatusState();
            this.status = new IteratorStatus(this.statusState);
        }
        ValueStack stack = this.getStack();
        if (this.value == null) {
            this.value = "top";
        }
        this.iterator = MakeIterator.convert(this.findValue(this.value));
        if (this.iterator != null && this.iterator.hasNext()) {
            Object currentValue = this.iterator.next();
            stack.push(currentValue);
            String id = this.getId();
            if (id != null && currentValue != null) {
                stack.getContext().put(id, currentValue);
            }
            if (this.statusAttr != null) {
                this.statusState.setLast(!this.iterator.hasNext());
                this.oldStatus = stack.getContext().get(this.statusAttr);
                stack.getContext().put(this.statusAttr, this.status);
            }
            return true;
        }
        super.end(writer, "");
        return false;
    }

    public boolean end(Writer writer, String body) {
        ValueStack stack = this.getStack();
        if (this.iterator != null) {
            stack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            Object currentValue = this.iterator.next();
            stack.push(currentValue);
            String id = this.getId();
            if (id != null && currentValue != null) {
                stack.getContext().put(id, currentValue);
            }
            if (this.status != null) {
                this.statusState.next();
                this.statusState.setLast(!this.iterator.hasNext());
            }
            return true;
        }
        if (this.status != null) {
            if (this.oldStatus == null) {
                stack.getContext().put(this.statusAttr, null);
            } else {
                stack.getContext().put(this.statusAttr, this.oldStatus);
            }
        }
        super.end(writer, "");
        return false;
    }

    @StrutsTagAttribute(description="If specified, an instanceof IteratorStatus will be pushed into stack upon each iteration", type="Boolean", defaultValue="false")
    public void setStatus(String status) {
        this.statusAttr = status;
    }

    @StrutsTagAttribute(description="the iteratable source to iterate over, else an the object itself will be put into a newly created List")
    public void setValue(String value) {
        this.value = value;
    }
}

