/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.Command;
import com.jamonapi.utils.CommandIterator;
import com.jamonapi.utils.EnumIterator;
import com.jamonapi.utils.ResultSetUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CommandIterator {
    private CommandIterator() {
    }

    public static void iterate(ResultSet resultSet, Command command) throws Exception {
        ResultSetUtils rsu = ResultSetUtils.createInstance();
        ArrayList arrayList = new ArrayList();
        rsu.resultSetToArrayList(arrayList, resultSet);
        CommandIterator.iterate(arrayList, command);
    }

    public static void iterate(Collection collection, Command command) throws Exception {
        CommandIterator.iterate(collection.iterator(), command);
    }

    public static void iterate(Enumeration enumeration, Command command) throws Exception {
        CommandIterator.iterate(new EnumIterator(enumeration), command);
    }

    public static void iterate(Iterator iterator, Command command) throws Exception {
        while (iterator.hasNext()) {
            command.execute(iterator.next());
        }
    }

    public static void iterate(Map map, Command command) throws Exception {
        CommandIterator.iterate(map.entrySet().iterator(), command);
    }

    public static void main(String[] argv) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector<String> vector = new Vector<String>();
        class TestCommand
        implements Command {
            TestCommand() {
            }

            public void execute(Object value) throws Exception {
                System.out.println("command" + value);
            }
        }
        TestCommand testCommand = new TestCommand();
        arrayList.add("1");
        arrayList.add("2");
        arrayList.add("3");
        vector.addElement("4");
        vector.addElement("5");
        vector.addElement("6");
        CommandIterator.iterate(arrayList, (Command)testCommand);
        CommandIterator.iterate(vector.elements(), (Command)testCommand);
    }
}

