/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;

public class MultilevelTotalTableDecorator
extends TableDecorator {
    private boolean containsTotaledColumns = false;
    private static final int NO_RESET_GROUP = 4200;
    private Map groupNumberToGroupTotal = new HashMap();
    private int deepestResetGroup = 4200;
    protected int innermostGroup;
    private Log logger = LogFactory.getLog((Class)MultilevelTotalTableDecorator.class);
    protected String grandTotalSum = "grandtotal-sum";
    protected String grandTotalNoSum = "grandtotal-nosum";
    protected String grandTotalLabel = "grandtotal-label";
    protected String grandTotalDescription = "Grand Total";
    private String subtotalHeaderClass = "subtotal-header";
    private String subtotalLabelClass = "subtotal-label";
    private MessageFormat subtotalDesc = new MessageFormat("{0} Total");
    private String subtotalValueClass = "subtotal-sum";
    private List headerRows = new ArrayList(5);

    public void init(PageContext context, Object decorated, TableModel model) {
        super.init(context, decorated, model);
        List headerCells = model.getHeaderCellList();
        Iterator iterator = headerCells.iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            boolean bl = this.containsTotaledColumns = this.containsTotaledColumns || headerCell.isTotaled();
            if (headerCell.getGroup() <= 0) continue;
            this.groupNumberToGroupTotal.put(new Integer(headerCell.getGroup()), new GroupTotals(headerCell.getColumnNumber()));
            if (headerCell.getGroup() <= this.innermostGroup) continue;
            this.innermostGroup = headerCell.getGroup();
        }
    }

    public String getGrandTotalDescription() {
        return this.grandTotalDescription;
    }

    public void setGrandTotalDescription(String grandTotalDescription) {
        this.grandTotalDescription = grandTotalDescription;
    }

    public void setSubtotalLabel(String pattern, Locale locale) {
        this.subtotalDesc = new MessageFormat(pattern, locale);
    }

    public String getGrandTotalLabel() {
        return this.grandTotalLabel;
    }

    public String getGrandTotalSum() {
        return this.grandTotalSum;
    }

    public String getGrandTotalNoSum() {
        return this.grandTotalNoSum;
    }

    public void setGrandTotalNoSum(String grandTotalNoSum) {
        this.grandTotalNoSum = grandTotalNoSum;
    }

    public void setGrandTotalSum(String grandTotalSum) {
        this.grandTotalSum = grandTotalSum;
    }

    public void setGrandTotalLabel(String grandTotalLabel) {
        this.grandTotalLabel = grandTotalLabel;
    }

    public String getSubtotalValueClass() {
        return this.subtotalValueClass;
    }

    public void setSubtotalValueClass(String subtotalValueClass) {
        this.subtotalValueClass = subtotalValueClass;
    }

    public String getSubtotalLabelClass() {
        return this.subtotalLabelClass;
    }

    public void setSubtotalLabelClass(String subtotalLabelClass) {
        this.subtotalLabelClass = subtotalLabelClass;
    }

    public String getSubtotalHeaderClass() {
        return this.subtotalHeaderClass;
    }

    public void setSubtotalHeaderClass(String subtotalHeaderClass) {
        this.subtotalHeaderClass = subtotalHeaderClass;
    }

    public void startOfGroup(String value, int group) {
        if (this.containsTotaledColumns) {
            StringBuffer tr = new StringBuffer();
            tr.append("<tr>");
            GroupTotals groupTotals = (GroupTotals)this.groupNumberToGroupTotal.get(new Integer(group));
            int myColumnNumber = groupTotals.columnNumber;
            for (int i = 0; i < myColumnNumber; ++i) {
                tr.append("<td></td>\n");
            }
            tr.append("<td class=\"").append(this.getSubtotalHeaderClass()).append(" group-").append(group).append("\" >");
            tr.append(value).append("</td>\n");
            List headerCells = this.tableModel.getHeaderCellList();
            for (int i = myColumnNumber; i < headerCells.size() - 1; ++i) {
                tr.append("<td></td>\n");
            }
            tr.append("</tr>\n");
            this.headerRows.add(tr);
        }
    }

    public String displayGroupedValue(String value, short groupingStatus, int columnNumber) {
        return "";
    }

    public String startRow() {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.headerRows.iterator();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = (StringBuffer)iterator.next();
            sb.append(stringBuffer);
        }
        return sb.toString();
    }

    public void endOfGroup(String value, int groupNumber) {
        if (this.deepestResetGroup > groupNumber) {
            this.deepestResetGroup = groupNumber;
        }
    }

    public String finishRow() {
        String returnValue = "";
        if (this.containsTotaledColumns) {
            if (this.innermostGroup > 0 && this.deepestResetGroup != 4200) {
                StringBuffer out = new StringBuffer();
                for (int i = this.innermostGroup; i >= this.deepestResetGroup; --i) {
                    Integer groupNumber = new Integer(i);
                    GroupTotals totals = (GroupTotals)this.groupNumberToGroupTotal.get(groupNumber);
                    if (totals == null) {
                        this.logger.warn((Object)("There is a gap in the defined groups - no group defined for " + groupNumber));
                        continue;
                    }
                    totals.printTotals(this.getListIndex(), out);
                    totals.setStartRow(this.getListIndex() + 1);
                }
                returnValue = out.toString();
            } else {
                returnValue = null;
            }
            this.deepestResetGroup = 4200;
            this.headerRows.clear();
            if (this.isLastRow()) {
                returnValue = StringUtils.defaultString((String)returnValue);
                returnValue = returnValue + this.totalAllRows();
            }
        }
        return returnValue;
    }

    protected String totalAllRows() {
        if (this.containsTotaledColumns) {
            List headerCells = this.tableModel.getHeaderCellList();
            StringBuffer output = new StringBuffer();
            int currentRow = this.getListIndex();
            output.append("\n<tr class=\"grandtotal-row\">");
            boolean first = true;
            Iterator iterator = headerCells.iterator();
            while (iterator.hasNext()) {
                HeaderCell headerCell = (HeaderCell)iterator.next();
                if (first) {
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalLabel()));
                    output.append(this.getGrandTotalDescription());
                    first = false;
                } else if (headerCell.isTotaled()) {
                    Object total = this.getTotalForColumn(headerCell.getColumnNumber(), 0, currentRow);
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalSum()));
                    output.append(this.formatTotal(headerCell, total));
                } else {
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalNoSum()));
                }
                output.append("</td>");
            }
            output.append("\n</tr>\n");
            return output.toString();
        }
        return "";
    }

    protected String getCellValue(int columnNumber, int rowNumber) {
        List fullList = this.tableModel.getRowListFull();
        Row row = (Row)fullList.get(rowNumber);
        ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
        while (columnIterator.hasNext()) {
            Column column = columnIterator.nextColumn();
            if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
            try {
                column.initialize();
                return column.getChoppedAndLinkedValue();
            }
            catch (ObjectLookupException e) {
                this.logger.error((Object)("Error: " + e.getMessage()), (Throwable)((Object)e));
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
            catch (DecoratorException e) {
                this.logger.error((Object)("Error: " + e.getMessage()), (Throwable)((Object)e));
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        throw new RuntimeException("Unable to find column " + columnNumber + " in the list of columns");
    }

    protected Object getTotalForColumn(int columnNumber, int startRow, int stopRow) {
        List fullList = this.tableModel.getRowListFull();
        List window = fullList.subList(startRow, stopRow + 1);
        Object total = null;
        Iterator iterator = window.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
                Object value = null;
                try {
                    value = column.getValue(false);
                }
                catch (ObjectLookupException e) {
                    this.logger.error((Object)e);
                }
                catch (DecoratorException e) {
                    this.logger.error((Object)e);
                }
                if (value == null || "".equals(value)) continue;
                total = this.add(column, total, value);
            }
        }
        return total;
    }

    protected Object add(Column column, Object total, Object value) {
        if (value == null) {
            return total;
        }
        if (value instanceof Number) {
            Number oldTotal = new Double(0.0);
            if (total != null) {
                oldTotal = (Number)total;
            }
            return new Double(oldTotal.doubleValue() + ((Number)value).doubleValue());
        }
        throw new UnsupportedOperationException("Cannot add a value of " + value + " in column " + column.getHeaderCell().getTitle());
    }

    public String getTotalsTdOpen(HeaderCell header, String totalClass) {
        String cssClass = ObjectUtils.toString(header.getHtmlAttributes().get("class"));
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<");
        buffer.append("td");
        if (cssClass != null || totalClass != null) {
            buffer.append(" class=\"");
            if (cssClass != null) {
                buffer.append(cssClass);
                if (totalClass != null) {
                    buffer.append(" ");
                }
            }
            if (totalClass != null) {
                buffer.append(totalClass);
            }
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public String getTotalsRowOpen() {
        return "\n<tr class=\"subtotal\">";
    }

    public String getTotalRowLabel(String groupingValue) {
        return this.subtotalDesc.format(new Object[]{groupingValue});
    }

    public String formatTotal(HeaderCell header, Object total) {
        Object displayValue = total;
        if (header.getColumnDecorators().length > 0) {
            for (int i = 0; i < header.getColumnDecorators().length; ++i) {
                DisplaytagColumnDecorator decorator = header.getColumnDecorators()[i];
                try {
                    displayValue = decorator.decorate(total, this.getPageContext(), this.tableModel.getMedia());
                    continue;
                }
                catch (DecoratorException e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        return displayValue != null ? displayValue.toString() : "";
    }

    class GroupTotals {
        protected String totalLabelClass;
        protected String totalsRowOpen;
        protected String totalValueClass;
        private int columnNumber;
        private int firstRowOfCurrentSet;

        public GroupTotals(int headerCellColumn) {
            this.totalLabelClass = MultilevelTotalTableDecorator.this.getSubtotalLabelClass();
            this.totalsRowOpen = MultilevelTotalTableDecorator.this.getTotalsRowOpen();
            this.totalValueClass = MultilevelTotalTableDecorator.this.getSubtotalValueClass();
            this.columnNumber = headerCellColumn;
            this.firstRowOfCurrentSet = 0;
        }

        public void printTotals(int currentRow, StringBuffer out) {
            List headerCells = MultilevelTotalTableDecorator.this.tableModel.getHeaderCellList();
            if (this.firstRowOfCurrentSet < currentRow) {
                out.append(this.totalsRowOpen);
                Iterator iterator = headerCells.iterator();
                while (iterator.hasNext()) {
                    HeaderCell headerCell = (HeaderCell)iterator.next();
                    if (this.columnNumber == headerCell.getColumnNumber()) {
                        String currentLabel = MultilevelTotalTableDecorator.this.getCellValue(this.columnNumber, this.firstRowOfCurrentSet);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalLabelClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.getTotalRowLabel(currentLabel));
                    } else if (headerCell.isTotaled()) {
                        Object total = MultilevelTotalTableDecorator.this.getTotalForColumn(headerCell.getColumnNumber(), this.firstRowOfCurrentSet, currentRow);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalValueClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.formatTotal(headerCell, total));
                    } else {
                        String style = "group-" + (this.columnNumber + 1);
                        if (headerCell.getColumnNumber() < MultilevelTotalTableDecorator.this.innermostGroup) {
                            style = style + " " + this.getTotalLabelClass() + " ";
                        }
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, style));
                    }
                    out.append("</td>");
                }
                out.append("\n</tr>\n");
            }
        }

        public void setStartRow(int i) {
            this.firstRowOfCurrentSet = i;
        }

        public String getTotalLabelClass() {
            return this.totalLabelClass;
        }

        public void setTotalsRowOpen(String totalsRowOpen) {
            this.totalsRowOpen = totalsRowOpen;
        }

        public void setTotalLabelClass(String totalLabelClass) {
            this.totalLabelClass = totalLabelClass;
        }

        public String getTotalValueClass() {
            return this.totalValueClass;
        }

        public void setTotalValueClass(String totalValueClass) {
            this.totalValueClass = totalValueClass;
        }
    }
}

