/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.pagination.Pagination;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;

public class PaginatedListSmartListHelper
extends SmartListHelper {
    private PaginatedList paginatedList;
    private TableProperties properties;
    private int pageCount;

    public PaginatedListSmartListHelper(PaginatedList paginatedList, TableProperties tableProperties) {
        this.paginatedList = paginatedList;
        this.properties = tableProperties;
        this.pageCount = this.computePageCount();
    }

    private int computePageCount() {
        int pageCount = this.paginatedList.getFullListSize() / Math.max(1, this.paginatedList.getObjectsPerPage());
        if (this.paginatedList.getFullListSize() % this.paginatedList.getObjectsPerPage() > 0) {
            ++pageCount;
        }
        return pageCount;
    }

    public int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.paginatedList.getPageNumber());
    }

    protected int getFirstIndexForPage(int pageNumber) {
        if (pageNumber > this.pageCount) {
            pageNumber = this.pageCount;
        }
        return (pageNumber - 1) * this.paginatedList.getObjectsPerPage();
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.paginatedList.getPageNumber());
    }

    protected int getLastIndexForPage(int pageNumber) {
        int result;
        if (pageNumber > this.pageCount) {
            pageNumber = this.pageCount;
        }
        if ((result = this.getFirstIndexForPage(pageNumber) + this.paginatedList.getObjectsPerPage() - 1) >= this.paginatedList.getFullListSize()) {
            result = this.paginatedList.getFullListSize() - 1;
        }
        return result;
    }

    public List getListForCurrentPage() {
        return this.paginatedList.getList();
    }

    protected List getListForPage(int pageNumber) {
        if (pageNumber == this.paginatedList.getPageNumber()) {
            return this.getListForCurrentPage();
        }
        return null;
    }

    public String getPageNavigationBar(Href baseHref, String pageParameter) {
        int groupSize = this.properties.getPagingGroupSize();
        Pagination pagination = new Pagination(baseHref, pageParameter, this.properties);
        pagination.setCurrent(new Integer(this.paginatedList.getPageNumber()));
        if (this.pageCount == 0) {
            pagination.addPage(1, true);
        }
        int startPage = Math.max(Math.min(this.paginatedList.getPageNumber() - groupSize / 2, this.pageCount - (groupSize - 1)), 1);
        int endPage = Math.min(startPage + groupSize - 1, this.pageCount);
        if (this.paginatedList.getPageNumber() != 1) {
            pagination.setFirst(new Integer(1));
            pagination.setPrevious(new Integer(this.paginatedList.getPageNumber() - 1));
        }
        for (int j = startPage; j <= endPage; ++j) {
            pagination.addPage(j, j == this.paginatedList.getPageNumber());
        }
        if (this.paginatedList.getPageNumber() != this.pageCount) {
            pagination.setNext(new Integer(this.paginatedList.getPageNumber() + 1));
            pagination.setLast(new Integer(this.pageCount));
        }
        String bannerFormat = pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (pagination.isFirst() ? this.properties.getPagingBannerFirst() : (pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        return pagination.getFormattedBanner(this.properties.getPagingPageLink(), this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), bannerFormat);
    }

    public String getSearchResultsSummary() {
        String message;
        Object[] objs;
        if (this.paginatedList.getFullListSize() == 0) {
            objs = new Object[]{this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundNoItems();
        } else if (this.paginatedList.getFullListSize() == 1) {
            objs = new Object[]{this.properties.getPagingItemName()};
            message = this.properties.getPagingFoundOneItem();
        } else if (this.pageCount == 1) {
            objs = new Object[]{new Integer(this.paginatedList.getFullListSize()), this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundAllItems();
        } else {
            objs = new Object[]{new Integer(this.paginatedList.getFullListSize()), this.properties.getPagingItemsName(), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1), new Integer(this.paginatedList.getPageNumber()), new Integer(this.pageCount)};
            message = this.properties.getPagingFoundSomeItems();
        }
        return MessageFormat.format(message, objs);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("paginatedList", (Object)this.paginatedList).append("properties", (Object)this.properties).toString();
    }
}

