/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.ConfDatabase;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConfDatabaseDAO
implements clinical.server.dao.ConfDatabaseDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, ConfDatabase bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_CONF_DATABASE ");
            buf.append(" (UNIQUE_ID,DB_ID,IS_DEFAULT,DB_URL,DB_TYPE,OWNER,MOD_TIME,MOD_USER,FORCE_SCHEMA_OWNER_CHECK,SITE_UNIQUE_ID) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 10; ++i) {
                buf.append('?');
                if (i >= 9) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getUniqueId(), 2);
            ps.setObject(2, bean.getDbId(), 12);
            ps.setObject(3, this.boolean2Number(bean.getIsDefault()), 2);
            ps.setObject(4, bean.getDbUrl(), 12);
            ps.setObject(5, bean.getDbType(), 12);
            ps.setObject(6, bean.getOwner(), 2);
            ps.setTimestamp(7, bean.getModTime() == null ? null : new Timestamp(bean.getModTime().getTime()));
            ps.setObject(8, bean.getModUser(), 2);
            ps.setObject(9, this.boolean2Number(bean.getForceSchemaOwnerCheck()), 2);
            ps.setObject(10, bean.getSiteUniqueId(), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(ConfDatabase bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("UNIQUE_ID");
        buf.append(',');
        buf.append("DB_ID");
        buf.append(',');
        buf.append("IS_DEFAULT");
        buf.append(',');
        buf.append("DB_URL");
        buf.append(',');
        buf.append("DB_TYPE");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MOD_TIME");
        buf.append(',');
        buf.append("MOD_USER");
        buf.append(',');
        buf.append("FORCE_SCHEMA_OWNER_CHECK");
        buf.append(',');
        buf.append("SITE_UNIQUE_ID");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(ConfDatabase bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUE_ID=?");
            qi.values.add(bean.getUniqueId());
            valueSet = true;
        }
        if (bean.getDbId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DB_ID=?");
            qi.values.add(bean.getDbId());
            valueSet = true;
        }
        if (bean.getIsDefault() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("IS_DEFAULT=?");
            qi.values.add(this.boolean2Number(bean.getIsDefault()));
            valueSet = true;
        }
        if (bean.getDbUrl() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DB_URL=?");
            qi.values.add(bean.getDbUrl());
            valueSet = true;
        }
        if (bean.getDbType() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DB_TYPE=?");
            qi.values.add(bean.getDbType());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModTime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_TIME=?");
            qi.values.add(new Timestamp(bean.getModTime().getTime()));
            valueSet = true;
        }
        if (bean.getModUser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_USER=?");
            qi.values.add(bean.getModUser());
            valueSet = true;
        }
        if (bean.getForceSchemaOwnerCheck() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("FORCE_SCHEMA_OWNER_CHECK=?");
            qi.values.add(this.boolean2Number(bean.getForceSchemaOwnerCheck()));
            valueSet = true;
        }
        if (bean.getSiteUniqueId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SITE_UNIQUE_ID=?");
            qi.values.add(bean.getSiteUniqueId());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(ConfDatabase bean, ConfDatabase criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_CONF_DATABASE SET ");
        if (bean.getUniqueId() != null || bean.isNull("uniqueId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUE_ID=? ");
            uqi.setValues.add(bean.getUniqueId());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueId"), uqi);
            valueSet = true;
        }
        if (bean.getDbId() != null || bean.isNull("dbId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DB_ID=? ");
            uqi.setValues.add(bean.getDbId());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("dbId"), uqi);
            valueSet = true;
        }
        if (bean.getIsDefault() != null || bean.isNull("isDefault")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("IS_DEFAULT=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsDefault()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("isDefault"), uqi);
            valueSet = true;
        }
        if (bean.getDbUrl() != null || bean.isNull("dbUrl")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DB_URL=? ");
            uqi.setValues.add(bean.getDbUrl());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("dbUrl"), uqi);
            valueSet = true;
        }
        if (bean.getDbType() != null || bean.isNull("dbType")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DB_TYPE=? ");
            uqi.setValues.add(bean.getDbType());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("dbType"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModTime() != null || bean.isNull("modTime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_TIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModTime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modTime"), uqi);
            valueSet = true;
        }
        if (bean.getModUser() != null || bean.isNull("modUser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_USER=? ");
            uqi.setValues.add(bean.getModUser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("modUser"), uqi);
            valueSet = true;
        }
        if (bean.getForceSchemaOwnerCheck() != null || bean.isNull("forceSchemaOwnerCheck")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("FORCE_SCHEMA_OWNER_CHECK=? ");
            uqi.setValues.add(this.boolean2Number(bean.getForceSchemaOwnerCheck()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("forceSchemaOwnerCheck"), uqi);
            valueSet = true;
        }
        if (bean.getSiteUniqueId() != null || bean.isNull("siteUniqueId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SITE_UNIQUE_ID=? ");
            uqi.setValues.add(bean.getSiteUniqueId());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("siteUniqueId"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public ConfDatabase createObject(ResultSet rs) throws SQLException {
        ConfDatabase obj = new ConfDatabase();
        obj.setUniqueId((BigDecimal)rs.getObject(1));
        obj.setDbId((String)rs.getObject(2));
        obj.setIsDefault(this.convert2Boolean(rs.getObject(3)));
        obj.setDbUrl((String)rs.getObject(4));
        obj.setDbType((String)rs.getObject(5));
        obj.setOwner((BigDecimal)rs.getObject(6));
        if (rs.getTimestamp(7) != null) {
            obj.setModTime(new Date(rs.getTimestamp(7).getTime()));
        }
        obj.setModUser((BigDecimal)rs.getObject(8));
        obj.setForceSchemaOwnerCheck(this.convert2Boolean(rs.getObject(9)));
        obj.setSiteUniqueId((BigDecimal)rs.getObject(10));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfDatabase> find(Connection con, ConfDatabase criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<ConfDatabase> results = new LinkedList<ConfDatabase>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_CONF_DATABASE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ConfDatabase item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, ConfDatabase bean, ConfDatabase criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, ConfDatabase criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_CONF_DATABASE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

