/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.ConfPrivilege;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConfPrivilegeDAO
implements clinical.server.dao.ConfPrivilegeDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, ConfPrivilege bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_CONF_PRIVILEGE ");
            buf.append(" (NAME,DESCRIPTION,OWNER,MOD_TIME,MOD_USER) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 5; ++i) {
                buf.append('?');
                if (i >= 4) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getName(), 12);
            ps.setObject(2, bean.getDescription(), 12);
            ps.setObject(3, bean.getOwner(), 2);
            ps.setTimestamp(4, bean.getModTime() == null ? null : new Timestamp(bean.getModTime().getTime()));
            ps.setObject(5, bean.getModUser(), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(ConfPrivilege bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("NAME");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MOD_TIME");
        buf.append(',');
        buf.append("MOD_USER");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(ConfPrivilege bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getName() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("NAME=?");
            qi.values.add(bean.getName());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModTime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_TIME=?");
            qi.values.add(new Timestamp(bean.getModTime().getTime()));
            valueSet = true;
        }
        if (bean.getModUser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_USER=?");
            qi.values.add(bean.getModUser());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(ConfPrivilege bean, ConfPrivilege criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_CONF_PRIVILEGE SET ");
        if (bean.getName() != null || bean.isNull("name")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("NAME=? ");
            uqi.setValues.add(bean.getName());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("name"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModTime() != null || bean.isNull("modTime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_TIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModTime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modTime"), uqi);
            valueSet = true;
        }
        if (bean.getModUser() != null || bean.isNull("modUser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_USER=? ");
            uqi.setValues.add(bean.getModUser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("modUser"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public ConfPrivilege createObject(ResultSet rs) throws SQLException {
        ConfPrivilege obj = new ConfPrivilege();
        obj.setName((String)rs.getObject(1));
        obj.setDescription((String)rs.getObject(2));
        obj.setOwner((BigDecimal)rs.getObject(3));
        if (rs.getTimestamp(4) != null) {
            obj.setModTime(new Date(rs.getTimestamp(4).getTime()));
        }
        obj.setModUser((BigDecimal)rs.getObject(5));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfPrivilege> find(Connection con, ConfPrivilege criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<ConfPrivilege> results = new LinkedList<ConfPrivilege>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_CONF_PRIVILEGE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ConfPrivilege item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, ConfPrivilege bean, ConfPrivilege criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, ConfPrivilege criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_CONF_PRIVILEGE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

