/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.query;

import clinical.utils.GenUtils;
import clinical.web.DBUtils;
import clinical.web.ISQLDialect;
import clinical.web.common.query.ISymbol;
import clinical.web.common.query.OracleSQLDialect;
import clinical.web.common.query.TSQLParser;
import clinical.web.common.query.TSQLParserException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TSQLProcessor {
    protected ISQLDialect sqlDialect;
    protected static String tablePrefix = "nc_";

    public TSQLProcessor(ISQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> executeQuery(Connection con, String tsqlQuery) throws TSQLParserException, Exception {
        TSQLParser parser = new TSQLParser();
        List<ISymbol> symbolList = parser.parse(tsqlQuery);
        String sql = this.translate(symbolList);
        System.out.println("sql=" + GenUtils.applyWordWrapping(sql));
        ArrayList<Object> results = new ArrayList<Object>();
        Method[] setters = null;
        Statement st = null;
        try {
            Map<String, TSQLParser.VOInfo> voiMap = this.getSelectListTable(symbolList);
            List<TSQLParser.ColumnInfo> ciList = this.getSelectColumnList(symbolList);
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            setters = new Method[rsmd.getColumnCount()];
            int[] colTypes = new int[rsmd.getColumnCount()];
            Class[] voClassArr = new Class[rsmd.getColumnCount()];
            int[] voIdxArr = new int[rsmd.getColumnCount()];
            HashMap voClassMap = new HashMap(7);
            for (TSQLParser.VOInfo voi : voiMap.values()) {
                Class<?> voClass = voi.getVoClass();
                voClassMap.put(voi.getName().toLowerCase(), voClass);
            }
            HashMap<Class, Integer> seenVOClassIdxMap = new HashMap<Class, Integer>(7);
            int classCount = 0;
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String dbColName = rsmd.getColumnName(i + 1).toLowerCase();
                String dbTableName = rsmd.getTableName(i + 1).toLowerCase();
                TSQLParser.VOInfo voInfo = null;
                if (dbTableName.length() == 0) {
                    dbColName = TSQLProcessor.removeChar(dbColName, '_');
                    TSQLParser.ColumnInfo ci = ciList.get(i);
                    dbTableName = ci.getVoInfo().getName().toLowerCase();
                    voInfo = ci.getVoInfo();
                } else {
                    dbTableName = dbTableName.replaceAll("^" + tablePrefix, "");
                    voInfo = voiMap.get(dbTableName);
                }
                assert (voInfo != null);
                PropertyDescriptor pd = voInfo.getPD(dbColName);
                if (pd == null) {
                    dbColName = TSQLProcessor.removeChar(dbColName, '_');
                    pd = voInfo.getPD(dbColName);
                }
                setters[i] = pd.getWriteMethod();
                colTypes[i] = rsmd.getColumnType(i + 1);
                voClassArr[i] = (Class)voClassMap.get(dbTableName);
                int voClassIdx = -1;
                if (seenVOClassIdxMap.get(voClassArr[i]) == null) {
                    voClassIdx = classCount++;
                    seenVOClassIdxMap.put(voClassArr[i], new Integer(voClassIdx));
                } else {
                    voClassIdx = (Integer)seenVOClassIdxMap.get(voClassArr[i]);
                }
                voIdxArr[i] = voClassIdx;
            }
            while (rs.next()) {
                if (voiMap.size() > 1) {
                    Object[] voArr = new Object[voiMap.size()];
                    for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                        Object value = rs.getObject(i + 1);
                        int voClassIdx = voIdxArr[i];
                        if (voArr[voClassIdx] == null) {
                            Class voClass = voClassArr[i];
                            voArr[voClassIdx] = voClass.newInstance();
                        }
                        this.sqlDialect.invokeSetter(setters[i], voArr[voClassIdx], value, colTypes[i]);
                    }
                    results.add(voArr);
                    continue;
                }
                TSQLParser.VOInfo voInfo = voiMap.values().iterator().next();
                Object vo = voInfo.getVoClass().newInstance();
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    Object value = rs.getObject(i + 1);
                    this.sqlDialect.invokeSetter(setters[i], vo, value, colTypes[i]);
                }
                results.add(vo);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            DBUtils.close(st);
            throw throwable;
        }
        DBUtils.close(st);
        return results;
    }

    public static TSQLParser.VOInfo findVO(String propertyName, Map<String, TSQLParser.VOInfo> voiMap) {
        for (TSQLParser.VOInfo voi : voiMap.values()) {
            if (voi.getPD(propertyName) == null) continue;
            return voi;
        }
        return null;
    }

    protected Map<String, TSQLParser.VOInfo> getSelectListTable(List<ISymbol> symbolList) {
        HashMap<String, TSQLParser.VOInfo> map = new HashMap<String, TSQLParser.VOInfo>(7);
        Iterator<ISymbol> iter = symbolList.iterator();
        while (iter.hasNext()) {
            ISymbol symbol = iter.next();
            if (!symbol.getName().toLowerCase().equals("select")) continue;
            symbol = iter.next();
            while (!symbol.getName().equalsIgnoreCase("from")) {
                TSQLParser.ColumnInfo ci;
                String key;
                if (symbol instanceof TSQLParser.ColumnInfo && map.get(key = (ci = (TSQLParser.ColumnInfo)symbol).getVoInfo().getName().toLowerCase()) == null) {
                    map.put(key, ci.getVoInfo());
                }
                symbol = iter.next();
            }
            break block0;
        }
        return map;
    }

    protected List<TSQLParser.ColumnInfo> getSelectColumnList(List<ISymbol> symbolList) {
        ArrayList<TSQLParser.ColumnInfo> list = new ArrayList<TSQLParser.ColumnInfo>(10);
        Iterator<ISymbol> iter = symbolList.iterator();
        while (iter.hasNext()) {
            ISymbol symbol = iter.next();
            if (!symbol.getName().toLowerCase().equals("select")) continue;
            symbol = iter.next();
            while (!symbol.getName().equalsIgnoreCase("from")) {
                if (symbol instanceof TSQLParser.ColumnInfo) {
                    TSQLParser.ColumnInfo ci = (TSQLParser.ColumnInfo)symbol;
                    list.add(ci);
                }
                symbol = iter.next();
            }
            break block0;
        }
        return list;
    }

    protected String translate(List<ISymbol> symbolList) {
        StringBuilder buf = new StringBuilder();
        for (ISymbol symbol : symbolList) {
            if (symbol instanceof TSQLParser.ColumnInfo) {
                this.translateColumnInfo(buf, symbol);
            } else if (symbol instanceof TSQLParser.VOInfo) {
                TSQLParser.VOInfo voInfo = (TSQLParser.VOInfo)symbol;
                buf.append(TSQLProcessor.toDBTableName(voInfo.getName()));
            } else if (symbol instanceof TSQLParser.StringInfo) {
                buf.append(this.sqlDialect.prepareString(symbol.getName()));
            } else if (symbol instanceof TSQLParser.BoolTokenInfo) {
                buf.append(this.sqlDialect.prepareBooleanValue(new Boolean(symbol.getName())));
            } else if (symbol instanceof TSQLParser.FunctionInfo) {
                TSQLParser.FunctionInfo fi = (TSQLParser.FunctionInfo)symbol;
                if (fi.getName().equals("endsWith")) {
                    StringBuilder sb = new StringBuilder();
                    this.translateColumnInfo(sb, fi.params.get(0));
                    String func = this.sqlDialect.endsWithFunction(sb.toString(), fi.params.get(1).getName());
                    buf.append(func);
                }
            } else {
                buf.append(symbol.getName());
            }
            buf.append(' ');
        }
        return buf.toString().trim();
    }

    private void translateColumnInfo(StringBuilder buf, ISymbol symbol) {
        TSQLParser.ColumnInfo ci = (TSQLParser.ColumnInfo)symbol;
        PropertyDescriptor pd = ci.getVoInfo().getPD(ci.getName().toLowerCase());
        if (pd == null) {
            System.err.println("no PD for " + ci.getName().toLowerCase());
        }
        String getMethodName = pd.getReadMethod().getName();
        String dbColumnName = TSQLProcessor.toDBColumnName(getMethodName);
        String tableName = TSQLProcessor.toDBTableName(ci.getVoInfo().getName());
        buf.append(tableName).append('.').append(dbColumnName);
    }

    public static String removeChar(String s, char ch) {
        StringBuilder buf = new StringBuilder(s);
        StringBuilder obuf = new StringBuilder();
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == ch) continue;
            obuf.append(buf.charAt(i));
        }
        return obuf.toString();
    }

    public static String toDBTableName(String voName) {
        StringBuilder buf = new StringBuilder();
        buf.append(tablePrefix);
        char[] carr = voName.toCharArray();
        for (int i = 0; i < carr.length; ++i) {
            if (Character.isUpperCase(carr[i])) {
                if (i > 0) {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(carr[i]));
                continue;
            }
            buf.append(carr[i]);
        }
        return buf.toString();
    }

    public static String toDBColumnName(String getMethodName) {
        String pn = getMethodName;
        pn = pn.replaceFirst("^(get|is)", "");
        StringBuilder buf = new StringBuilder();
        char[] carr = pn.toCharArray();
        for (int i = 0; i < carr.length; ++i) {
            if (Character.isUpperCase(carr[i])) {
                if (i > 0) {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(carr[i]));
                continue;
            }
            buf.append(carr[i]);
        }
        return buf.toString();
    }

    public static void main(String[] args) throws TSQLParserException {
        TSQLProcessor processor = new TSQLProcessor(new OracleSQLDialect());
        String s = "select r.* from Rawdata as r where r.subjectid in ('000894468383', '000862323007') order by r.componentid, r.segmentid asc";
        String s1 = "select a.* from Assessmentdata as a where a.subjectid in ('000894468383', '000862323007') and a.isvalidated = 1 order by a.assessmentid, a.scorename asc";
        String s2 = "select a.* from Assessmentdata as a, Storedassessment as s where a.ncStoredassessmentUniqueid = s.uniqueid and s.isvalidated = 1 and s.subjectid in ('000894468383', '000862323007')";
    }
}

