/*
 * Decompiled with CFR 0.152.
 */
package clinical.xml.gui;

import clinical.xml.XMLUtils;
import clinical.xml.export.ExportClient;
import clinical.xml.gui.ConfigInfo;
import clinical.xml.gui.ParamsDialog;
import clinical.xml.gui.XmlViewPane;
import guilib.AppFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ExportImportClient
extends AppFrame {
    private static final long serialVersionUID = -583110607843047205L;
    JTree expSubjectsTree;
    DefaultMutableTreeNode root;
    XmlViewPane xmlPane;
    JSplitPane splitPane;
    ConfigInfo configInfo = new ConfigInfo();
    ExportClient ec = new ExportClient();

    public ExportImportClient(int width, int height, boolean useHTTPS) throws Exception {
        super(width, height);
        this.setTitle("XCEDE Export Client");
        this.init(useHTTPS);
    }

    protected void init(boolean useHTTPS) throws Exception {
        if (useHTTPS) {
            this.configInfo.setEndPoint("https://localhost:8443/clinical/services/XCEDEService");
        } else {
            this.configInfo.setEndPoint("http://localhost:8080/clinical/services/XCEDEService");
        }
        ParamsDialog dlg = new ParamsDialog((Frame)((Object)this), "Web Service EndPoint Params", this.configInfo);
        int rc = dlg.showDialog();
        this.root = new DefaultMutableTreeNode("<Experiments - Subjects>");
        if (rc == ParamsDialog.OK_PRESSED) {
            Object[] exps = this.ec.getAllExperiments(this.configInfo.getEndPoint(), this.configInfo.getUser(), this.configInfo.getPwd());
            int[] expIDs = (int[])exps[0];
            LinkedHashMap<Integer, String[]> exp2SubjectsMap = new LinkedHashMap<Integer, String[]>();
            int i = 0;
            while (i < expIDs.length) {
                String[] subjects = this.ec.getAllSubjects(this.configInfo.getEndPoint(), this.configInfo.getUser(), this.configInfo.getPwd(), expIDs[i]);
                if (subjects != null) {
                    exp2SubjectsMap.put(new Integer(expIDs[i]), subjects);
                }
                ++i;
            }
            this.populateTree(this.root, exps, exp2SubjectsMap);
        }
        this.expSubjectsTree = new JTree(this.root);
        JScrollPane esPane = new JScrollPane(this.expSubjectsTree);
        this.expSubjectsTree.addMouseListener(new TreeMouseAdapter(this.expSubjectsTree));
        this.xmlPane = new XmlViewPane();
        JScrollPane xmlScroll = new JScrollPane(this.xmlPane);
        xmlScroll.setPreferredSize(new Dimension(400, 400));
        this.splitPane = new JSplitPane(1, esPane, this.xmlPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(220);
        this.getContentPane().add(this.splitPane);
    }

    protected void populateTree(DefaultMutableTreeNode root, Object[] exps, Map exp2SubjectsMap) {
        int[] expIDs = (int[])exps[0];
        String[] expNames = (String[])exps[1];
        int i = 0;
        while (i < expIDs.length) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(new ExperimentInfo(expIDs[i], expNames[i]));
            root.add(child);
            String[] subjects = (String[])exp2SubjectsMap.get(new Integer(expIDs[i]));
            if (subjects != null) {
                int j = 0;
                while (j < subjects.length) {
                    DefaultMutableTreeNode child2 = new DefaultMutableTreeNode(new SubjectInfo(subjects[j], expIDs[i]));
                    child.add(child2);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected JMenu createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.addSeparator();
        JMenuItem item = new JMenuItem("Quit", 81);
        this.fileMenu.add(item);
        item.addActionListener(new CloseAdapter());
        return this.fileMenu;
    }

    public void handleExport(SubjectInfo si, String fileName) {
        try {
            String xmlStr = this.ec.getSubjectData(this.configInfo.getEndPoint(), this.configInfo.getUser(), this.configInfo.getPwd(), si.subjectID, si.expID);
            StringWriter out = new StringWriter();
            XMLUtils.prettyPrint(xmlStr, out);
            this.xmlPane.setXMLContent(out.toString());
            if (fileName != null) {
                this.saveContent(fileName, out.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private void saveContent(String filename, String content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 51->55)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void handleExperimentExport(int expID, String fileName) {
        try {
            String xmlStr = this.ec.getExperimentData(this.configInfo.getEndPoint(), this.configInfo.getUser(), this.configInfo.getPwd(), expID);
            StringWriter out = new StringWriter();
            XMLUtils.prettyPrint(xmlStr, out);
            this.xmlPane.setXMLContent(out.toString());
            if (fileName != null) {
                this.saveContent(fileName, out.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ExportImportClient eic = null;
        boolean useHTTPS = false;
        if (args.length == 1) {
            useHTTPS = args[0].indexOf("https") != -1;
        }
        try {
            eic = new ExportImportClient(650, 450, useHTTPS);
            eic.startup();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    class CloseAdapter
    implements ActionListener {
        CloseAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            ExportImportClient.this.onClose();
        }
    }

    public static class SubjectInfo {
        String subjectID;
        int expID;

        public SubjectInfo(String subjectID, int expID) {
            this.subjectID = subjectID;
            this.expID = expID;
        }

        public String toString() {
            return this.subjectID;
        }
    }

    public static class ExperimentInfo {
        String expName;
        int expID;

        public ExperimentInfo(int expid, String name) {
            this.expID = expid;
            this.expName = name;
        }

        public String toString() {
            return this.expName;
        }
    }

    class TreeMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        JTree tree;
        JPopupMenu popupMenu;
        JMenuItem[] menuItems;
        JFileChooser chooser = new JFileChooser();

        public TreeMouseAdapter(JTree tree) {
            this.tree = tree;
            this.preparePopupMenu();
        }

        protected JMenuItem prepMenuItem(String label) {
            JMenuItem menuItem = new JMenuItem(label);
            menuItem.addActionListener(this);
            this.popupMenu.add(menuItem);
            return menuItem;
        }

        public void preparePopupMenu() {
            this.menuItems = new JMenuItem[10];
            this.popupMenu = new JPopupMenu("");
            this.menuItems[0] = this.prepMenuItem("Export");
        }

        public void mouseReleased(MouseEvent me) {
            this.showPopup(me);
        }

        public void mousePressed(MouseEvent me) {
            this.showPopup(me);
        }

        protected void showPopup(MouseEvent me) {
            DefaultMutableTreeNode node;
            Object userObj;
            TreePath path;
            if (me.isPopupTrigger() && (path = this.tree.getPathForLocation(me.getX(), me.getY())) != null && ((userObj = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SubjectInfo || userObj instanceof ExperimentInfo)) {
                this.popupMenu.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        protected DefaultMutableTreeNode checkSelection() {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (selectedNode == null) {
                JOptionPane.showMessageDialog(this.tree, "You need to select a node first!", "Error", 0);
                return null;
            }
            return selectedNode;
        }

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            if (!(e.getSource() instanceof JMenuItem)) {
                return;
            }
            JMenuItem item = (JMenuItem)e.getSource();
            if (item.getText().equals("Export") && (selectedNode = this.checkSelection()) != null) {
                int rv;
                String fileName = null;
                int rc = JOptionPane.showConfirmDialog((Component)((Object)ExportImportClient.this), "Do you want to save the exported results?", "Save Results", 0);
                if (rc == 0 && (rv = this.chooser.showSaveDialog((Component)((Object)ExportImportClient.this))) == 0) {
                    fileName = this.chooser.getSelectedFile().getAbsolutePath();
                }
                if (selectedNode.getUserObject() instanceof SubjectInfo) {
                    ExportImportClient.this.handleExport((SubjectInfo)selectedNode.getUserObject(), fileName);
                } else if (selectedNode.getUserObject() instanceof ExperimentInfo) {
                    ExperimentInfo ei = (ExperimentInfo)selectedNode.getUserObject();
                    ExportImportClient.this.handleExperimentExport(ei.expID, fileName);
                }
            }
        }
    }
}

