/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeCellEditor;
import edu.sdsc.grid.gui.JargonTreeCellRenderer;
import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.gui.QueryPanel;
import edu.sdsc.grid.gui.TransferStatusPanel;
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JargonTree
extends JTree
implements ActionListener {
    private JPopupMenu popup = null;
    private MouseListener popupListener;
    private GeneralFile copyBuffer = null;
    private GeneralFile[] roots;
    private MetaDataCondition[] conditions;
    private MetaDataSelect[] selects;

    public JargonTree(GeneralFile generalFile) throws IOException {
        this(generalFile, null, null);
    }

    public JargonTree(GeneralFile[] generalFileArray) throws IOException {
        this(generalFileArray, null, null);
    }

    public JargonTree(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this(generalFile, null, metaDataSelectArray);
    }

    public JargonTree(GeneralFile[] generalFileArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this(generalFileArray, null, metaDataSelectArray);
    }

    public JargonTree(GeneralFile generalFile, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        GeneralFile[] generalFileArray = new GeneralFile[]{generalFile};
        this.createJargonTree(generalFileArray, metaDataConditionArray, metaDataSelectArray);
    }

    public JargonTree(GeneralFile[] generalFileArray, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.createJargonTree(generalFileArray, metaDataConditionArray, metaDataSelectArray);
    }

    protected void finalize() throws Throwable {
        if (this.popup != null) {
            this.popup = null;
        }
        if (this.popupListener != null) {
            this.popupListener = null;
        }
        if (this.copyBuffer != null) {
            this.copyBuffer = null;
        }
        if (this.roots != null) {
            this.roots = null;
        }
        if (this.selects != null) {
            this.selects = null;
        }
        super.finalize();
    }

    public GeneralFile getRoot(int n) {
        return this.roots[n];
    }

    public GeneralFile[] getRoots() {
        return this.roots;
    }

    public MetaDataSelect[] getSelects() {
        return this.selects;
    }

    private void createJargonTree(GeneralFile[] generalFileArray, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.roots = generalFileArray;
        this.conditions = metaDataConditionArray;
        this.selects = metaDataSelectArray;
        this.setModel(new JargonTreeModel(generalFileArray, metaDataConditionArray, metaDataSelectArray));
        JargonTreeCellRenderer jargonTreeCellRenderer = new JargonTreeCellRenderer();
        this.setCellRenderer(jargonTreeCellRenderer);
        this.setEditable(true);
        this.setCellEditor(new JargonTreeCellEditor());
    }

    public void useDefaultPopupMenu(boolean bl) {
        if (!bl) {
            this.popup = null;
            if (this.popupListener != null) {
                this.removeMouseListener(this.popupListener);
            }
            return;
        }
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Refresh");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Query");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            GeneralFile generalFile = (GeneralFile)this.getLastSelectedPathComponent();
            if (string.equals("Refresh")) {
                this.refresh(this.getSelectionPath());
            } else if (string.equals("Query")) {
                if (generalFile == null) {
                    JFrame jFrame = new JFrame("Query");
                    jFrame.getContentPane().add(new QueryPanel(this.roots[0].getFileSystem()));
                    jFrame.pack();
                    jFrame.show();
                    jFrame.validate();
                } else {
                    JFrame jFrame = new JFrame("Query");
                    jFrame.getContentPane().add(new QueryPanel(generalFile));
                    jFrame.pack();
                    jFrame.show();
                    jFrame.validate();
                }
            } else if (string.equals("Copy")) {
                if (generalFile != null) {
                    this.copyBuffer = generalFile;
                }
            } else if (string.equals("Paste")) {
                if (this.copyBuffer == null || generalFile == null) {
                    return;
                }
                TransferStatusPanel transferStatusPanel = null;
                if (generalFile.isDirectory() && this.copyBuffer.isFile()) {
                    transferStatusPanel = new TransferStatusPanel(this.copyBuffer, FileFactory.newFile(generalFile, this.copyBuffer.getName()));
                    transferStatusPanel.setOverwrite(2);
                    JFrame jFrame = new JFrame();
                    jFrame.getContentPane().add(transferStatusPanel);
                    jFrame.pack();
                    jFrame.show();
                    transferStatusPanel.start();
                } else {
                    transferStatusPanel = new TransferStatusPanel(this.copyBuffer, generalFile);
                    transferStatusPanel.setOverwrite(2);
                    JFrame jFrame = new JFrame();
                    jFrame.getContentPane().add(transferStatusPanel);
                    jFrame.pack();
                    jFrame.show();
                    transferStatusPanel.start();
                }
                this.refresh(this.getSelectionPath());
            } else if (string.equals("Delete") && generalFile != null) {
                generalFile.delete();
                this.refresh(this.getSelectionPath().getParentPath());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void refresh(TreePath treePath) throws IOException {
        if (treePath == null) {
            this.setSelectionRow(0);
            this.setModel(new JargonTreeModel(this.roots, this.selects));
            return;
        }
        if (((GeneralFile)treePath.getLastPathComponent()).isFile()) {
            treePath = treePath.getParentPath();
        }
        this.setSelectionRow(0);
        this.setModel(new JargonTreeModel(this.roots, this.selects));
        this.expandPath(treePath);
    }

    private JargonTree(String[] stringArray, MetaDataSelect[] metaDataSelectArray) throws URISyntaxException, IOException {
        Object[] objectArray;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("file size", 2, 2000)};
        if (metaDataSelectArray == null) {
            objectArray = new String[]{"File Comments", "file size", "file access constraint", "user name", "definable metadata for files"};
            metaDataSelectArray = MetaDataSet.newSelection((String[])objectArray);
        }
        if (stringArray.length < 1) {
            objectArray = new SRBFileSystem();
            GeneralFile[] generalFileArray = new GeneralFile[]{FileFactory.newFile(new URI("file:///")), FileFactory.newFile((GeneralFileSystem)objectArray, "/"), FileFactory.newFile((GeneralFileSystem)objectArray, objectArray.getHomeDirectory())};
            this.createJargonTree(generalFileArray, null, metaDataSelectArray);
        } else {
            objectArray = new GeneralFile[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray[i] = FileFactory.newFile(new URI(stringArray[i]));
            }
            this.createJargonTree((GeneralFile[])objectArray, null, metaDataSelectArray);
        }
        this.useDefaultPopupMenu(true);
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame("JargonTree");
            JargonTree jargonTree = new JargonTree(stringArray, null);
            JScrollPane jScrollPane = new JScrollPane(jargonTree);
            jScrollPane.setPreferredSize(new Dimension(800, 600));
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.getContentPane().add((Component)jScrollPane, "North");
            jFrame.pack();
            jFrame.show();
            jFrame.validate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(((SRBException)throwable).getStandardMessage());
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.triggerPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.triggerPopup(mouseEvent);
        }

        private void triggerPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (JargonTree.this.getLastSelectedPathComponent() == null) {
                    return;
                }
                JargonTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

