/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.ftp.FTPAccount;
import edu.sdsc.grid.io.ftp.FTPFile;
import edu.sdsc.grid.io.ftp.FTPFileSystem;
import edu.sdsc.grid.io.http.HTTPAccount;
import edu.sdsc.grid.io.http.HTTPFile;
import edu.sdsc.grid.io.http.HTTPFileInputStream;
import edu.sdsc.grid.io.http.HTTPFileOutputStream;
import edu.sdsc.grid.io.http.HTTPFileSystem;
import edu.sdsc.grid.io.http.HTTPRandomAccessFile;
import edu.sdsc.grid.io.irods.IRODSAccount;
import edu.sdsc.grid.io.irods.IRODSFile;
import edu.sdsc.grid.io.irods.IRODSFileInputStream;
import edu.sdsc.grid.io.irods.IRODSFileOutputStream;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import edu.sdsc.grid.io.irods.IRODSMetaDataRecordList;
import edu.sdsc.grid.io.irods.IRODSRandomAccessFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalFileInputStream;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.local.LocalMetaDataRecordList;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileInputStream;
import edu.sdsc.grid.io.srb.SRBFileOutputStream;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public final class FileFactory {
    static HashMap classToType;
    private static final int RAF = 0;
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;
    private static final int RECORD_LIST = 3;

    static void registerFileSystem(GeneralAccount generalAccount, GeneralFileSystem generalFileSystem, GeneralFile generalFile) {
        FileFactory.registerFileSystem(null, generalAccount.getClass(), generalFileSystem.getClass(), generalFile.getClass(), null, null, null, null);
    }

    static void registerFileSystem(URI uRI, GeneralAccount generalAccount, GeneralFileSystem generalFileSystem, GeneralFile generalFile, GeneralRandomAccessFile generalRandomAccessFile) {
        FileFactory.registerFileSystem(uRI, generalAccount.getClass(), generalFileSystem.getClass(), generalFile.getClass(), generalRandomAccessFile.getClass(), null, null, null);
    }

    static void registerFileSystem(URI uRI, GeneralAccount generalAccount, GeneralFileSystem generalFileSystem, GeneralFile generalFile, GeneralRandomAccessFile generalRandomAccessFile, GeneralFileInputStream generalFileInputStream, GeneralFileOutputStream generalFileOutputStream) {
        FileFactory.registerFileSystem(uRI, generalAccount.getClass(), generalFileSystem.getClass(), generalFile.getClass(), generalRandomAccessFile.getClass(), generalFileInputStream.getClass(), generalFileOutputStream.getClass(), null);
    }

    static void registerFileSystem(URI uRI, GeneralAccount generalAccount, GeneralFileSystem generalFileSystem, GeneralFile generalFile, GeneralRandomAccessFile generalRandomAccessFile, GeneralFileInputStream generalFileInputStream, GeneralFileOutputStream generalFileOutputStream, MetaDataRecordList metaDataRecordList) {
        FileFactory.registerFileSystem(uRI, generalAccount.getClass(), generalFileSystem.getClass(), generalFile.getClass(), generalRandomAccessFile.getClass(), generalFileInputStream.getClass(), generalFileOutputStream.getClass(), metaDataRecordList.getClass());
    }

    static void registerFileSystem(URI uRI, Class clazz, Class clazz2, Class clazz3, Class clazz4, Class clazz5, Class clazz6, Class clazz7) {
        if (clazz2 == null) {
            throw new NullPointerException("FileSystem cannot be null");
        }
        if (clazz != null) {
            classToType.put(clazz, clazz2);
        }
        if (uRI != null) {
            classToType.put(uRI.getScheme(), clazz3);
        }
        if (clazz3 != null) {
            classToType.put(clazz2, clazz3);
        }
        Object[] objectArray = new Object[4];
        boolean bl = false;
        if (clazz4 != null) {
            objectArray[0] = clazz4;
        }
        if (clazz5 != null) {
            objectArray[1] = clazz5;
        }
        if (clazz6 != null) {
            objectArray[2] = clazz6;
        }
        if (clazz7 != null) {
            objectArray[3] = clazz7;
        }
        classToType.put(clazz3, objectArray);
    }

    static boolean isFileSystemRegistered(GeneralFileSystem generalFileSystem) {
        return classToType.containsKey(generalFileSystem.getClass());
    }

    private static Object createObject(Constructor constructor, Object[] objectArray) throws IOException {
        block9: {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                if (GeneralFileSystem.DEBUG > 0) {
                    instantiationException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (GeneralFileSystem.DEBUG > 0) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (GeneralFileSystem.DEBUG > 0) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (GeneralFileSystem.DEBUG <= 0) break block9;
                invocationTargetException.printStackTrace();
            }
        }
        return null;
    }

    private static Object fromMap(Object object, Object object2) throws IOException {
        return FileFactory.fromMap(object, new Object[]{object2}, -1);
    }

    private static Object fromMap(Object object, Object[] objectArray) throws IOException {
        return FileFactory.fromMap(object, objectArray, -1);
    }

    private static Object fromMap(Object object, Object object2, int n) throws IOException {
        return FileFactory.fromMap(object, new Object[]{object2}, n);
    }

    private static Object fromMap(Object object, Object[] objectArray, int n) throws IOException {
        if (object != null && objectArray != null) {
            Object object2 = classToType.get(object);
            if (object2 == null) {
                return null;
            }
            if (n == 3) {
                if ((object2 = classToType.get(object2)) == null) {
                    return null;
                }
                object2 = ((Object[])object2)[n];
            } else if (object2 instanceof Object[]) {
                object2 = ((Object[])object2)[n];
            }
            if (object2 == null) {
                throw new UnsupportedOperationException("Class not supported for " + object);
            }
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            try {
                return ((Class)object2).getConstructor(classArray).newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Throwable throwable = noSuchMethodException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(noSuchMethodException);
                throw runtimeException;
            }
            catch (InstantiationException instantiationException) {
                Throwable throwable = instantiationException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(instantiationException);
                throw runtimeException;
            }
            catch (IllegalAccessException illegalAccessException) {
                Throwable throwable = illegalAccessException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(illegalAccessException);
                throw runtimeException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Throwable throwable = illegalArgumentException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(illegalArgumentException);
                throw runtimeException;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(invocationTargetException);
                throw runtimeException;
            }
        }
        return null;
    }

    public static GeneralFileSystem newFileSystem(GeneralAccount generalAccount) throws IOException {
        GeneralFileSystem generalFileSystem = (GeneralFileSystem)FileFactory.fromMap(generalAccount.getClass(), generalAccount);
        if (generalFileSystem == null) {
            return new LocalFileSystem();
        }
        return generalFileSystem;
    }

    public static GeneralFileSystem newFileSystem(URI uRI) throws IOException {
        GeneralFileSystem generalFileSystem = ((GeneralFile)FileFactory.fromMap((Object)uRI.getScheme(), uRI)).getFileSystem();
        if (generalFileSystem == null) {
            return new LocalFileSystem();
        }
        return generalFileSystem;
    }

    public static GeneralFileSystem newFileSystem(URI uRI, Object object) throws IOException {
        GeneralFileSystem generalFileSystem = ((GeneralFile)FileFactory.fromMap((Object)uRI.getScheme(), new Object[]{uRI, object})).getFileSystem();
        if (generalFileSystem == null) {
            return new LocalFileSystem();
        }
        return generalFileSystem;
    }

    public static GeneralFile newFile(URI uRI) throws IOException {
        if (uRI.getScheme().equals("file")) {
            return new LocalFile(uRI);
        }
        GeneralFile generalFile = (GeneralFile)FileFactory.fromMap((Object)uRI.getScheme(), uRI);
        if (generalFile == null) {
            return new LocalFile(uRI);
        }
        return generalFile;
    }

    public static GeneralFile newFile(URI uRI, String string) throws IOException {
        int n = -1;
        String string2 = uRI.getUserInfo();
        Class clazz = (Class)classToType.get(uRI.getScheme());
        if (clazz != null && string != null) {
            if (uRI.getScheme().equals("file")) {
                return new LocalFile(uRI);
            }
            if (string.indexOf(":") >= 0 || string.indexOf("@") >= 0) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            if (clazz.equals(SRBFile.class) && (string2 == null || string2 == "")) {
                string2 = "public.npaci:CANDO";
            } else {
                n = string2.indexOf(":");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                string2 = string2 + ":" + string;
            }
            try {
                uRI = new URI(uRI.getScheme(), string2, uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
        }
        return FileFactory.newFile(uRI);
    }

    public static GeneralFile newFile(URI uRI, Object object) throws IOException {
        int n = -1;
        String string = uRI.getUserInfo();
        String string2 = null;
        if (uRI.getScheme().equals("srb")) {
            String string3;
            String string4;
            if (string == null || string == "") {
                string4 = "public";
                string3 = "npaci";
            } else {
                n = string.indexOf(":");
                if (n >= 0) {
                    string4 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                } else {
                    string4 = string;
                }
                n = string4.indexOf(".");
                if (n >= 0) {
                    string4 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                } else {
                    throw new IllegalArgumentException("No SRB domain given");
                }
            }
            SRBAccount sRBAccount = new SRBAccount(uRI.getHost(), uRI.getPort(), string4, string2, "/home/" + string4 + "." + string3, string3, null);
            sRBAccount.setGSSCredential(object);
            return FileFactory.newFile(sRBAccount, uRI.getPath());
        }
        return new LocalFile(uRI);
    }

    static GeneralFile newFile(URI uRI, String string, String string2) throws IOException {
        GeneralFile generalFile = (GeneralFile)FileFactory.fromMap((Object)uRI.getScheme(), new Object[]{uRI, string, string2});
        if (generalFile == null) {
            return new LocalFile(uRI);
        }
        return generalFile;
    }

    public static GeneralFile newFile(GeneralAccount generalAccount, String string) throws IOException {
        GeneralFile generalFile = (GeneralFile)FileFactory.fromMap(generalAccount.getClass(), new Object[]{generalAccount, string});
        if (generalFile == null) {
            return new LocalFile(string);
        }
        return generalFile;
    }

    public static GeneralFile newFile(GeneralAccount generalAccount, String string, String string2) throws IOException {
        GeneralFile generalFile = (GeneralFile)FileFactory.fromMap(generalAccount.getClass(), new Object[]{generalAccount, string, string2});
        if (generalFile == null) {
            return new LocalFile(string, string2);
        }
        return generalFile;
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string) {
        GeneralFile generalFile;
        block3: {
            generalFile = null;
            try {
                generalFile = (GeneralFile)FileFactory.fromMap(generalFileSystem.getClass(), new Object[]{generalFileSystem, string});
                if (generalFile == null) {
                    return new LocalFile(string);
                }
            }
            catch (IOException iOException) {
                if (GeneralFileSystem.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return generalFile;
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string, String string2) {
        GeneralFile generalFile;
        block3: {
            generalFile = null;
            try {
                generalFile = (GeneralFile)FileFactory.fromMap(generalFileSystem.getClass(), new Object[]{generalFileSystem, string, string2});
                if (generalFile == null) {
                    return new LocalFile(string, string2);
                }
            }
            catch (IOException iOException) {
                if (GeneralFileSystem.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return generalFile;
    }

    public static GeneralFile newFile(GeneralFile generalFile, String string) {
        GeneralFile generalFile2;
        block3: {
            generalFile2 = null;
            try {
                generalFile2 = (GeneralFile)FileFactory.fromMap(generalFile.getFileSystem().getClass(), new Object[]{generalFile, string});
                if (generalFile2 == null) {
                    return new LocalFile((LocalFile)generalFile, string);
                }
            }
            catch (IOException iOException) {
                if (GeneralFileSystem.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return generalFile2;
    }

    static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string, MetaDataCondition[] metaDataConditionArray) throws NullPointerException, IOException {
        GeneralFile generalFile = FileFactory.newFile(generalFileSystem, string);
        generalFile.mkdir();
        MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(new String[]{"file name", "directory name"});
        MetaDataRecordList[] metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray);
        if (metaDataRecordListArray == null) {
            return generalFile;
        }
        for (int i = 0; i < metaDataRecordListArray.length; ++i) {
            ((SRBFile)FileFactory.newFile(generalFileSystem, metaDataRecordListArray[i].getStringValue(1), metaDataRecordListArray[i].getStringValue(0))).link((SRBFile)FileFactory.newFile(generalFile, metaDataRecordListArray[i].getStringValue(0) + "_" + i));
        }
        return generalFile;
    }

    public static GeneralRandomAccessFile newRandomAccessFile(GeneralFileSystem generalFileSystem, String string, String string2) throws IOException {
        return FileFactory.newRandomAccessFile(FileFactory.newFile(generalFileSystem, string), string2);
    }

    public static GeneralRandomAccessFile newRandomAccessFile(GeneralFile generalFile, String string) throws IOException {
        GeneralRandomAccessFile generalRandomAccessFile = (GeneralRandomAccessFile)FileFactory.fromMap(generalFile.getClass(), new Object[]{generalFile, string}, 0);
        if (generalRandomAccessFile == null) {
            return new LocalRandomAccessFile((LocalFile)generalFile, string);
        }
        return generalRandomAccessFile;
    }

    public static GeneralRandomAccessFile newRandomAccessFile(URI uRI, String string) throws IOException {
        return FileFactory.newRandomAccessFile(FileFactory.newFile(uRI), string);
    }

    public static GeneralFileInputStream newFileInputStream(GeneralFile generalFile) throws IOException {
        GeneralFileInputStream generalFileInputStream = (GeneralFileInputStream)FileFactory.fromMap(generalFile.getClass(), new Object[]{generalFile}, 1);
        if (generalFileInputStream == null) {
            return new LocalFileInputStream((LocalFile)generalFile);
        }
        return generalFileInputStream;
    }

    public static GeneralFileInputStream newFileInputStream(URI uRI) throws IOException {
        return FileFactory.newFileInputStream(FileFactory.newFile(uRI));
    }

    public static GeneralFileOutputStream newFileOutputStream(GeneralFile generalFile) throws IOException {
        GeneralFileOutputStream generalFileOutputStream = (GeneralFileOutputStream)FileFactory.fromMap(generalFile.getClass(), new Object[]{generalFile}, 2);
        if (generalFileOutputStream == null) {
            return new LocalFileOutputStream((LocalFile)generalFile);
        }
        return generalFileOutputStream;
    }

    public static GeneralFileOutputStream newFileOutputStream(URI uRI) throws IOException {
        return FileFactory.newFileOutputStream(FileFactory.newFile(uRI));
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, int n) {
        return FileFactory.newMetaDataRecordList(generalFileSystem, metaDataField, n + "", true);
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, float f) {
        return FileFactory.newMetaDataRecordList(generalFileSystem, metaDataField, f + "", true);
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, String string) {
        return FileFactory.newMetaDataRecordList(generalFileSystem, metaDataField, string, true);
    }

    public static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, MetaDataTable metaDataTable) {
        return FileFactory.newMetaDataRecordList(generalFileSystem, metaDataField, metaDataTable, true);
    }

    private static MetaDataRecordList newMetaDataRecordList(GeneralFileSystem generalFileSystem, MetaDataField metaDataField, Object object, boolean bl) {
        MetaDataRecordList metaDataRecordList;
        block3: {
            metaDataRecordList = null;
            try {
                metaDataRecordList = (MetaDataRecordList)FileFactory.fromMap(generalFileSystem.getClass(), new Object[]{metaDataField, object}, 3);
                if (metaDataRecordList == null) {
                    return new LocalMetaDataRecordList();
                }
            }
            catch (IOException iOException) {
                if (GeneralFileSystem.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return metaDataRecordList;
    }

    static {
        block11: {
            block10: {
                block9: {
                    block8: {
                        classToType = new HashMap();
                        try {
                            FileFactory.registerFileSystem(new URI("srb://fake"), SRBAccount.class, SRBFileSystem.class, SRBFile.class, SRBRandomAccessFile.class, SRBFileInputStream.class, SRBFileOutputStream.class, SRBMetaDataRecordList.class);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            if (GeneralFileSystem.DEBUG <= 0) break block8;
                            uRISyntaxException.printStackTrace();
                        }
                    }
                    try {
                        FileFactory.registerFileSystem(new URI("irods://fake"), IRODSAccount.class, IRODSFileSystem.class, IRODSFile.class, IRODSRandomAccessFile.class, IRODSFileInputStream.class, IRODSFileOutputStream.class, IRODSMetaDataRecordList.class);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        if (GeneralFileSystem.DEBUG <= 0) break block9;
                        uRISyntaxException.printStackTrace();
                    }
                }
                try {
                    FileFactory.registerFileSystem(new URI("http://fake"), HTTPAccount.class, HTTPFileSystem.class, HTTPFile.class, HTTPRandomAccessFile.class, HTTPFileInputStream.class, HTTPFileOutputStream.class, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (GeneralFileSystem.DEBUG <= 0) break block10;
                    uRISyntaxException.printStackTrace();
                }
            }
            try {
                FileFactory.registerFileSystem(new URI("ftp://fake"), FTPAccount.class, FTPFileSystem.class, FTPFile.class, null, null, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                if (GeneralFileSystem.DEBUG <= 0) break block11;
                uRISyntaxException.printStackTrace();
            }
        }
    }
}

