/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.ftp;

import edu.sdsc.grid.io.RemoteAccount;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class FTPAccount
extends RemoteAccount {
    public FTPAccount(String string, int n, String string2, String string3, String string4) {
        super(string, n, string2, string3, string4);
    }

    protected void finalize() {
        super.finalize();
    }

    public void setHomeDirectory(String string) {
        if (string == null) {
            throw new NullPointerException("The home directory string cannot be null");
        }
        this.homeDirectory = string;
    }

    public void setPort(int n) {
        this.port = n > 0 ? n : 21;
    }

    URI getURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URI");
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URI");
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            FTPAccount fTPAccount = (FTPAccount)object;
            if (!this.getHost().equals(fTPAccount.getHost())) {
                return false;
            }
            if (this.getPort() != fTPAccount.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(fTPAccount.getUserName())) {
                return false;
            }
            return this.getPassword().equals(fTPAccount.getPassword());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return new String("ftp://" + this.getUserName() + "@" + this.getHost() + ":" + this.getPort() + this.getHomeDirectory());
    }
}

