/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFileInputStream;
import edu.sdsc.grid.io.irods.IRODSFile;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import java.io.IOException;

public class IRODSFileInputStream
extends RemoteFileInputStream {
    long filePointer = 0L;
    protected IRODSFileSystem fileSystem;
    IRODSFile file;

    public IRODSFileInputStream(IRODSFileSystem iRODSFileSystem, String string) throws IOException {
        super(iRODSFileSystem, string);
        this.fileSystem = iRODSFileSystem;
    }

    public IRODSFileInputStream(IRODSFile iRODSFile) throws IOException {
        super(iRODSFile);
        this.fileSystem = (IRODSFileSystem)iRODSFile.getFileSystem();
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (IRODSFileSystem)generalFileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    protected void open(GeneralFile generalFile) throws IOException {
        this.file = (IRODSFile)generalFile;
        this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.fileSystem.commands.fileRead(this.fd, byArray, n, n2);
        this.filePointer += (long)n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.available();
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.filePointer + l < l2) {
            this.fileSystem.commands.fileSeek(this.fd, l, 1);
            this.filePointer += l;
            return l;
        }
        this.fileSystem.commands.fileSeek(this.fd, l2, 1);
        this.filePointer += l2;
        return l2;
    }

    public int available() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file size")};
        int n = 0;
        try {
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                n = (int)(Long.parseLong(metaDataRecordListArray[0].getValue("file size").toString()) - this.filePointer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n <= 0) {
            return 0;
        }
        return n;
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.commands.fileClose(this.fd);
            this.fileSystem = null;
        }
        if (this.file != null) {
            this.file = null;
        }
    }

    public String toString() {
        return "Input: " + this.file;
    }
}

