/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.ProtocolCatalog;
import edu.sdsc.grid.io.RemoteFileSystem;
import edu.sdsc.grid.io.srb.GSIAuth;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBProtocol;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import org.ietf.jgss.GSSCredential;

public class SRBFileSystem
extends RemoteFileSystem {
    public static final String SRB_ROOT = "/";
    public static final int DELETE_TYPE_LOCATION = 1;
    public static final int DELETE_TYPE_USER = 2;
    public static final int DELETE_TYPE_RESOURCE = 3;
    static final int USER_INFO_BUFFER_LENGTH = 400;
    static final int USER_INFO_BUFFER_LENGTH_3_0 = 464;
    static final int MDAS_PASSWORD_LENGTH = 32;
    static int DEFAULT_RECORDS_WANTED;
    public static final int PORTAL_OFF = 0;
    public static final int PORTAL_ON = 1;
    public static final int PORTAL_STD_IN_OUT = 2;
    static int TOTAL_METADATA_ATTRIBUTES;
    static int MAX_TOKEN;
    static int MAX_FILE_SIZE;
    static String TICKET_USER;
    static String TICKET_USER_DOMAIN;
    public static final String PATH_SEPARATOR;
    private SRBCommands commands;
    private SRBAccount srbAccount;
    private String version;
    private float versionNumber;
    int MIN_PORT = -1;
    int MAX_PORT = -1;
    static int writeBufferSize;

    public SRBFileSystem() throws FileNotFoundException, IOException {
        this(new SRBAccount());
    }

    public SRBFileSystem(SRBAccount sRBAccount) throws IOException, NullPointerException {
        String string;
        this.setAccount(sRBAccount);
        this.commands = new SRBCommands();
        int n = 0;
        try {
            int n2 = sRBAccount.getOptions();
            if ((n2 == 51 || n2 == 54) && sRBAccount.getUserName() == null && sRBAccount.getDomainName() == null) {
                SRBAccount sRBAccount2 = new SRBAccount(sRBAccount.getHost(), sRBAccount.getPort(), "ticketuser", "", "", "sdsc", "");
                SRBFileSystem sRBFileSystem = new SRBFileSystem(sRBAccount2);
                String string2 = GSIAuth.getDN(sRBAccount);
                GSSCredential gSSCredential = null;
                try {
                    gSSCredential = GSIAuth.getCredential(sRBAccount);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Invalid or missing credentials");
                }
                sRBAccount2 = sRBFileSystem.srbGetUserByDn(0, string2);
                if (sRBAccount2 == null) {
                    String string3 = "/E=";
                    int n3 = string2.indexOf(string3);
                    if (n3 >= 0) {
                        sRBAccount2 = sRBFileSystem.srbGetUserByDn(0, string2 = string2.substring(0, n3) + "/emailAddress=" + string2.substring(n3 + string3.length()));
                        if (sRBAccount2 == null) {
                            throw new SRBException("User not found for DN=" + string2);
                        }
                    } else {
                        throw new SRBException("User not found for DN=" + string2);
                    }
                }
                sRBAccount.setUserName(sRBAccount2.getUserName());
                sRBAccount.setProxyUserName(sRBAccount2.getProxyUserName());
                sRBAccount.setDomainName(sRBAccount2.getDomainName());
                sRBAccount.setProxyDomainName(sRBAccount2.getProxyDomainName());
                sRBAccount.setMcatZone(sRBAccount2.getMcatZone());
                sRBAccount.setHomeDirectory(sRBAccount2.getHomeDirectory());
                if (sRBAccount.getGSSCredential() == null) {
                    sRBAccount.setGSSCredential(gSSCredential);
                }
                this.setAccount(sRBAccount);
            }
            n = this.commands.connect(sRBAccount, this.createUserInfoBuffer());
        }
        catch (ProtocolException protocolException) {
            n = this.commands.connect(sRBAccount, this.createUserInfoBuffer());
        }
        if (n == -1118) {
            System.err.println("SRB client/server version mismatch. Trying alternate handshake. error: " + n);
            this.setVersion(sRBAccount.getVersion());
            this.commands = new SRBCommands();
            n = this.commands.connect(sRBAccount, this.createUserInfoBuffer());
        } else if (n == -1107 || n == -1113) {
            n = this.commands.connect(sRBAccount, this.createUserInfoBuffer());
        }
        if (n < 0) {
            throw new SRBException("Connection Failed", n);
        }
        if (sRBAccount.getDefaultStorageResource() == null && (string = SRBFile.getAvailableResource(this)) != null) {
            sRBAccount.setDefaultStorageResource(string);
            this.setAccount(sRBAccount);
        }
        if (sRBAccount.getHomeDirectory() == null) {
            sRBAccount.setHomeDirectory(SRBFile.separator + "home" + SRBFile.separator + sRBAccount.getUserName() + "." + sRBAccount.getDomainName());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SRBFile.uriFileSystems.remove(this);
        this.close();
        if (this.commands != null) {
            this.commands = null;
        }
        if (this.account != null) {
            this.account = null;
        }
    }

    protected void setAccount(GeneralAccount generalAccount) throws IOException {
        if (generalAccount == null) {
            generalAccount = new SRBAccount();
        }
        this.srbAccount = (SRBAccount)generalAccount.clone();
        this.account = this.srbAccount;
        SRBFileSystem sRBFileSystem = this;
        this.setVersion(sRBFileSystem.srbAccount.getVersion());
    }

    private void setVersion(String string) {
        if (string == null) {
            return;
        }
        this.version = string;
        SRBFileSystem sRBFileSystem = this;
        this.versionNumber = sRBFileSystem.srbAccount.getVersionNumber();
        if ((double)this.versionNumber >= 3.3) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 2700;
        } else if ((double)this.versionNumber >= 3.02) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 2700;
        } else if (this.versionNumber >= 3.0f) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 500;
        } else if (this.versionNumber >= 2.0f) {
            TOTAL_METADATA_ATTRIBUTES = 300;
            MAX_TOKEN = 200;
            MAX_FILE_SIZE = 400;
        } else if (this.versionNumber >= 1.0f) {
            TOTAL_METADATA_ATTRIBUTES = 180;
            MAX_TOKEN = 200;
            MAX_FILE_SIZE = 400;
        } else {
            throw new IllegalArgumentException("Invalid version");
        }
    }

    public static void setWriteBufferSize(int n) {
        if (n > 0) {
            writeBufferSize = n;
        }
    }

    public static int getWriteBufferSize() {
        return writeBufferSize;
    }

    public GeneralAccount getAccount() throws NullPointerException {
        if (this.srbAccount != null) {
            return (SRBAccount)this.srbAccount.clone();
        }
        throw new NullPointerException();
    }

    public String[] getRootDirectories() {
        return roots;
    }

    void setDefaultStorageResource(String string) {
        this.srbAccount.setDefaultStorageResource(string);
    }

    void setProxyMcatZone(String string) {
        this.srbAccount.setProxyMcatZone(string);
    }

    void setMcatZone(String string) {
        this.srbAccount.setMcatZone(string);
    }

    public void setFirewallPorts(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.MIN_PORT = n;
            this.MAX_PORT = n2;
        }
    }

    public void setQueryRecordsWanted(int n) {
        if (n > 0) {
            DEFAULT_RECORDS_WANTED = n;
        }
    }

    public int getQueryRecordsWanted() {
        return DEFAULT_RECORDS_WANTED;
    }

    public String getPassword() {
        return this.srbAccount.getPassword();
    }

    byte[] getPasswordBytes() {
        byte[] byArray = new byte[32];
        System.arraycopy(this.srbAccount.getPassword().getBytes(), 0, byArray, 0, this.srbAccount.getPassword().length());
        return byArray;
    }

    public String getProxyUserName() {
        return this.srbAccount.getProxyUserName();
    }

    public String getProxyDomainName() {
        return this.srbAccount.getProxyDomainName();
    }

    public int getOptions() {
        return this.srbAccount.getOptions();
    }

    public String getDomainName() {
        return this.srbAccount.getDomainName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultStorageResource() {
        return this.srbAccount.getDefaultStorageResource();
    }

    public String getProxyMcatZone() {
        return this.srbAccount.getProxyMcatZone();
    }

    public String getMcatZone() {
        return this.srbAccount.getMcatZone();
    }

    public String getExecFile() {
        return this.srbAccount.getExecFile();
    }

    public float getVersionNumber() {
        return this.versionNumber;
    }

    long fileCopyStatus() {
        return this.commands.getBytesMoved();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, n, false, false);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n, boolean bl) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, n, bl, false);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n, boolean bl, boolean bl2) throws IOException {
        block5: {
            int n2;
            boolean bl3 = false;
            if (metaDataConditionArray == null) break block5;
            for (n2 = 0; n2 < metaDataConditionArray.length; ++n2) {
                if (metaDataConditionArray[n2] == null || !metaDataConditionArray[n2].getFieldName().equals("directory name") && !metaDataConditionArray[n2].getFieldName().equals("parent directory name") && !metaDataConditionArray[n2].getFieldName().equals("container name")) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                for (n2 = 0; n2 < metaDataConditionArray.length; ++n2) {
                    if (metaDataConditionArray[n2] == null || !metaDataConditionArray[n2].getFieldName().equals("current zone")) continue;
                    metaDataConditionArray[n2] = MetaDataSet.newCondition("directory name", 0, "MCAT_NAME=" + metaDataConditionArray[n2].getStringValue());
                    break;
                }
            } else {
                for (n2 = 0; n2 < metaDataConditionArray.length; ++n2) {
                    if (metaDataConditionArray[n2] == null || !metaDataConditionArray[n2].getFieldName().equals("current zone")) continue;
                    metaDataConditionArray[n2] = null;
                    break;
                }
            }
        }
        return this.srbGenQuery(SRBFile.catalogType, null, metaDataConditionArray, metaDataSelectArray, n, bl, bl2);
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            SRBFileSystem sRBFileSystem = (SRBFileSystem)object;
            if (this.getAccount().equals(sRBFileSystem.getAccount()) && this.isConnected() == sRBFileSystem.isConnected()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    public boolean isConnected() {
        return this.commands.isConnected();
    }

    public String toString() {
        return new String("srb://" + this.getUserName() + "." + this.getDomainName() + "@" + this.getHost() + ":" + this.getPort());
    }

    public void close() throws IOException {
        this.commands.close();
    }

    public boolean isClosed() throws IOException {
        return this.commands.isClosed();
    }

    private byte[] createUserInfoBuffer() {
        byte[] byArray = null;
        byte[] byArray2 = new byte[]{0, 0, 1, -112};
        int n = 7;
        String string = null;
        if (this.getVersion().equals("SRB2.0.0jargon_v2.0.0beta&D") || this.getVersion().equals("SRB1.1.8jargon_v2.0.0beta&C")) {
            byArray = new byte[400];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[4] = n;
            System.arraycopy(this.getProxyUserName().getBytes(), 0, byArray, 8, this.getProxyUserName().length());
            System.arraycopy(this.getProxyDomainName().getBytes(), 0, byArray, 40, this.getProxyDomainName().length());
            System.arraycopy(this.getUserName().getBytes(), 0, byArray, 72, this.getUserName().length());
            System.arraycopy(this.getDomainName().getBytes(), 0, byArray, 104, this.getDomainName().length());
            byArray[136] = (byte)this.getOptions();
            System.arraycopy(this.getVersion().getBytes(), 0, byArray, 264, this.getVersion().length());
        } else {
            byArray = new byte[464];
            byArray2[3] = -48;
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[4] = n;
            System.arraycopy(this.getProxyUserName().getBytes(), 0, byArray, 8, this.getProxyUserName().length());
            System.arraycopy(this.getProxyDomainName().getBytes(), 0, byArray, 40, this.getProxyDomainName().length());
            string = this.getProxyMcatZone();
            if (string != null) {
                System.arraycopy(this.getProxyMcatZone().getBytes(), 0, byArray, 72, this.getProxyMcatZone().length());
            }
            System.arraycopy(this.getUserName().getBytes(), 0, byArray, 104, this.getUserName().length());
            System.arraycopy(this.getDomainName().getBytes(), 0, byArray, 136, this.getDomainName().length());
            string = this.getMcatZone();
            if (string != null) {
                System.arraycopy(this.getMcatZone().getBytes(), 0, byArray, 168, this.getMcatZone().length());
            }
            System.arraycopy(this.getVersion().getBytes(), 0, byArray, 200, this.getVersion().length());
            byArray[264] = (byte)this.getOptions();
            if (this.getExecFile() != null) {
                System.arraycopy(this.getExecFile().getBytes(), 0, byArray, 328, this.getExecFile().length());
            }
        }
        return byArray;
    }

    public InputStream executeProxyCommand(String string, String string2) throws IOException {
        return this.srbExecCommand(string, string2, null, -1);
    }

    public InputStream executeProxyCommand(String string, String string2, String string3, int n) throws IOException {
        return this.srbExecCommand(string, string2, string3, n);
    }

    public InputStream executeProxyCommand(String string, String string2, String string3, String string4, int n) throws IOException {
        return this.srbExecCommand(string, string2, string3, string4, n);
    }

    public void registerURL(SRBFile sRBFile, URL uRL) throws IOException {
        this.srbRegisterDataset(0, sRBFile.getName(), "URL", sRBFile.getResource(), sRBFile.getParent(), uRL.toString(), 0L);
    }

    int srbObjCreate(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (string2 == null) {
            string2 = "generic";
        }
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        if (string4 == null) {
            string4 = this.getHomeDirectory();
        } else if (!string4.startsWith(SRB_ROOT)) {
            string4 = this.getHomeDirectory() + SRBFile.separator + string4;
        }
        if (string5 == null) {
            string5 = "";
        }
        return this.commands.srbObjCreate(n, string, string2, string3, string4, string5, l);
    }

    int srbObjOpen(String string, int n, String string2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        return this.commands.srbObjOpen(string, n, string2);
    }

    void srbObjClose(int n) throws IOException {
        this.commands.srbObjClose(n);
    }

    void srbObjUnlink(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        this.commands.srbObjUnlink(string, string2);
    }

    byte[] srbObjRead(int n, int n2) throws IOException {
        return this.commands.srbObjRead(n, n2);
    }

    int srbObjWrite(int n, byte[] byArray, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        return this.commands.srbObjWrite(n, byArray, n2);
    }

    void srbObjSeek(int n, long l, int n2) throws IOException {
        this.commands.srbObjSeek(n, l, n2);
    }

    void srbObjSync(int n) throws IOException {
        this.commands.srbObjSync(n);
    }

    long[] srbObjStat(int n, String string, int n2) throws IOException {
        if (string == null) {
            string = this.getHomeDirectory();
        } else if (!string.startsWith(SRB_ROOT)) {
            string = this.getHomeDirectory() + SRBFile.separator + string;
        }
        if (n2 > 4 || n2 < -1) {
            n2 = -1;
        }
        return this.commands.srbObjStat(n, string, n2);
    }

    long[] srbObjStat64(int n, String string, String string2) throws IOException {
        if (string == null) {
            string = this.getHomeDirectory();
        } else if (!string.startsWith(SRB_ROOT)) {
            string = this.getHomeDirectory() + SRBFile.separator + string;
        }
        if (string.substring(string.length() - 1) != SRBFile.separator) {
            string = string.substring(string.length() - 1) == System.getProperty("file.separator") ? string.substring(0, string.length() - 2) + SRBFile.separator : string + SRBFile.separator;
        }
        return this.commands.srbObjStat64(n, string + string2);
    }

    void srbObjReplicate(int n, String string, String string2, String string3, String string4) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        this.commands.srbObjReplicate(n, string, string2, string3, string4);
    }

    void srbObjMove(int n, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + string2;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = this.getDefaultStorageResource();
        }
        if (string6 == null) {
            string6 = "";
        }
        this.commands.srbObjMove(n, string, string2, string3, string4, string5, string6);
    }

    byte[] srbObjProxyOpr(int n, int n2, int n3, int n4, int n5, String string, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        return this.commands.srbObjProxyOpr(n, n2, n3, n4, n5, string, string2, string3, string4, byArray, byArray2, byArray3);
    }

    void srbCollSeek(int n, int n2, int n3, int n4) throws IOException {
        this.commands.srbCollSeek(n, n2, n3, n4);
    }

    SRBMetaDataRecordList[] srbGetDatasetInfo(int n, String string, String string2, int n2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + string2;
        }
        if (n2 < 1) {
            n2 = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetDatasetInfo(n, string, string2, n2);
    }

    SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (n2 < 1) {
            n2 = DEFAULT_RECORDS_WANTED;
        }
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = this.commands.srbGenQuery(n, string, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
        return sRBMetaDataRecordListArray;
    }

    void srbRegisterDataset(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (string2 == null) {
            string2 = "generic";
        }
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        if (string4 == null) {
            string4 = this.getHomeDirectory();
        } else if (!string4.startsWith(SRB_ROOT)) {
            string4 = this.getHomeDirectory() + string4;
        }
        this.commands.srbRegisterDataset(n, string, string2, string3, string4, string5, l);
    }

    int srbModifyDataset(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        if (string4 != null || string3 != null) {
            MetaDataSelect[] metaDataSelectArray;
            MetaDataCondition[] metaDataConditionArray;
            MetaDataRecordList[] metaDataRecordListArray;
            if (string3 == null) {
                string3 = this.getDefaultStorageResource();
            } else if ((string4 == null || string4.equals("")) && (metaDataRecordListArray = this.query(metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("file name", 0, string), MetaDataSet.newCondition("directory name", 0, string2)}, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("PATH_NAME")}, 3)) != null) {
                string4 = metaDataRecordListArray[0].getValue("PATH_NAME").toString();
            }
        }
        return this.commands.srbModifyDataset(n, string, string2, string3, string4, string5, string6, n2);
    }

    void srbChkMdasAuth(String string, String string2, String string3) throws IOException {
        if (string == null || string2 == null) {
            throw new NullPointerException("Null value entered for Mdas authorization");
        }
        if (string3 == null) {
            string3 = this.getDomainName();
        }
        this.commands.srbChkMdasAuth(string, string2, string3);
    }

    void srbCreateCollect(int n, String string, String string2) throws IOException {
        if (string == null) {
            string = this.getHomeDirectory();
        } else if (!string.startsWith(SRB_ROOT)) {
            string = this.getHomeDirectory() + SRBFile.separator + string;
        }
        this.commands.srbCreateCollect(n, string, string2);
    }

    SRBMetaDataRecordList[] srbListCollect(int n, String string, String string2, int n2) throws IOException {
        if (string == null) {
            string = this.getHomeDirectory();
        } else if (!string.startsWith(SRB_ROOT)) {
            string = this.getHomeDirectory() + SRBFile.separator + string;
        }
        if (n2 < 1) {
            n2 = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbListCollect(n, string, string2, n2);
    }

    void srbModifyCollect(int n, String string, String string2, String string3, String string4, int n2) throws IOException {
        if (string == null) {
            string = this.getHomeDirectory();
        } else if (!string.startsWith(SRB_ROOT)) {
            string = this.getHomeDirectory() + SRBFile.separator + string;
        }
        this.commands.srbModifyCollect(n, string, string2, string3, string4, n2);
    }

    void srbChkMdasSysAuth(String string, String string2, String string3) throws IOException {
        this.commands.srbChkMdasSysAuth(string, string2, string3);
    }

    public void srbRegisterUserGrp(int n, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.commands.srbRegisterUserGrp(n, string, string2, string3, string4, string5, string6);
    }

    public void srbRegisterUser(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        this.commands.srbRegisterUser(n, string, string2, string3, string4, string5, string6, string7);
    }

    public void srbModifyUser(int n, String string, String string2, int n2) throws IOException {
        if (n < 0) {
            n = 0;
        }
        this.commands.srbModifyUser(n, string, string2, n2);
    }

    int srbSetAuditTrail(int n) throws IOException {
        return this.commands.srbSetAuditTrail(n);
    }

    void srbObjAudit(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n2, String string8) throws IOException {
        if (string5 == null) {
            string5 = this.getDefaultStorageResource();
        }
        if (string3 == null) {
            string3 = this.getHomeDirectory();
        } else if (!string3.startsWith(SRB_ROOT)) {
            string3 = this.getHomeDirectory() + SRBFile.separator + string3;
        }
        this.commands.srbObjAudit(n, string, string2, string3, string4, string5, string6, string7, n2, string8);
    }

    void srbRegisterReplica(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        this.commands.srbRegisterReplica(n, string, string2, string3, string4, string5, string6, string7, string8);
    }

    SRBMetaDataRecordList[] srbGetPrivUsers(int n, int n2) throws IOException {
        if (n2 < 1) {
            n2 = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetPrivUsers(n, n2);
    }

    SRBMetaDataRecordList[] srbGetMoreRows(int n, int n2, int n3) throws IOException {
        if (n3 < 1) {
            n3 = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetMoreRows(n, n2, n3);
    }

    void srbIssueTicket(String string, String string2, String string3, String string4, String string5, int n, String string6) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        this.commands.srbIssueTicket(string, string2, string3, string4, string5, n, string6);
    }

    void srbRemoveTicket(String string) throws IOException {
        this.commands.srbRemoveTicket(string);
    }

    void srbUnregisterDataset(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        this.commands.srbUnregisterDataset(string, string2);
    }

    void srbContainerCreate(int n, String string, String string2, String string3, long l) throws IOException {
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        this.commands.srbContainerCreate(n, string, string2, string3, l);
    }

    void srbRegisterContainer(int n, String string, String string2, long l) throws IOException {
        if (string2 == null) {
            string2 = this.getDefaultStorageResource();
        }
        this.commands.srbRegisterContainer(n, string, string2, l);
    }

    void srbRegisterInContDataset(int n, String string, String string2, String string3, String string4, long l, long l2) throws IOException {
        if (string4 == null) {
            string4 = "generic";
        }
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        this.commands.srbRegisterInContDataset(n, string, string2, string3, string4, l, l2);
    }

    SRBMetaDataRecordList[] srbGetContainerInfo(int n, String string, int n2) throws IOException {
        if (n2 < 1) {
            n2 = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetContainerInfo(n, string, n2);
    }

    String srbGetResOnChoice(int n, String string, String string2, String string3) throws IOException {
        return this.commands.srbGetResOnChoice(n, string, string2, string3);
    }

    void srbRmContainer(int n, String string, boolean bl) throws IOException {
        this.commands.srbRmContainer(n, string, bl);
    }

    void srbSyncContainer(int n, String string, int n2) throws IOException {
        this.commands.srbSyncContainer(n, string, n2);
    }

    void srbReplContainer(int n, String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = this.getDefaultStorageResource();
        }
        this.commands.srbReplContainer(n, string, string2);
    }

    int srbObjOpenWithTicket(String string, int n, String string2, String string3) throws IOException {
        return 0;
    }

    void srbRegInternalCompObj(String string, String string2, int n, int n2, String string3, String string4, long l, long l2, int n3, int n4, int n5, String string5) throws IOException {
        this.commands.srbRegInternalCompObj(string, string2, n, n2, string3, string4, l, l2, n3, n4, n5, string5);
    }

    void srbRmIntCompObj(String string, String string2, int n, int n2, int n3, int n4) throws IOException {
        this.commands.srbRmIntCompObj(string, string2, n, n2, n3, n4);
    }

    void srbRmCompObj(String string, String string2, int n, int n2) throws IOException {
        this.commands.srbRmCompObj(string, string2, n, n2);
    }

    void srbModInternalCompObj(String string, String string2, int n, int n2, int n3, int n4, String string3, String string4, String string5, String string6, int n5) throws IOException {
        this.commands.srbModInternalCompObj(string, string2, n, n2, n3, n4, string3, string4, string5, string6, n5);
    }

    public void srbModifyRescInfo(int n, String string, int n2, String string2, String string3, String string4, String string5) throws IOException {
        this.commands.srbModifyRescInfo(n, string, n2, string2, string3, string4, string5);
    }

    public void srbRegisterLocation(String string, String string2, String string3, String string4, String string5) throws IOException {
        this.commands.srbRegisterLocation(string, string2, string3, string4, string5);
    }

    public void srbIngestToken(String string, String string2, String string3) throws IOException {
        this.commands.srbIngestToken(string, string2, string3);
    }

    public void srbRegisterResource(String string, String string2, String string3, String string4, String string5, int n) throws IOException {
        this.commands.srbRegisterResource(string, string2, string3, string4, string5, n);
    }

    public void srbRegisterLogicalResource(String string, String string2, String string3, String string4) throws IOException {
        this.commands.srbRegisterLogicalResource(string, string2, string3, string4);
    }

    public void srbRegisterReplicateResourceInfo(String string, String string2, String string3, String string4) throws IOException {
        this.commands.srbRegisterReplicateResourceInfo(string, string2, string3, string4);
    }

    public void srbDeleteValue(int n, String string) throws IOException {
        this.commands.srbDeleteValue(n, string);
    }

    InputStream srbExecCommand(String string, String string2, String string3, int n) throws IOException {
        if (string == null) {
            throw new NullPointerException("No command given");
        }
        if (n < 0 || n > 2) {
            n = 2;
        }
        return this.commands.srbExecCommand(string, string2, string3, n, this.MIN_PORT, this.MAX_PORT);
    }

    InputStream srbExecCommand(String string, String string2, String string3, String string4, int n) throws IOException {
        if (string == null) {
            throw new NullPointerException("No command given");
        }
        if (string4 != null && string3 != null) {
            string3 = null;
        }
        if (n < 0 || n > 2) {
            n = 2;
        }
        return this.commands.srbExecCommand(string, string2, string3, string4, n, this.MIN_PORT, this.MAX_PORT);
    }

    void srbSyncData(SRBFile sRBFile) throws IOException {
        if (sRBFile == null) {
            throw new NullPointerException("No file given");
        }
        this.commands.srbSyncData(SRBFile.catalogType, sRBFile.getName(), sRBFile.getParent(), sRBFile.getResource());
    }

    int srbContainerOpen(int n, String string, int n2) throws IOException {
        if (string == null) {
            throw new NullPointerException("No container given");
        }
        return this.commands.srbContainerOpen(n, string, n2);
    }

    void srbContainerClose(int n) throws IOException {
        this.commands.srbContainerClose(n);
    }

    long srbObjCopy(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (string == null) {
            throw new NullPointerException("No container given");
        }
        return this.commands.srbObjCopy(string, string2, string3, string4, string5);
    }

    long srbObjPutClientInitiated(String string, String string2, String string3, String string4, String string5, String string6, long l, int n, int n2) throws IOException {
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        if (string4 == null) {
            string4 = "generic";
        }
        if (string5 == null) {
            string5 = "";
        }
        return this.commands.srbObjPutClientInitiated(string, string2, string3, string4, string5, string6, l, n, n2);
    }

    synchronized long srbObjGetClientInitiated(String string, String string2, GeneralFile generalFile, int n, int n2, boolean bl) throws IOException {
        if (string == null || string2 == null || generalFile == null) {
            throw new NullPointerException();
        }
        if (n2 < 1) {
            n2 = 1;
        }
        return this.commands.srbObjGetClientInitiated(string, string2, generalFile, n, n2, bl);
    }

    void srbBulkRegister(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (sRBMetaDataRecordListArray == null) {
            throw new NullPointerException();
        }
        this.commands.srbBulkRegister(n, string, sRBMetaDataRecordListArray);
    }

    void srbGetMcatZone(String string, String string2, String string3) throws IOException {
        this.commands.srbGetMcatZone(string, string2, string3);
    }

    String srbSetupSessionPublicKey() throws IOException {
        return this.commands.srbSetupSessionPublicKey();
    }

    void srbSetupSession(String string) throws IOException {
        this.commands.srbSetupSession(string);
    }

    void srbBulkLoad(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (sRBMetaDataRecordListArray == null) {
            throw new NullPointerException();
        }
        if (sRBMetaDataRecordListArray.length == 0) {
            return;
        }
        this.commands.srbBulkLoad(n, string, sRBMetaDataRecordListArray);
    }

    void srbBulkUnload(int n, int n2, String string, String string2) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.commands.srbBulkUnload(n, n2, string, string2);
    }

    public void srbModifyZone(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        this.commands.srbModifyZone(n, string, string2, string3, string4, string5, string6, n2);
    }

    MetaDataRecordList[] srbBulkQueryAnswer(int n, String string, MetaDataRecordList metaDataRecordList, int n2) throws IOException {
        return this.commands.srbBulkQueryAnswer(n, string, metaDataRecordList, n2);
    }

    void srbBulkMcatIngest(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        this.commands.srbBulkMcatIngest(n, string, sRBMetaDataRecordListArray);
    }

    synchronized void srbBackupData(int n, String string, String string2, String string3, int n2) throws IOException {
        if (string2 == null) {
            string2 = this.getHomeDirectory();
        } else if (!string2.startsWith(SRB_ROOT)) {
            string2 = this.getHomeDirectory() + SRBFile.separator + string2;
        }
        if (string3 == null) {
            string3 = this.getDefaultStorageResource();
        }
        this.commands.srbBackupData(n, string, string2, string3, n2);
    }

    byte[] srbObjChksum(String string, String string2, int n, String string3) throws IOException {
        return this.commands.srbObjChksum(string, string2, n, string3);
    }

    void srbModifyUserNonPriv(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        this.commands.srbModifyUserNonPriv(n, string, string2, string3, string4, string5, string6, n2);
    }

    void srbModifyResource(int n, String string, String string2, String string3, String string4, String string5, int n2) throws IOException {
        if (string == null) {
            string = this.getDefaultStorageResource();
        }
        this.commands.srbModifyResource(n, string, string2, string3, string4, string5, n2);
    }

    public SRBAccount srbGetUserByDn(int n, String string) throws IOException {
        if (string == null) {
            return null;
        }
        String string2 = this.commands.srbGetUserByDn(n, 0, string);
        if (string2 == null) {
            return null;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n2 = 0;
        int n3 = string2.indexOf(":");
        if (n2 < 0) {
            string3 = "";
        }
        string3 = string2.substring(n2, n3);
        n2 = n3;
        n3 = string2.indexOf("@");
        if (n2 < 0) {
            return null;
        }
        string4 = string2.substring(n2 + 1, n3);
        string5 = string2.substring(n3 + 1, string2.length() - 1);
        SRBAccount sRBAccount = new SRBAccount(this.srbAccount.getHost(), this.srbAccount.getPort(), string4, null, SRBFile.PATH_SEPARATOR + string3 + SRBFile.PATH_SEPARATOR + "home" + SRBFile.PATH_SEPARATOR + string4 + "." + string5, string5, this.srbAccount.getDefaultStorageResource());
        return sRBAccount;
    }

    String srbObjProc(int n, String string, String string2, int n2) throws IOException {
        byte[] byArray = this.commands.srbObjProc(n, string, string2, n2);
        if (byArray != null) {
            return new String(byArray);
        }
        return null;
    }

    void srbModifyExtMetaData(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n2) throws IOException {
        this.commands.srbModifyExtMetaData(n, string, string2, string3, string4, string5, string6, string7, n2);
    }

    static {
        roots = new String[]{SRB_ROOT};
        DEFAULT_RECORDS_WANTED = 300;
        TICKET_USER = "ticketuser";
        TICKET_USER_DOMAIN = "sdsc";
        PATH_SEPARATOR = SRBFile.separator;
        writeBufferSize = 65535;
        if (!ProtocolCatalog.has(new SRBProtocol())) {
            ProtocolCatalog.add(new SRBProtocol());
        }
    }
}

