/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter12Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int BELOW_CJK = 12287;
    static final int INVALID_ORA_CHAR = 65535;
    int m_ucsL1KeyMask = 0;
    int m_ucsL2KeyMask = 0;
    int m_oraL1KeyMask = 0;
    int m_oraL2KeyMask = 0;
    public int m_ucsL1KeyWidth = 0;
    public int m_ucsL1KeyShift = 0;
    public int m_oraL1KeyWidth = 0;
    public int m_oraL1KeyShift = 0;
    public char[] m_ucsCharLevel1 = null;
    public char[] m_ucsCharLevel2 = null;
    public char m_ucsCharReplacement = '\u0000';
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[][] extraUnicodeToOracleMapping = null;
    static final short MAX_7BIT = 127;

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        char c;
        this.m_ucsL1KeyShift = 16 - this.m_ucsL1KeyWidth;
        this.m_ucsL1KeyMask = (1 << this.m_ucsL1KeyWidth) - 1;
        this.m_ucsL2KeyMask = (1 << this.m_ucsL1KeyShift) - 1;
        int n5 = this.m_oraL1KeyWidth;
        int n6 = 16 - n5;
        int n7 = (1 << n5) - 1;
        int n8 = (1 << n6) - 1;
        this.m_oraL1KeyShift = n6;
        this.m_oraL1KeyMask = n7;
        this.m_oraL2KeyMask = n8;
        int n9 = 1 << n5;
        char[] cArray = new char[n9];
        char[][] cArray2 = new char[n9][2];
        int n10 = 0;
        while (n10 < n9) {
            cArray[n10] = '\u0000';
            cArray2[n10][0] = (char)n8;
            cArray2[n10][1] = '\u0000';
            ++n10;
        }
        int n11 = 65536;
        char c2 = this.m_ucsCharReplacement;
        n10 = 0;
        while (n10 < n11) {
            c = this.toUnicodeWithReplacement(n10);
            if (c != c2) {
                n4 = c >> n6 & n7;
                cArray[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
            }
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n11 = this.extraUnicodeToOracleMapping.length;
            n10 = 0;
            while (n10 < n11) {
                c = this.extraUnicodeToOracleMapping[n10][0];
                n4 = c >> n6 & n7;
                cArray[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
                ++n10;
            }
        }
        int n12 = n2 = n8 + 1;
        int n13 = 0;
        n10 = 0;
        while (n10 < n9) {
            if (cArray[n10] != '\u0000') {
                int n14 = cArray2[n10][0];
                cArray[n10] = (char)(n12 - (n13 < n14 ? n13 : n14));
                n12 = cArray[n10] + n2;
                n13 = n2 - cArray2[n10][1] - 1;
            }
            ++n10;
        }
        char[] cArray3 = new char[n12];
        n10 = 0;
        while (n10 < n12) {
            cArray3[n10] = 65535;
            ++n10;
        }
        n11 = 65536;
        n10 = 0;
        while (n10 < n11) {
            c = this.toUnicodeWithReplacement(n10);
            if (c != c2 && cArray3[n = cArray[n4 = c >> n6 & n7] + (n3 = c & n8)] == '\uffff') {
                cArray3[n] = (char)n10;
            }
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n11 = this.extraUnicodeToOracleMapping.length;
            n10 = 0;
            while (n10 < n11) {
                c = this.extraUnicodeToOracleMapping[n10][0];
                n4 = c >> n6 & n7;
                n3 = c & n8;
                n = cArray[n4] + n3;
                if (cArray3[n] == '\uffff') {
                    cArray3[n] = this.extraUnicodeToOracleMapping[n10][1];
                }
                ++n10;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = cArray3;
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 65535;
        int n3 = n;
        while (n3 <= n2) {
            try {
                int[] nArray = new int[]{n3, this.toUnicode(n3)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n3;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n][0], this.extraUnicodeToOracleMapping[n][1]};
            vector.addElement(nArray);
            ++n;
        }
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public char getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    char toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        char c2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (c2 == '\uffff') {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return c2;
    }

    char toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n2 = c & this.m_oraL2KeyMask;
        char c2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (c2 == '\uffff') {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c2;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = this.toOracleCharacter(cArray[n3]);
            int n4 = c & 0xFF00;
            if (n4 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
            }
            byArray[n2++] = (byte)c;
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = this.toOracleCharacterWithReplacement(cArray[n3]);
            int n4 = c & 0xFF00;
            if (n4 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
            }
            byArray[n2++] = (byte)c;
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    char toUnicode(int n) throws SQLException {
        int n2 = n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n3 = n & this.m_ucsL2KeyMask;
        char c = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
        if (c == this.m_ucsCharReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = byArray[n4] & 0xFF;
            if (n6 > 127) {
                if (n4 < n3 - 1) {
                    n6 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    ++n4;
                } else {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
            }
            cArray[n5++] = this.toUnicode(n6);
            ++n4;
        }
        return new String(cArray, 0, n5);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = byArray[n4] & 0xFF;
            if (n6 > 127) {
                if (n3 - n4 < 2) break;
                n6 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                ++n4;
            }
            cArray[n5++] = this.toUnicodeWithReplacement(n6);
            ++n4;
        }
        return new String(cArray, 0, n5);
    }

    char toUnicodeWithReplacement(int n) {
        int n2 = n >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n3 = n & this.m_ucsL2KeyMask;
        return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
    }
}

